#include "stm32f103c8t6.h"
#include "mbed.h"

BusOut      display(PB_4,PB_3,PA_15,PA_12,PA_11,PA_10,PA_9,PA_8);
BusOut      multiplexaje(PA_3,PA_2,PA_1,PA_0);
BusIn       entrada(PB_0,PB_1,PB_10,PB_11);
BusOut      salida(PB_6,PB_7,PB_8,PB_9);


uint8_t Numero[4][4]=
{
    {0x42,0xB6,0xBC,0xFA},
    {0xD8,0xEC,0xEE,0xCE},
    {0x38,0xFE,0xFC,0x86},
    {0x80,0x7E,0xFA,0x9E}    
};

uint8_t catodo[]=
{
    //0b0001,0b0010,0b0100,0b1000
    0x01,0x02,0x04,0x08
};

uint8_t fila[]=
{
    0x01,0x02,0x04,0x08
};   

uint8_t columna[]=
{
    //0b0001,0b0010,0b0100,0b1000
    0x01,0x02,0x04,0x08
};  
      
void Encender(int C,int F);
    
int main() 
{
    
    while(1) 
    {                      
        for(int i=0; i<4; i++)
        {
            salida=columna[i];
            
            if(entrada!=0)
            {
                if(entrada==fila[0])
                {
                    Encender(i,0);                   
                }else if(entrada==fila[1])
                    {
                        Encender(i,1);
                    }else if(entrada==fila[2])
                        {
                            Encender(i,2);
                        }else if(entrada==fila[3])
                            {
                                Encender(i,3);
                            }
            }
        }    
    }
}


void Encender(int C,int F)
{
    multiplexaje=catodo[0];
   
    display=Numero[F][C];          
    wait_ms(200);
    
    multiplexaje=0x00;
    display=0x00;
}