/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-F103C8_I2C_Scanner
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed Compiler
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Esta utileria inspecciona el bus I2C y enumera los dispositivos
**         conectados. Proporciona su dirección base (en DEC y HEX).
**   Componentes     : I2C, Serial and Digital Output.
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Date           : 20/10/2019
**   Bugs & Fixes   :
**
** Permission is hereby granted, free of charge, to any person obtaining a copy
** of this software and associated documentation files (the "Software"), to deal
** in the Software without restriction, including without limitation the rights
** to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
** copies of the Software, and to permit persons to whom the Software is
** furnished to do so, subject to the following conditions:
**
** The above copyright notice and this permission notice shall be included in
** all copies or substantial portions of the Software.
**
** THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
** IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
** FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
** AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
** LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
** OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
** THE SOFTWARE.
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "I2C.h"
#include "Serial.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define Buzz_Off        0               // Estado del Buzzer Apagado
#define Buzz_On         1               // Estado del Buzzer Encendido
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalOut  led_monitor(Green_Led); // Inicializa el LED Monitor
DigitalOut  buzzer (PB_1);          // Inicializa el Buzzer Piezo Eléctrico
//Serial      terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial a la PC

/*
** -------------------------------------------------------------------
**    Inicialización de los Pines de Funciones Especiales.
** -------------------------------------------------------------------
*/
/************************************************* 
* Initialize the library with the numbers of the interface pins
* Board STM32F103C8
* IDE  Mbed On Line Compiler
* LCD  I2C  PCF8574A
* Pin  Board    LCD
*      I2C_SCL  SCL (white) + resistance pull-up 4.7k
*      I2C_SDA  SDA (blue)  + resistance pull-up 4.7k
*      5V       5V  (red)
*      GND      GND (black)
***************************************************/
//LiquidCrystal_I2C lcd(0x7E, LCDCOLUMNAS, LCDFILAS);
//i2c_LCD lcd(0x7E, LCDCOLUMNAS, LCDFILAS);

/**************************************************/ 
// Host PC Communication channels
//Serial      terminal(USBTX, USBRX);         // Tx, Rx 
//Serial      terminal(PA_9, PA_10);          // Tx, Rx Using MAX3232 or BlueTooth
Serial      terminal(PA_2,PA_3);            // Tx, Rx Terminal Serial (TTL Level)

// Bluetooth Communication support
//Serial   bluetooth(PA_2, PA_3);             // Tx, Rx

// I2C Communication
I2C         i2c_wire(PB_7,PB_6);             // SDA, SCL
//I2C         i2c_wire(PB_9,PB_8);             // SDA, SCL
//I2C         i2c_wire(I2C_SDA,I2C_SCL);       // SDA, SCL
//I2C         i2c_wire(PB_11,PB_10);           // SDA, SCL (Alternativo)

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
                // Las variables globales del usuario van aquí !
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void I2C_Scanner(void); 

/* END Definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                            // Inicialización de variables, puertos e interrupciones
  confSysClock();            // Inicialización del Sistema, Configure system clock (72MHz HSE clock, 48MHz USB clock)
  terminal.baud(115200);     // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  terminal.printf(" System is Wake Up!.\n\r");

/* Prueba del Buzzer */    
  terminal.printf("Testing Buzzer... \n\r");   
  buzzer = Buzz_On;
  wait_ms(750);
  buzzer = Buzz_Off;
  wait_ms(125);
  buzzer = Buzz_On;
  wait_ms(250);
  buzzer = Buzz_Off;   
  wait_ms(125);
  buzzer = Buzz_On;
  wait_ms(500);
  buzzer = Buzz_Off;

    while (true)             // El Lazo del Programa principal está aquí !!!
    {
      I2C_Scanner(); 
      terminal.printf ("\n\rVolver a Diagnosticar?\n\r");
      getchar();
    }
}
/* END Main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
                // Los Servicios a Interrupciones van aquí !
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void I2C_Scanner()
{     
  terminal.printf ("I2C scanner. Scanning ...");
  uint8_t count = 0;
//  char     test[] = {0x55,0xAA,0x0F,0xF0,0xFF,0x00};   // Patrón de Prueba
                    
  char     test[] = { 0b00000000, 0b00000000, // Datos en DB7=DB6=DB5=DB4=0, LED+=0, EN=0,RW=0,RS=0   // Patrón de Prueba LCD (LSN first)
                      0b00111110, 0b00111010, // Datos en DB5=DB4=1, LED+=1, EN=1,0,RW=1,RS=0
                      0b00111110, 0b00111010, // Datos en DB5=DB4=1, LED+=1, EN=1,0,RW=1,RS=0
                      0b00111110, 0b00111010, // Datos en DB5=DB4=1, LED+=1, EN=1,0,RW=1,RS=0 
                      0b00101110, 0b00100010, // Datos en DB5=1, LED+=1, EN=1,0,RW=1,RS=0                       
                      0b00101110, 0b00100010, // => Function Set Control: DB5=1, LED+=1, EN=1,0,RW=1,RS=0 
                      0b10001110, 0b10001110, // => Function Set Control: DB7=N=1 2 líneas, DB6=F=0 5x7puntos, LED+=1, EN=1,0,RW=1,RS=0
                      0b00001110, 0b00000010, // => Display ON/OFF Control: DB7=DB6=DB5=DB4=0, LED+=1, EN=1,0,RW=1,RS=0 
                      0b00101110, 0b00100010, // => Display ON/OFF Control: DB7=1 (Display off, cursor off, blink off),LED+=1, EN=1,0,RW=1,RS=0
                      0b00001110, 0b00000010, // => Display Clear: DB7=DB6=DB5=DB4=0, LED+=1, EN=1,0,RW=1,RS=0 
                      0b00011110, 0b00010010, // => Display Clear: D4=1, LED+=1, EN=1,0,RW=1,RS=0
                      0b00001110, 0b00000010, // => Cursor Home: DB7=DB6=DB5=DB4=0, LED+=1, EN=1,0,RW=1,RS=0                                          
                      0b00101110, 0b00100010, // => Cursor Home: DB5=1, LED+=1, EN=1,0,RW=1,RS=0 , (Cursor Home};
                      0b01001111, 0b00001011, // => Text 0x48: DB5=1, LED+=1, EN=1,0,RW=1,RS=1                                          
                      0b10001111, 0b00101011, // => Text "H" : DB7=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "H"}
                      0b01101111, 0b01101011, // => Text 0x6F: DB5=1, LED+=1, EN=1,0,RW=1,RS=1
                      0b11111111, 0b11111011, // => Text "o" : DB7=DB6=DB5=DB4=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "o"}
                      0b01101111, 0b01101011, // => Text 0x6C: DB6=DB5=1, LED+=1, EN=1,0,RW=1,RS=1                                          
                      0b11001111, 0b11001011, // => Text "l" : DB7=DB6=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "l"}
                      0b01101111, 0b01101011, // => Text 0x61: DB6=DB5=1, LED+=1, EN=1,0,RW=1,RS=1                                          
                      0b00011111, 0b00011011, // => Text "a" : DB4=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "a"}
                      0b00101111, 0b00101011, // => Text 0x21: DB5=1, LED+=1, EN=1,0,RW=1,RS=1                                          
                      0b00011111, 0b00011011};// => Text "!" : DB4=1, LED+=1, EN=1,0,RW=1,RS=1 , (ASCII "!"}
/*                      
  char    test[] = { 0b00000000, 0b00000000, // RS=0,RW=1, EN=0, LED+=1, DB4=DB5=DB6=DB7=0  // Patrón de Prueba para LCD (MSN first)
                     0b01111100, 0b01011100, // RS=0,RW=1, EN=1,0, LED+=1, DB5=DB4=1 en datos,
                     0b01111100, 0b01011100, // RS=0,RW=1, EN=1,0, LED+=1, DB5=DB4=1 en datos,
                     0b01111100, 0b01011100, // RS=0,RW=1, EN=1,0, LED+=1, DB5=DB4=1 en datos, 
                     0b01110100, 0b01010100, // RS=0,RW=1, EN=1,0, LED+=1, DB5=1 en datos,
                     0b01100100, 0b00100100, // => Function Set Control: RS=0, RW=1, EN=1,0, LED+=1, DB5=1 en datos, 
                     0b01100110, 0b00100001, // => Function Set Control: RS=0, RW=1, EN=1,0, LED+=1, DB7=N=1 2 líneas, DB6=F=0 5x7puntos,
                     0b01100000, 0b00100000, // => Display ON/OFF Control: RS=0, RW=1, EN=1,0, LED+=1, DB4=DB5=DB6=DB7=0 en datos,
                     0b01100001, 0b00100001, // => Display ON/OFF Control: RS=0, RW=1, EN=1,0, LED+=1, DB7=1 (Display off, cursor off, blink off)
                     0b01100000, 0b00100000, // => Display Clear: RS=0, RW=1, EN=1,0, LED+=1, DB4=DB5=DB6=DB7=0 en datos
                     0b01101000, 0b00101000, // => Display Clear: RS=0, RW=1, EN=1,0, LED+=1, DB4=1 en datos, (Clear Diplay)
                     0b01100000, 0b00100000, // => Cursor Home: RS=0, RW=1, EN=1,0, LED+=1, DB4=DB5=DB6=DB7=0 en datos
                     0b01101000, 0b00101000, // => Cursor Home: RS=0, RW=1, EN=1,0, LED+=1, DB5=1 en datos, (Cursor Home)
                     0b11110100, 0b11010100, // => Text 0x48: RS=1, RW=1, EN=1,0, LED+=1, DB5=1,     (ASCII "H")                                         
                     0b11110001, 0b11010001, // => Text "H" : RS=1, RW=1, EN=1,0, LED+=1, DB7=1
                     0b11110110, 0b11010110, // => Text 0x6F: RS=1, RW=1, EN=1,0, LED+=1, DB5=DB6=1, (ASCII "o")
                     0b11111111, 0b11011111, // => Text "o" : RS=1, RW=1, EN=1,0, LED+=1, DB4=DB5=DB6=DB7=1
                     0b11110110, 0b11010110, // => Text 0x6C: RS=1, RW=1, EN=1,0, LED+=1, DB5=DB6=1, (ASCII "l")                                
                     0b11110011, 0b11010011, // => Text "l" : RS=1, RW=1, EN=1,0, LED+=1, DB6=DB7=1
                     0b11110110, 0b11010110, // => Text 0x61: RS=1, RW=1, EN=1,0, LED+=1, DB5=DB6=1, (ASCII "a")                                          
                     0b11111000, 0b11011000, // => Text "a" : RS=1, RW=1, EN=1,0, LED+=1, DB4=1
                     0b11110100, 0b11010100, // => Text 0x21: RS=1, RW=1, EN=1,0, LED+=1, DB5=1,     (ASCII "!")                                         
                     0b11111000, 0b11011000};// => Text "!" : RS=1, RW=1, EN=1,0, LED+=1, DB4=1
*/                   
  i2c_wire.frequency(100000);       // Frecuencia de operación para el I2C (100KHz)
  i2c_wire.start();                 // Inicio de operación para el I2C
  for (int i = 8; i < 128; i++)
  {
    uint8_t acknoledge = i2c_wire.write (i,test,46,1);    //(dirección, ap_datos, N°_datos, repetición) 
    if (acknoledge == 0)
    {
      terminal.printf ("\n\rFound address: ");
      terminal.printf ("%u DEC",i);             // Valor de la dirección en Decimal
      terminal.printf (" (0x%x HEX)\n\r",i);    // Valor de la dirección en Hexadecimal   
//      terminal.printf (" (0x%hd HEX)\n\r",i); // Valor de la dirección en Hexadecimal
      count++; 
      wait (1);                                 // Tal vez Innecesario?
    } // end of good response
      led_monitor = !led_monitor;               // Parapadeo del LED      
  } // end of for loop
  led_monitor = 1;                              // Apaga el LED 
  i2c_wire.stop();                              // Fin de operación para el I2C  
  terminal.printf ("\n\rDone.\n\r");
  terminal.printf ("Found %d Device(s)\n\r",count);
}  // end of setup                 

/* END Functions */    
                
/* END Program */

/* END Mbed */ 