/* mbed Microcontroller Library
 *******************************************************************************
 * Copyright (c) 2014, STMicroelectronics
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of STMicroelectronics nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *******************************************************************************
 
 */
#ifndef MBED_PINNAMES_H
#define MBED_PINNAMES_H

#include "cmsis.h"
#include "PinNamesTypes.h"

#ifdef __cplusplus
extern "C" {
#endif

//UART to AMB8826
#define TXD1      PA_9
#define RXD1      PA_10
#define CTS1      PA_11
int baudRate = 115200;

//UART to Silicon Labs CP210x
#define TXD2      PA_2
#define RXD2      PA_3

//UART to FTDI
#define TXD3      PB_10
#define RXD3      PB_11

//I2C
#define I2C1_SCL  PB_6
#define I2C1_SDA  PB_7

#define I2C2_SCL  PB_10
#define I2C2_SDA  PB_11

//SPI
#define SPI1_MOSI PA_7
#define SPI1_MISO PA_6
#define SPI1_SCLK PA_5
#define SPI1_NSS1 PA_4
#define SDsel     PA_4

#define SPI2_MOSI PB_15
#define SPI2_MISO PB_14
#define SPI2_SCLK PB_13
#define SPI2_NSS2 PB_12

//CAN
#define CAN1_RX   PA_11
#define CAN1_TX   PA_12

//USB   CDC
#define USB_POS   PA_12
#define USB_NEG   PA_11

//ADC
#define Uin       PA_1
#define Ubatt     PA_0

typedef enum {
    // Not connected
    NC = (int)0xFFFFFFFF,

    // Ports
    PA_0  = 0x00,
    PA_1  = 0x01,
    PA_2  = 0x02,
    PA_3  = 0x03,
    PA_4  = 0x04,
    PA_5  = 0x05,
    PA_6  = 0x06,
    PA_7  = 0x07,
    PA_8  = 0x08,
    PA_9  = 0x09,
    PA_10 = 0x0A,
    PA_11 = 0x0B,
    PA_12 = 0x0C,
    PA_13 = NC,
    PA_14 = NC,
    PA_15 = 0x0F,

    PB_0  = 0x10,
    PB_1  = 0x11,
    PB_2  = NC,
    PB_3  = 0x13,
    PB_4  = 0x14,
    PB_5  = 0x15,
    PB_6  = 0x16,
    PB_7  = 0x17,
    PB_8  = 0x18,
    PB_9  = 0x19,
    PB_10 = 0x1A,
    PB_11 = 0x1B,
    PB_12 = 0x1C,
    PB_13 = 0x1D,
    PB_14 = 0x1E,
    PB_15 = 0x1F,

    PC_0  = NC,
    PC_1  = NC,
    PC_2  = NC,
    PC_3  = NC,
    PC_4  = NC,
    PC_5  = NC,
    PC_6  = NC,
    PC_7  = NC,
    PC_8  = NC,
    PC_9  = NC,
    PC_10 = NC,
    PC_11 = NC,
    PC_12 = NC,
    PC_13 = 0x2D,
    PC_14 = 0x2E,
    PC_15 = 0x2F,

    PD_2  = NC,

    // ADC internal channels
    ADC_TEMP = 0xF0,
    ADC_VREF = 0xF1,

    // Arduino connector namings
    A0          = PA_0,
    A1          = PA_1,
    A2          = PA_4,
    A3          = PB_0,
    A4          = NC,
    A5          = NC,
    D0          = PA_3,
    D1          = PA_2,
    D2          = PA_10,
    D3          = PB_3,
    D4          = PB_5,
    D5          = PB_4,
    D6          = PB_10,
    D7          = PA_8,
    D8          = PA_9,
    D9          = NC,
    D10         = PB_6,
    D11         = PA_7,
    D12         = PA_6,
    D13         = PA_5,
    D14         = PB_9,
    D15         = PB_8,

    // Generic signals namings
    Red_Led     = NC,
    Green_Led   = PC_13,
    Blue_Led    = NC,
    LED1        = PC_13,
    LED2        = NC,
    LED3        = NC,
    LED4        = NC,
    USER_BUTTON = NC,    
    SERIAL_TX   = PA_2,
    SERIAL_RX   = PA_3,
    USBTX       = PA_12,
    USBRX       = PA_11,
    CANRX       = PB_8,    
    CANTX       = PB_9,
    I2C_SCL     = PB_6,
    I2C_SDA     = PB_7,
    SPI_MOSI    = PA_7,
    SPI_MISO    = PA_6,
    SPI_SCK     = PA_5,
    SPI_CS      = PA_4,
    TRACE_SWO   = PB_3,
    SWO         = PB_3
} PinName;

#ifdef __cplusplus
}
#endif

#endif
