/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-F103C8_Adivina
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"
#include "stm32f103c8t6.h"
//#include "stm32f10x.h"
#include "PinNames.h"
//#include "SysClockConf.h"
//#include "AnalogIn.h"
//#include "Led_RGB.h"
#include "Serial.h"
#include "stdio.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define  on             0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0
#define TRUE            1
//#define Ticker_Rate     1000            // Periodo de interrupción (us)
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
//confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
//Ticker      TimerInt;               // Inicializa la Interrupción por Timer
DigitalOut  verde   (LED1);      // Inicializa el LED Monitor
DigitalOut  rojo    (PB_1);      // Inicializa el LED Testigo
Serial      terminal(PA_2, PA_3);   // Inicializa la Comunicación Serial a la PC
//PwmOut      servo(PA_7);            // Inicializa el PWM
//AnalogIn    sensor1 (PB_0);         // Inicializa Canal Analógico para sensor 1
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
//uint16_t Rate=Ticker_Rate/2;        // Velocidad de barrido (500us = 0.5ms)
//uint16_t counter=250;               // Cuenta inicial de 250us
/* END variables */

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
        // Las Definiciones de Funciones Prototipo 
        // y Apuntadores a Vectores de Interrupciones van aquí !
void Setup(void);
//void TimerInt_OnInterrupt(void);  
//void Blinking_Led(void);
/* END prototypes */

/* END definitions */  
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                           // Inicialización de variables, puertos e interrupciones
void confSysClock();             // Inicialización del Sistema, Configure system clock (72MHz HSE clock, 48MHz USB clock)
void Setup(void);
//TimerInt.attach_us(&TimerInt_OnInterrupt, Ticker_Rate);   // Le asigna el periodo de interrupción de 1ms (Ticker_Rate=1000)

//terminal.baud(115200);      // Se configura la velocidad de transmisión e inicia la comunicación serial.    
terminal.printf(" ADIVINA \n\r"); 
rojo = off;
verde = off;

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
        Inicio:     terminal.printf("DIGITE UN NUMERO SECRETO DE 0 A 9  \r\n");
                    char secreto = terminal.getc();
                    rojo = on;
                    verde = on;
        Intenta:    terminal.printf("ADIVINA EL NUMERO  \r\n");
                    char respuesta = terminal.getc();
                    if( secreto < respuesta )
                    {
                            terminal.printf("Es mas BAJO \r\n");
                            rojo = on;
                            verde = off;
                            goto Intenta;
                    }
                    if(secreto > respuesta )
                    {
                            terminal.printf("Es mas ALTO \r\n");
                            rojo = off;
                            verde = on;
                            goto Intenta;
                    }
                    if( secreto == respuesta )
                    {
                        terminal.printf("CORRECTO!, Es igual a: %c \r\n", secreto);
                        rojo = off;
                        verde = on;
                        wait(1.0);
                        rojo = off;
                        verde = off;
                        wait(1.0);
                        rojo = off;
                        verde = on;
                        wait(1.0);
                        terminal.printf("ERES UN GENIO !!! \r\n");
                        wait(1.0);
                        rojo = on;
                        verde = off;
                        wait(1.0);
                        rojo =off;
                        verde = on;
                    }
                terminal.printf("Quieres intentarlo de nuevo?  \r\n");
                terminal.printf("0 = NO \r\n 1 = SI \r\n");
                char opcion = terminal .getc();
                if(opcion =='1') goto Inicio;
                else if(opcion == '0')
                {
                    terminal.printf("GAME OVER  \r\n");
                    break;
                } 
                            
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
                // Las Rutinas de Atención a Interrupciones van aquí !
/*void TimerInt_OnInterrupt()          // Rutina de Atención al Ticker
{
    counter--;                      // Aquí va la Rutina de Servicio !
    if (!counter)
    {
        terminal.printf("Counter Finish! \r\n");
        led_monitor = !led_monitor; // Parapadeo del LED por Interrupción (LED Toggled)
        counter = Rate;           // Restablece el contador, Le asigna el periodo de 0.5ms (Rate=500)
    } 
}*/
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()             // Software Blinking routine for LED 
{
        // The on-board LED is connected, via a resistor, to +3.3V (not to GND). 
        // So to turn the LED on or off we have to set it to 0 or 1 respectively
        terminal.baud(9600);
        terminal.printf("System is Wake Up!.\n\r");
    //led_testigo = 1;        // turn the LED on (using Positive Logic)
    //wait_ms(200);           // 200 millisecond
    //led_testigo = 0;        // turn the LED off (using Positive Logic)
    //wait_ms(1000);          // 1000 millisecond
}
/* END functions */    
                
/* END program */

/*+-----------------------------------------------------------------------------       
*+  Conexión al Led Testigo:
*+ 
*+  Los leds se pueden conectar a cualquier pin que se declare como DigitalOut. 
*+  El dispositivo puede drenar hasta 20ma por todas sus salidas a un voltaje de 
*+  3.3V, pero se recomienda no exceder de 1mA por salida.
*+  Esto se logra poniendo una resistencia limitadora de mínimo 330 Ohms.
*+  
*+    3.3V o 5V
*+       O
*+       |
*+       |
*+       /
*+       \   1K
*+       /
*+       \                         UTILIZANDO LÓGICA NEGATIVA
*+       |
*+    ___|___
*+    \      /
*+     \    /
*+      \  /
*+     __\/__
*+       |
*+       |__________________________  PIN (Digital Out)
*+
*+      
*+      
*+       
*+                    1K
*+                   
*+        _________/\  /\  /\  _____    PIN (Digital Out)
*+       |           \/  \/  \/
*+       |      
*+       |
*+    ___|___
*+    \      /
*+     \    /
*+      \  /                       UTILIZANDO LÓGICA POSITIVA
*+     __\/__
*+       |
*+       |
*+       |
*+    ___|___
*+     _____
*+      ___
*+       _
*+
*+      GND
*+
*/
/*
+--------------------------------------------------------------------------------
|                               EJERCICIO
|
| 1.-   Este programa tambien acepta letras o caracteres?
| 2.-   Modificar este programa para: 
|       a) Que solo acepte números
|       b) Agregar un contador de Número de Intentos 
|       
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-   Modificar el programa para que despliegue el número de intentos para adivinar
|       el número secreto.
| 2.-   Modificar el programa para haga eco con la respuesta que le introducimos.
|
| 3.-   Modificar el programa para que el número secreto sea generado aleatoriamente.
|       a) Generar un Número Pseudo Aleatorio Mediante el Ticker
|       b) Utilizando la función RANDOMIZE
| Suerte!
+--------------------------------------------------------------------------------

*/
/* END Mbed */ 