/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Barrido_Display
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "AnalogIn.h"
//#include "ADC.h"
//#include "Led_RGB.h"
#include "Serial.h"
#include "TextLCD.h"
#include "I2C.h"
#include "SPI.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
#define Ticker_Rate     1000            // Periodo de interrupción (us)
#define Rate_Time       2               // Tiempo de Encendido de los Digitos (ms)
#define Scan_Time       2               // Tiempo de Barrido del Display (ms)
#define Shift_Time      2               // Tiempo de corrimiento  (x Counter_Time)
#define Counter_Time    100             // Tiempo de counter (ms)
#define Size_String     20              // Tamaño del Buffer de Caracteres
#define Digit_Null      0xFF            // Valor para apagar los Segmentos 
#define Degree_Symbol   0x0F            // Valor para el Símbolo de Grados
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/

DigitalOut  led_monitor(LED1);         // Inicializa el Led de Monitor
PwmOut      buzzer  (PB_1);            // PWM para el Buzzer
AnalogIn    sensor1 (PA_0);            // Canal Analógico para sensor 1
AnalogIn    sensor2 (PA_1);            // Canal Analógico para sensor 2
BusIn       Teclado (PB_5,PB_6,PB_7,PB_8);          // Teclado Matricial
BusOut      Anodos  (PB_12, PB_13, PB_14, PB_15);   // Anodos: (Uni Dec Cent Mill)  A1 A2 A3 A4  
BusOut      Catodos (PB_4,PB_3,PA_15,PA_12,PA_11,PA_10,PA_9,PA_8);     // Cátodos: p e d c b a f g 
// *****    Host PC Terminal Communication channels
Serial      Terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial      Terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds
// *****    I2C Communication
//I2C         i2c_LCD(PB_9,PB_8,);          // SDA, SCL
// *****    SPI Communication
//SPI         spi_LCD(PA_7,PA_6,PA_5,PB_6);   // MOSI, MISO, SCLK, SS
Ticker      Barrido;                        // Interrupción por Timer
/*
** -------------------------------------------------------------------
**    Instanciación del LCD
** -------------------------------------------------------------------
*/
// LCD instantiation 
//TextLCD lcd(PTC5, PTC6, PTC8, PTC9, PTC10, PCT11, TextLCD::LCD20x2); // 4bit bus: rs, e, d4-d7
//TextLCD_SPI lcd(&spi_LCD, PB_6, TextLCD::LCD16x4, TextLCD::AC780);   // SPI bus, CS, LCD Type 
//TextLCD_I2C lcd(&i2c_LCD, 0x7E, TextLCD::LCD20x4); // I2C bus, PCF8574A Arduino Shield, LCD Type

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=1000;             // Velocidad de barrido (1000us = 1ms)
// ++++++++++++++++++++ Generador de Caracteres ++++++++++++++++++++++++++++++++
//             Offset:  0    1    2    3    4    5    6    7    8    9   10    11  12   13   14   15   16   17   18   19   20   21  22    23   24   25   26   27   28   29   30   31   32   33   34   35   36   37   38   39   40   41   42   43   44   45   46   47  48  49  50  51 52  53  54  55  56   57   58   59   60   61   62   63   64   65   66   67   68   69   70   71   72   73   74   75   76   77   78   79   80   81   82   83  84   85   86
//           Caracter:  0    1    2    3    4    5    6    7    8    9    A     b   C    d    E    f    G    h    I    j    K    L   M     n    o    P    q    r    S    t    u    V    W    X    y    Z  null  a    e    +o  +/c   c    /c   +u   +n   [    ]    °     ^    ¬  + >   ^   / v   <    v    >                                            /_   -    _    =    /=   ==   ¬_   ii   #   /#     J   /J   -J   -/J  -J  -/J   |    ||   +    /+ null         !  "   #   $  %   &   '   (    )   *   +   -   .   /   :   ;   <   >   ?   @
uint8_t  Segmentos[]={0x81,0xE7,0x49,0x43,0x27,0x13,0x11,0xC7,0x01,0x03,0x05,0x31,0x99,0x61,0x19,0x1D,0x91,0x35,0xBD,0xB3,0x2D,0xB9,0x85,0x75,0x71,0x0D,0x07,0x3D,0x13,0x39,0xF1,0xE1,0xA1,0x25,0x37,0x49,0xFF,0xBE,0xF6,0x0F,0x8F,0x4F,0x2F,0x1F,0x0F,0x13,0x01,0x7F,0x7D,0x7B,0x79,0x75,0x73,0x71,0x70,0x99,0xC3,0x3F,0x9F,0xCF,0x6F,0x7D,0xF9,0xF3,0xD7,0xF7,0xDF,0x7F,0xFB,0x5F,0x7B,0x5B,0xBD,0xF5,0x6D,0x37,0xE3,0xB9,0x9D,0x7C,0xE7,0xBD,0xCa,0x00};
// ++++++++++++++++++++++ Selector de Digitos ++++++++++++++++++++++++++++++++++
uint8_t  Digitos[]={0x08,0x04,0x02,0x01,0x00,0x0F};     // Millares, Centenas, Decenas, Unidades, Apagados, Encendidos
uint8_t  Numeros[]={1,0,2,4};   // Valor a Desplegar
uint8_t  Cadena[]={33,0,21,10,36,14,28,18,22,36,35,10,12,10,29,14,23,12,24,36,36}; // Mensaje a Desplegar
uint8_t  punto_decimal=0;   // Posición del punto decimal: 0=sin punto, 1=unidades, 2=decenas, 3=centemas 4=millares,  
uint8_t  cont_1ms;          // Contador de milésimas de Segundo
uint8_t  cont_10ms;         // Contador de centésimas de Segundo
uint8_t  cont_100ms;        // Contador de décimas de Segundo
uint8_t  cont_1s;           // Contador de Segundos
uint8_t  scan_rate = Scan_Time ;
uint8_t  shift_rate= Shift_Time;
uint8_t  display_rate=10;           // Display Rate = 10ms
uint16_t counter=1250;
uint8_t  i=0;
uint8_t  nchar=0;
bool     flag1=FALSE;
bool     flag2=FALSE;
bool     mode=0;
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void);  
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                       // Inicialización de variables, puertos e interrupciones
confSysClock();         // Configure system clock (72MHz HSE clock, 48MHz USB clock)
Barrido.attach_us(&Barrido_OnInterrupt, Rate);   // Le asigna el periodo de barrido de 1ms (Rate=1000)
Terminal.baud(115200);  // Se configura la velocodad de transmisión     
Terminal.printf("\e[2J");                       // Clear Screen  
Terminal.printf(" System is Wake Up!.\n\r");    // e inicia la  comunicación serial
Terminal.printf ("\t\e[1;37;41mInstituto Politecnico Nacional\e[0m\n\r");
Terminal.printf ("\e[1;37;42mESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m\n\r\v");
Terminal.printf ("\t\e[1;34;40mBarrido \e[1;37;40mdel \e[1;32;40mDisplay \e[1;33;40mde \e[1;31;40m7 Segmentos\e[0m\n\r\v\v\e[0m");

Terminal.printf ("\nSelecciona el Modo de Operacion:\n\r");
Terminal.printf ("Modo 0 = Normal (4 Digitos)\n\r");
Terminal.printf ("Modo 1 = Corrimiento \n\r");
int opcion = getchar();
Terminal.printf ("%c \n\r",opcion);    

    while (TRUE)        // El Lazo del Programa principal está aquí !!!
    {    
        if (flag1==TRUE)                // Está puesta la Bandera 1 ?
        {                         
            if (mode==1)                // Está en modo 1? (corrimiento de mensaje)
            {
                Numeros[i]=Cadena[i+nchar];// Copia 4 caracteres al buffer de despliegue
                if (nchar >= Size_String) nchar=0;   // Restablece el contador de caractres
                  if (i==4)             // 
                  {
                      i=0;              // 
                      mode=0;           // 
                  }                         
            }    
            //------------------ Barrido de los Digitos ------------------------
            Anodos=Digitos[4];          // Apaga todos los Digitos (Evita fantasmas)                
            Catodos=Segmentos[Numeros[i]];  // Actualiza los segmentos
            if (i==4-punto_decimal) Catodos=(Segmentos[Numeros[i]]& 0xFE); // Enciende el punto decimal
            Anodos=Digitos[i];          // Activa el Digito en cuestión
            i++;                        // Apunta al siguiente dígito
            if (i==4)                   // Es el últino dígito?
            {
                i=0;                    // Reinicia el Barriodo
            }      
            flag1=FALSE;                // Apaga la Bandera 1
        }
        
        //------------------ Corrimiento de los Digitos ------------------------   
        if (flag2==TRUE)                // Está puesta la Bandera 2?
        {
            shift_rate--;               // Decrementa el contador de Corrimientos
        if (!shift_rate)                // Es Cero?
            {    
                mode=1;                 // Tiempo entre desplazamientos del mensaje
                shift_rate = Shift_Time;// Restablece el tiempo de los corrimientos
                nchar++;                // corrimiento al siguiente conjunto de de caracteres
                i=0;                    // Restablece el barrido de los digitos
            }            
            led_monitor=!led_monitor;   // parapadeo del led_monitor 
            flag2=FALSE;
        } 
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void Barrido_OnInterrupt()          // Rutina de Atención al Ticker
{
    cont_1ms++;                         // Incrmenta el contador de milisegundos
    counter--;                          // Decrementa el contador de eventos
    scan_rate--;                        // Decrementa el tiempo de  despliege
    if(!scan_rate)                      // Se acabo el tiempo de desplige?
    {
        scan_rate=Scan_Time;            // Se restable el tiempo de despliegue     
        flag1=TRUE;                     // Enciende la Bandera 1
    }        
    if (cont_1ms>=10)                   // Son 10ms?
    {
        cont_10ms++;                    // Incrementa el contador de decimas de ms
        cont_1ms=0;                     // Restablece el contador de ms
    }      
    if (cont_10ms>=10)                  // Son 100ms?
    {
        cont_100ms++;
        cont_10ms=0;
    }   
    if (cont_100ms>=10)                 // Son 1000ms o sea 1 seg?
    {
        cont_1s++;
        cont_100ms=0;
    }    
    if (cont_1s>=10)                    // Son 10seg?
    {
        cont_1s=0;
    }
    if (!counter)
    {
        counter=Counter_Time;
        flag2=TRUE;            
    }
}  
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
                
                
/* END program */                
/*+------------------------------------------------------------------------------------
*+ Descripción del Display de 7 Segmentos de Anodos Comunes en modo multiplexado
*+-------------------------------------------------------------------------------------
*+                            13 12 11 10  9  8
*+                             |  |  |  |  |  |                         
*+                             |  |  |  |  |  |  
*+               --------------------------------------------------
*+              |               A  a  f  A  A  b                   |
*+              |               4        3  2                      |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____     _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/ .  /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |                              A                   |
*+              |               e  d  p  c  g  1                   |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |  |                       
*+                              |  |  |  |  |  |  |
*+                              1  2  3  4  5  6  7                                  
*+
*+                              Display: HS410561K-D30
*+
*+
*+                            13 12 11 10  9  8
*+                             |  |  |  |  |  |                         
*+                             |  |  |  |  |  |  
*+               --------------------------------------------------
*+              |               A  g  f  p  a  b                   |
*+              |               4                                  |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____     _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/    /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |                  A  A        A                   |
*+              |               e  3  2  c  d  1                   |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |  |                       
*+                              |  |  |  |  |  |  |
*+                              1  2  3  4  5  6  7                                  
*+
*+                               Display: BQ-M544RE
*+
*+
*+                            16 15 14 13    11 
*+                             |  |  |  |    |                           
*+                             |  |  |  |    |    
*+               --------------------------------------------------
*+              |              b  g  a  c    f                     |
*+              |                                                  |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____  .  _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/ .  /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |               A  A     A     A     A             |
*+              |               4  3  3  p  e  2  p  1             |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |  |  |                      
*+                              |  |  |  |  |  |  |  |
*+                              1  2  3  4  5  6  7  8                                  
*+
*+                              Display: KEM-3942BSR
*+
+*
*+
*+                            12 11 10  9  8  7
*+                             |  |  |  |  |  |                         
*+                             |  |  |  |  |  |  
*+               --------------------------------------------------
*+              |              A  a  f  A  A  b                    |
*+              |              4        3  2                       |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____     _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/ .  /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |                              A                   |
*+              |               e  d  p  c  g  1                   |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |                        
*+                              |  |  |  |  |  |  
*+                              1  2  3  4  5  6                                    
*+
*+                              Display: FYQ-2841BH
*+
*+
*+                      PB_15 PB_14 PB_13 PB_12 
*+                        A4    A3    A2    A1
*+                       Mill  Cent  Dec   Uni
*+  
*+     STM32-F103C8      PB_4  PB_3 PA_15 PA_12   PA_11 PA_10  PA_9  PA_8    #    Hex     Offset
*+            a
*+         ______         g     f     a     b       c     d     e     p       
*+        /     /         1     0     0     0       1     0     0     0      0    0x81      0
*+     f /  g  / b        1     1     0     1       1     1     1     0      1    0xE7      1
*+      /_____/           1     0     1     1       0     1     0     0      2    0x49      2
*+     /     /            1     0     0     1       0     1     0     0      3    0x43      3
*+  e /     / c           1     1     0     1       0     0     1     0      4    0x27      4
*+   /_____/ .            1     0     0     1       0     0     0     1      5    0x13      5
*+      d    p            1     0     0     0       0     0     0     1      6    0x11      6
*+                        1     1     0     1       1     1     0     0      7    0xC7      7
*+                        1     0     0     0       0     0     0     0      8    0x01      8
*+                        1     0     0     1       0     0     0     0      9    0x03      9
*+                        1     1     0     0       0     0     0     0      A    0x05      10
*+                        1     0     0     0       0     0     1     1      b    0x31      11
*+                        1     0     1     0       1     0     0     1      C    0x99      12
*+                        1     0     0     0       0     1     1     0      d    0x61      13
*+                        1     0     1     0       0     0     0     1      E    0x19      14
*+                        1     1     1     0       0     0     0     1      f    0x1D      15
*+                        1     0     0     0       1     0     0     1      G    0x91      16
*+                        1     1     0     0       0     0     1     1      h    0x35      17
*+                        1     1     0     1       1     1     1     1      i    0xBD      18
*+                        1     0     0     0       1     1     1     0      J    0xB3      19
*+                        1     0     1     0       0     0     1     0      k    0x2D      20
*+                        1     0     1     0       1     0     1     1      L    0xB9      21
*+                        1     1     0     0       1     0     0     0      M    0x85      22
*+                        1     1     0     0       0     1     1     1      n    0x75      23
*+                        1     0     0     0       0     1     1     1      o    0x71      24
*+                        1     1     1     0       0     0     0     0      P    0x0D      25
*+                        1     1     0     1       0     0     0     0      q    0x07      26
*+                        1     1     1     0       0     1     1     1      r    0x3D      27
*+                        1     0     0     1       0     0     0     1      s    0x13      28
*+                        1     0     1     0       0     0     1     1      t    0x39      29
*+                        1     0     0     0       1     1     1     1      u    0xF1      30
*+                        1     0     0     0       1     0     1     1      V    0xE1      31
*+                        1     0     0     0       1     0     1     0      w    0xA1      32
*+                        1     1     0     0       1     0     1     0      X    0x25      33
*+                        1     0     0     1       0     0     1     0      y    0x37      34
*+                        1     0     1     0       1     1     0     0      Z    0x49      35
*+                        1     0     0     0       0     1     0     0      a    0x84      36
*+                        1     0     1     0       0     0     0     0      e    0xA0      37
*+                        1     1     1     1       0     0     0     1    + c    0xF1      38
*+                        1     1     1     1       0     1     0     0    +/c    0xF4      39
*+                        1     0     1     0       0     1     1     1      c    0xA7      40
*+                        1     0     0     1       0     1     1     1     /c    0x97      41
*+                        1     1     1     1       0     0     1     0    + u    0xF2      42
*+                        1     1     1     1       1     0     0     0    + n    0xF8      43
*+                        1     0     1     0       1     0     0     1      [    0xA9      44
*+                        1     0     0     1       1     1     0     0      ]    0x9C      45
*+                        1     1     1     1       0     0     0     0      °    0xF0      46
*+                        1     1     1     1       1     1     0     0      ¬    0xFC      47
*+                        1     1     1     1       0     1     1     0    + >    0xF6      48
*+                        1     1     1     0       0     1     1     1     ^     0xE7      49
*+                        1     0     1     0       1     1     1     1    / <    0xAF      50
*+                        1     0     0     1       1     1     1     1    / v    0x9F      51
*+                        1     1     0     1       0     1     1     1      >    0xD7      52
*+                        1     1     1     1       0     0     1     1      v    0xF3      53
*+                        1     1     1     1       1     0     0     1      <    0xF9      54
*+                        1     1     1     1       1     1     0     1    / _    0xBF      55
*+                        1     1     1     1       0     1     1     1      -    0xF7      56
*+                        1     0     1     1       1     1     1     1      _    0xFD      57
*+                        1     1     1     1       0     1     0     1      =    0xF5      58
*+                        1     0     1     1       0     1     1     1    / =    0xB7      59
*+                        1     0     1     1       0     1     0     1     ==    0xB5      60
*+                        1     0     1     1       1     1     0     1     _¬    0xBD      61
*+                        1     1     0     0       1     1     1     1     ii    0xCF      62
*+                        1     1     1     1       1     0     1     0      #    0xFA      63
*+                        1     0     0     1       1     1     1     0      j    0x9E      64
*+                        1     1     0     1       1     1     0     0     /j    0xDC      65
*+                        1     1     1     0       1     0     0     1    - j    0xE9      66
*+                        1     0     1     0       1     0     1     1    -/j    0xAB      67
*+                        1     0     0     0       1     1     1     0    - J    0x8E      68
*+                        1     1     0     1       1     0     0     0    -/J    0xD8      69
*+                        1     1     1     0       1     0     1     1     |     0xEB      70
*+                        1     1     0     0       1     0     1     0     ||    0xCA      71
*+                        1     1     0     1       0     1     1     0      +    0xD6      72
*+                        1     1     1     0       0     0     1     1     /+    0xE3      73
*+                        1     0     0     1       1     0     1     1  espacio  0xFF      74
*+
*+ Nota: Cada dígito se activa al hacer la señal A correspondiente en "alto"
*+       y enviar las señales de los segmentos que se desean encender en "bajo" 
*+
*+---------------------------------------------------------------------------------------- */
/* END documentation */ 