/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : FRDM-KL46Z_Plantilla
**    Procesador     : MKL46Z256VLL4
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "mbed.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define Ticker_Rate     1000            // Periodo de interrupción (us)
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker      Barrido;                // Inicializa la Interrupción por Timer
DigitalOut  led_monitor(LED1);      // Inicializa el LED Monitor
PwmOut      servo(PTE22);           // Inicializa el PWM
AnalogIn    sensor1 (PTB0);         // Inicializa Canal Analógico para sensor 1
Serial      terminal(USBTX, USBRX); // Inicializa la Comunicación Serial a la PC
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=Ticker_Rate/2;        // Velocidad de barrido (500us = 0.5ms)
uint16_t counter=250;               // Cuenta inicial de 250us
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void);  
void Blinking_Led(void); 
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()
{
                // Inicialización de variables, puertos e interrupciones
Barrido.attach_us(&Barrido_OnInterrupt, Rate);   // Le asigna el periodo de barrido de 1ms (Rate=1000)

terminal.baud(115200);      // Se configura la velocidad de transmisión e inicia la comunicación serial.    
terminal.printf(" System is Wake Up!.\n\r"); 

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
//        Blinking_Led();             // Parapadeo del LED por Software
        servo = sensor1.read(); 
//        terminal.printf("Blink \r\n");                           
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void Barrido_OnInterrupt()          // Rutina de Atención al Ticker
{
    counter--;                      // Aquí va la Rutina de Servicio !
    if (!counter)
    {
        terminal.printf("Counter Finish! \r\n");
        led_monitor = !led_monitor; // Parapadeo del LED por Interrupción (Toggle the LED)
        counter = Rate;             // Restablece el contador
    } 
}
/* END Events */   
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Blinking_Led()             // Software Blinking routine for LED 
{
        // The on-board LED is connected, via a resistor, to +3.3V (not to GND). 
        // So to turn the LED on or off we have to set it to 0 or 1 respectively
        led_monitor = 0;        // turn the LED on
        wait_ms(200);           // 200 millisecond
        led_monitor = 1;        // turn the LED off
        wait_ms(1000);          // 1000 millisecond
}

/* END Program */

/* END Mbed */ 