/*                              Includes                                        */
#include "mbed.h"
/*                           Definiciones                                       */
#define   On                    0
#define   off                   1 
#define   TRUE                  1
#define   FALSE                 0 
/*                      Configuración de Puertos                                */
Ticker     Barrido;                     // Interrupción del Timer
BusOut     Anodos(PTA14, PTA15, PTA16, PTA17); // Salidas a los anodos del display: A4 A3 A2 A1
BusOut     Catodos(PTE16, PTE17, PTE18, PTE19, PTE20, PTE21, PTE22, PTE23); // Salidas a los catodos: g f a b c d e p
DigitalOut Green_Led (PTD5);            // Led de Actividad del Programa
DigitalOut Red_Led   (PTE29);           // Led de Actividad del Programa
/*                     Variables Globales de Usuario                            */
uint16_t Rate=1000; // 1000us=1ms
uint8_t cont_1ms=0;
uint8_t cont_10ms=0;
uint8_t cont_100ms=0;
uint8_t cont_1s=0;
uint16_t counter=500;
/*Banderas*/
bool Flag1=FALSE;
bool Flag2=FALSE;
/*Variables*/
uint8_t i=0;
uint8_t scan_rate =0;
uint8_t Digitos[]={0x08, 0x04, 0x02, 0x01};
uint8_t Numeros[]={0,1,2,3,4,5,6,7,8,9,38,
36,38,//-
23,24,38,//no
22,14,38,//me
27,14,25,27,30,14,11,14,38,//repruebe
25,27,24,15,14,38,//profe
15,14,21,18,25,14,38,//felipe
25,13,40,38,//pd
22,14,38,//me
21,21,10,22,24,38,//llamo
36,38,//-
10,27,22,10,23,13,24,38,//ARMANDO 
24,21,31,14,27,10,38,  /*OLVERA*/
38,38,36,38,38,  /*ESPACIOS*/
10,13,18,24,28,40,38,  /*ADIOS*/
38,38,38,38,38,38,38,38,38,38,38,38};
/*VECTOR PARA CORRIEMIENTO DE MENSAJES*/
uint8_t Copia[4];
uint8_t Cadena[]={0xCA, 0x8E, 0x67, 0xFA};
uint8_t Caracteres[]={
 0x81,/*0*/
 0xE7, /*1*/
 0x49, /*2*/
 0x43, /*3*/
 0x27, /*4*/
 0x13, /*5*/
 0x11, /*6*/
 0xC7, /*7*/
 0x01, /*8*/
 0x03, /*9*/
 0x05, /*10A*/
 0x31, /*11B*/
 0x99, /*12C*/
 0x61, /*13D*/
 0x19, /*14E*/
 0x1D, /*15F*/
 0x91, /*16G*/
 0x35, /*17H*/
 0xBD, /*18I*/
 0xB3, /*19J*/
 0x2D, /*20K*/
 0xB9, /*21L*/
 0x85, /*22M*/
 0x75, /*23N*/
 0x71, /*24O*/
 0x0D, /*25P*/
 0x07, /*26Q*/
 0x3D, /*27R*/
 0x13, /*28S*/
 0x39, /*29T*/
 0xF1, /*30U*/
 0xE1, /*31V*/
 0xA1, /*32W*/
 0x25, /*33X*/
 0x37, /*34Y*/
 0x49, /*35Z*/
 0x7F, /*36-*/
 0xCA, /*37||NO HECHO*/
 0xFF, /*38ESPACIO*/
 0x60, /*39 D con  PUNTO  */
 0xFE  /*40 .*/
 };
/*                  Rutinas de los Vectores de Interrupción                     */
void Barrido_OnInterrupt(void)              // Rutina de Atención al Ticker
{                                           //El servicio a la interrupcion van aqui!
    cont_1ms++;
    scan_rate++;
    counter--;
    if(scan_rate==4){scan_rate=0;Flag1=TRUE;}        
    if (cont_1ms>=10){cont_10ms++;cont_1ms=0;}
    if (cont_10ms>=10){cont_100ms++;cont_10ms=0;}    
    if (cont_100ms>=10){cont_1s++;cont_100ms=0;}    
    if (cont_1s>=10){cont_1s=0;}
    if (!counter){counter=300;Flag2=TRUE;}
}

/*==============================================================================
|                                                                              |         
|                   P R O G R A M A P R I N C I P A L                          |
|                                                                              |     
#=============================================================================*/
int main()
{  uint8_t u=0;
  Barrido.attach_us(&Barrido_OnInterrupt, Rate); // Inicialización de variables, puertos e interrupciones
  while (true)                   //El Programa principal está aquí !!!
    {
        if (Flag1==TRUE)
        {
            Anodos=Digitos[i];//A esta madre no se le mueve
            /*Esta madre es para correr un mensaje*/        
           Catodos=Caracteres[Copia[i]];
            i++;
            Flag1=FALSE;            
        }
        if(Flag2==TRUE)
        {
            for(uint8_t o=0;o<=3;o++)
            {Copia[o]=Numeros[o+u];} 
                u++;             
                Flag2=FALSE;
        }
/*Esta madre es solo para un mensaje estatico*/
            /*
            
        if (Flag1==TRUE){
            Anodos=Digitos[i];//Esta madre no se le mueve
            Catodos=Caracteres[Numeros[i]];
            i++;
            Flag1=FALSE;
            }*/
        
/*              SECUENCIA LEDS DE PLACA                     */
        if (i==4){i=0;Red_Led=!Red_Led;}    
        if (Flag2==TRUE){Green_Led=!Green_Led;Flag2=FALSE;} 
    }
}           // End Main 