/*******************************************************************************
*
* ARCHIVO      : main.c
*
* PROYECTO     : FRDM-KL46Z_Adivina
*
* PROCESADOR   : MKL46Z256VLL4
*
* DISPOSITIVO  : FRDM-KL46Z
*
* HERRAMIENTA  : Mbed
*
* Version      : Driver 01.01
*
* Compilador   : GNU C Compiler
*
* DESCRIPCION  : El programa principal guarda un número secreto y lo compara
*                contra otro leído del teclado. Tiene n intentos para adivinar
*                el numero secreto.
*                Este programa recibe un dato desde la terminal y lo compara
*                con datos subsecuentes enviados por la terminal para decidir
*                si el número es menor, igual o mayor al digitado.
*
* VERSION      : 1.0
*
* REVISION     : A
*
* RELEASE      : 0
*
* BUGS & FIXES :
*
*   Date       : 
*
* AUTOR(ES):    Antulio Morgado Valle
*
* FECHA:        10/20/2014
*
*******************************************************************************/
#include "mbed.h"
#include "Serial.h"
DigitalOut verde (LED1);
DigitalOut rojo(LED2);
Serial pc_serial(USBTX, USBRX);
//Serial pc_serial(PTE22, PTE23);

#define  on 0
#define off 1

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#================================================================================ 
*/
int main() {
   rojo  = on;
   verde = on;
   pc_serial.baud(9600);
   while(1) 
    {
Inicio:     pc_serial.printf(" DIGITE UN NUMERO SECRETO DE 0 A 9 \r\n");
            char secreto = pc_serial.getc();
            rojo = on;
            verde = on;          
 Intenta:   pc_serial.printf(" ADIVINA EL NUMERO, \r\n");
            char respuesta = pc_serial.getc();
            if( secreto < respuesta  ) 
            {
                pc_serial.printf(" Es mas Bajo  \r\n");
                rojo = on;
                verde = off;               
                goto Intenta;
            }
            if( secreto > respuesta  ) 
            {
                pc_serial.printf(" Es mas Alto  \r\n");
                rojo  = off;
                verde = on;
                goto Intenta;
            }
            if( secreto == respuesta ) 
            {
                pc_serial.printf(" CORRECTO!, Es igual a: %c \r\n",secreto);
                rojo  = off;
                verde = on;
                wait(1.0);
                rojo  = off;
                verde = off;
                wait(1.0);
                rojo  = off;
                verde = on;
                wait(1.0);
                pc_serial.printf(" Eres un Genio !!!  \r\n");
                wait(1.0);
                rojo  = on;
                verde = off;
                wait(1.0);
                rojo  = off;
                verde = on;
            }
        pc_serial.printf(" Quieres intentarlo de nuevo?  \r\n");
        pc_serial.printf(" 0 = No \r\n 1 = Si  \r\n");
            char opcion = pc_serial.getc();
            if( opcion == '1' ) goto Inicio;
            else if( opcion == '0' )
            {
                pc_serial.printf(" Eso es todo Amigos!  \r\n");
                break;
            }
    }
}

/*
+--------------------------------------------------------------------------------
|                               EJERCICIO
|
| 1.-   Este programa tambien acepta letras o caracteres?
| 2.-   Modificar este programa para: 
|       a) Que solo acepte números
|       b) Agregar un contador de Número de Intentos 
|       
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-   Modificar el programa para que despliegue el número de intentos para adivinar
|       el número secreto.
| 2.-   Modificar el programa para haga eco con la respuesta que le introducimos.
|
| 3.-   Modificar el programa para que el número secreto sea generado aleatoriamente.
|       a) Generar un Número Pseudo Aleatorio Mediante el Ticker
|       b) Utilizando la función RANDOMIZE
| Suerte!
+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/