#include "mbed.h"
#include "XNucleoIKS01A2.h"
#include <string>
#include <sstream>

#define CR 0x0D

using namespace std;

void modem_at_cmd(string);
void wait4join(void);

Serial pc(D1, D0, 115200);
Serial lora(PB_6, PA_10, 115200);

static XNucleoIKS01A2* board = XNucleoIKS01A2::instance(D14, D15, D4, D5);
static HTS221Sensor *ht_sensor = board->ht_sensor;
char* msgSend[64];

void join_lora_gateway(string eui = "0000000000000001", string ak = "00000000000000000000000000000001", string join_method = "1") {
    pc.printf("Test seriale no pc\r\n");
    modem_at_cmd("AT");
    pc.printf("Inviato AT\r\n");
    wait(1);
    modem_at_cmd("AT+APPEUI="+eui);
    pc.printf("Inviato EUI\r\n");
    wait(1);
    modem_at_cmd("AT+AK="+ak);
    pc.printf("Inviato AK\r\n");
    wait(1);
    modem_at_cmd("AT+JOIN="+join_method);
    pc.printf("Inviato JOIN\r\n");
    wait4join();
    modem_at_cmd("AT+DC=0");
    pc.printf("Disabled DC\r\n");
    wait(1);
    modem_at_cmd("AT+ADR=1");
    pc.printf("Enabled ADR\r\n");
    wait(1);
}

string string_to_hex(string input)
{
    static const char hex_digits[] = "0123456789ABCDEF";

    std::string output;
    output.reserve(input.length() * 2);
    for (int i = 0; i < input.length(); i++)
    {
        output[2*i] = hex_digits[input[i] >> 4];
        output[2*i+1] = (hex_digits[input[i] & 15]);
    }
    return output;
}

int init() {
    pc.printf("Initialization..\r\n");
    
    uint8_t id;
    int error_code = ht_sensor->read_id(&id);
    if (error_code != 0) {
        pc.printf("Error %d reading sensor ID\r\n", error_code);
        return 1;
    }
    pc.printf("Connected to sensor with ID 0x%x\r\n", id);
    
    if (ht_sensor->enable() != 0) {
        pc.printf("Error enabling the ht sensor\r\n");
        return 2;
    }
    
    if (ht_sensor->set_odr(1.0f) != 0) {
        pc.printf("Error setting ODR\r\n");
        return 3;
    }
    
    join_lora_gateway();
    
    return 0;
}

void at_send(uint8_t port, float hum, uint8_t ack = 0) {
    char msg[30];
    char send[64];
    uint8_t i=0;
    sprintf(msg,"{\"humidity\":%.2f}", hum);
    pc.printf(msg);
    pc.printf("\r\n");
    pc.printf("Lunghezza messaggio %d",(int)strlen(msg));
    pc.printf("\r\n");
    sprintf(send,"AT+SEND=%d,",port);
    for(i=0;i<strlen(msg);i++)
    {
        sprintf(send+11+2*i,"%X",*(msg+i));
    }
    sprintf(send+11+2*i,",%d",ack);
    modem_at_cmd(send);
    pc.printf(send);
    pc.printf("\r\nInviato send\r\n");
}

int main() {
    
    if (init() != 0) {
        pc.printf("Init failed");
        return 1;
    }
        
    while(1) {
        float humidity = 0;
        
        if (ht_sensor->get_humidity(&humidity) != 0)
            pc.printf("Error reading humidity\r\n");
        else {
            pc.printf("Humidity [%%]\t%f\r\n", humidity);
            at_send(10, humidity, 0);
        }
        wait(5);
    }
}


void modem_at_cmd(string buffer){
    for(uint16_t i = 0; i < buffer.length(); i++) {
        lora.putc(buffer[i]);
        pc.putc(buffer[i]);
    }
    lora.putc(CR);
    pc.putc(CR);
    pc.printf("\n");
    
    char c = 0;
    do {
        if (lora.readable()) {
            c = lora.getc();
            pc.putc(c);
        }
    } while(c != ' ');
}

void wait4join(){
    char c = 0;
    do {
        if (lora.readable()) {
            c = lora.getc();
            pc.putc(c);
        }
    } while(c != 'd');
}