#include "mbed.h"
#include "string.h"
#include "XNucleoIKS01A2.h"

static XNucleoIKS01A2 *myboard = XNucleoIKS01A2::instance(D14,D15,D4,D5); // scheda
static LSM303AGRMagSensor *magSensor = myboard -> magnetometer; // magnetoscopio
static LPS22HBSensor *pressure = myboard->pt_sensor;  // pressione
static HTS221Sensor *temperature = myboard->ht_sensor; // temperatura e umidita'
static LSM6DSLSensor *iNemo = myboard->acc_gyro; // giroscopio

// Prototipi Fuzioni
void modem_at_cmd(char*,int);
void wait4join(void);
void lora_conn(void);
void at_send(uint8_t port, float pres, uint8_t ack);
void enable_all_sensors();
void get_pressure();
void get_magnetic_field();
void get_temperature();
void get_humidity();
void get_acceleration();
void get_gyroscope();
void Sensor_Switch(int Sensor_Port);

// Variabili Globali
float val_pressure;
float val_temperature;
float val_humidity = 0;
int assi_giroscopio[3];
int assi_accelerazione[3];
int assi_magnetometro[3];

//// Definizione Porte

// Accelerometer
int acce_port = 12;
// Gyroscope
int gyro_port = 13;
// Magnetic Field
int magn_port = 14;
// Temperature
int temp_port = 15;
// Humidity
int humi_port = 16;
// Pressure
int press_port = 17;

// Definizione Porte Comunicazione
Serial pc(D1,D0,115200);
Serial lora(PB_6,PA_10,115200);

// Stringhe messaggi
char c;

char* msg1 = {"AT"};
char* msg2 = {"AT+APPEUI=0000000000000001"};
char* msg3 = {"AT+AK=00000000000000000000000000000001"};
char* msg4 = {"AT+JOIN=1"};
char msg5[64]; // = {"AT+SEND=15,3031323334,0"};
char msg6[80];

float waitingTime = 1.0;









int main() {
    int i;
    enable_all_sensors();
    lora_conn();
    // Loop principale
    while(1) {
      for(int sensor_port = 12; sensor_port <= 17; sensor_port++) {
        //init msg sensore
        memset(msg5,0,64*sizeof(char));
        //Sensor Switch
        Sensor_Switch(sensor_port);
        pc.printf(msg5);
        pc.printf("\r\n");
        pc.printf("Lunghezza messaggio %d",(int)strlen(msg5));
        pc.printf("\r\n");
        sprintf(msg6,"AT+SEND=");
        sprintf(msg6,"%d",sensor_port);
        for(i=0;i<strlen(msg5);i++)
        {
            sprintf(msg6+11+2*i,"%X",*(msg5+i));
        }
        sprintf(msg6+11+2*i,",0");
        modem_at_cmd(msg6,(int)strlen(msg6));
        pc.printf("Inviato send\r\n");
        wait(3);
          }
      }
}


// Funzione che esegue le azioni per singola porta
void Sensor_Switch(int Sensor_Port) {
    switch(Sensor_Port) {
        case 12:  // Accelerometer
        get_acceleration();
        sprintf(msg5,"{\"accx\":%6ld,\"accy\":%6ld,\"accz\":%6ld}", assi_accelerazione[0], assi_accelerazione[1], assi_accelerazione[2]);
        break;
            
        case 13:  // Gyroscope
        get_gyroscope();
        sprintf(msg5,"{\"gyrox\":%6ld,\"gyroy\":%6ld,\"gyroz\":%6ld}", assi_giroscopio[0], assi_giroscopio[1], assi_giroscopio[2]);
        break;
        
        case 14:  // Magnetic Field
        get_magnetic_field();
        sprintf(msg5,"{\"magnx\":%6ld,\"magny\":%6ld,\"magnz\":%6ld}", assi_magnetometro[0], assi_magnetometro[1], assi_magnetometro[2]);
        break;
        
        case 15:  // Temperature
        get_temperature();
        sprintf(msg5,"{\"temperature\":%6f}", val_temperature);
        break;
        
        case 16:  // Humidity
        get_humidity();
        sprintf(msg5,"{\"humidity\":%6f}", val_humidity);
        break;
        
        case 17:  // Pressure
        get_pressure();
        sprintf(msg5,"{\"pressure\":%6f}", val_pressure);
        break;
        
        default:
        printf("Porta Errata");
        }
    }














///
/// Definizione Funzioni
///


void at_send(uint8_t port, float pres, uint8_t ack) {
    char msg[30];
    char send[64];
    uint8_t i=0;
    sprintf(msg,"{\"pressure\":%.2f}", pres);
    pc.printf(msg);
    pc.printf("\r\n");
    pc.printf("Lunghezza messaggio %d",(int)strlen(msg));
    pc.printf("\r\n");
    sprintf(send,"AT+SEND=%d,",port);
    for(i=0;i<strlen(msg);i++)
    {
        sprintf(send+11+2*i,"%X",*(msg+i));
    }
    sprintf(send+11+2*i,",%d",ack);
    modem_at_cmd(send,(int)strlen(send));
    pc.printf(send);
    pc.printf("\r\nInviato send\r\n");
}


void enable_all_sensors() {
    pressure->enable();
    magSensor -> enable();
    temperature -> enable();
    iNemo -> enable_g();
    iNemo -> enable_x();
}

void get_pressure() {
    pressure->get_pressure(&val_pressure);
    pc.printf("pressione [mbar]:\t%f\r\n",val_pressure);
}

void get_magnetic_field() {
    magSensor -> get_m_axes(assi_magnetometro);
    pc.printf("campo magnetico [mmgauss]:\t%d\t%d\t%d\n\r", assi_magnetometro[0] , assi_magnetometro[1] , assi_magnetometro[2]);
}

void get_temperature() {
    temperature->get_temperature(&val_temperature);
    pc.printf("temperatura [Celsius]: %f\n\r", val_temperature);
}

void get_humidity() {
    temperature->get_humidity(&val_humidity);
    pc.printf("Humidity [%%]\t\t%f\r\n", val_humidity);
}

void get_acceleration() {
    iNemo->get_x_axes(assi_accelerazione);
    pc.printf("accelerazione [mg]:\t%d\t%d\t%d\n\r", assi_accelerazione[0] , assi_accelerazione[1] , assi_accelerazione[2]);
}

void get_gyroscope() {
    iNemo->get_g_axes(assi_giroscopio);
    pc.printf("velocita' angolare [rad/s]:\t%d\t%d\t%d\n\r", assi_giroscopio[0] , assi_giroscopio[1] , assi_giroscopio[2]);
}

void lora_conn(void) {
    pc.printf("Connessione al modem\r\n");
    modem_at_cmd(msg1,(int)strlen(msg1));
    pc.printf("Inviato AT\r\n");
    wait(1);
    modem_at_cmd(msg2,(int)strlen(msg2));
    pc.printf("Inviato EUI\r\n");
    wait(1);
    modem_at_cmd(msg3,(int)strlen(msg3));
    pc.printf("Inviato AK\r\n");
    wait(1);
    modem_at_cmd("AT+ADR=1",(int)strlen("AT+ADR=1"));
    pc.printf("Inviato AK\r\n");
    wait(1);
    modem_at_cmd("AT+DC=0",(int)strlen("AT+DC=0"));
    pc.printf("Inviato AK\r\n");
    wait(1);
    modem_at_cmd(msg4,(int)strlen(msg4));
    pc.printf("Inviato JOIN\r\n");
    wait4join();
}

void modem_at_cmd(char* buffer, int n) {
    for(uint8_t i=0; i<n; i++) {
        lora.putc(buffer[i]);
        pc.putc(buffer[i]);
    }
    lora.putc(13);
    pc.putc(13);
    pc.printf("\n");
    c=0;
    do {
        if (lora.readable()) {
            c = lora.getc();
            pc.putc(c);
        }
    } while(c!=' ');
}

void wait4join()
{
    c=0;
    do {
        if (lora.readable()) {
            c = lora.getc();
            pc.putc(c);
        }
    } while(c!='d');
}