#include "mbed.h"
#include "string.h"
#include "XNucleoIKS01A2.h"

void modem_at_cmd(char*,int);
void wait4join(void);
void lora_conn(void);

static XNucleoIKS01A2 *mems_expansion_board = XNucleoIKS01A2::instance(D14, D15, D4, D5);
static HTS221Sensor *temperature = mems_expansion_board -> ht_sensor;

char* msg1 = {"AT"};
char* msg2 = {"AT+APPEUI=0000000000000001"};
char* msg3 = {"AT+AK=00000000000000000000000000000001"};
char* msg4 = {"AT+JOIN=1"};
char msg5[64];
char msg6[80];

char c;
float val_temperature;
uint8_t id;

Serial pc(D1, D0, 115200);
Serial lora(PB_6, PA_10, 115200);

int main()
{
    temperature->enable();
    pc.printf("\r\n--- Starting new run ---\r\n");
    temperature->read_id(&id);
    pc.printf("HTS221 Sensor = 0x%X\r\n", id);
    lora_conn();
    while(1) {
        int i = 0;
        pc.printf("\r\n");
        temperature -> get_temperature(&val_temperature);
        pc.printf("temperatura [Celsius]:\t%f\n\r", val_temperature);
        memset(msg5, 0, 64*sizeof(char)); // fill msg5 of zeros
        sprintf(msg5, "{\"temp\": %f}", val_temperature); // converte in stringa c msg5
        pc.printf(msg5);
        pc.printf("\r\n");
        pc.printf("Lunghezza messaggio %d", (int)strlen(msg5));
        pc.printf("\r\n");
        sprintf(msg6, "AT+SEND=15,");
        for(i = 0; i<strlen(msg5); i++) {
            sprintf(msg6+11+2*i, "%X", *(msg5+i));
        }
        sprintf(msg6+11+2*i,",0");
        modem_at_cmd(msg6,(int)strlen(msg6));
        pc.printf("Inviato send\r\n");
        wait(3);
    }
}

void modem_at_cmd(char* buffer, int n) {
    for(uint8_t i=0; i<n; i++) {
        lora.putc(buffer[i]);
        pc.putc(buffer[i]);
    }
    lora.putc(13);
    pc.putc(13);
    pc.printf("\n");
    c = 0;
    do {
        if (lora.readable()) {
            c = lora.getc();
            pc.putc(c);
        }
    } while(c!=' ');
}

void wait4join() {
    c = 0;
    do {
        if (lora.readable()) {
            c = lora.getc();
            pc.putc(c);
        }
    } while(c != 'd');
}

void lora_conn() {
    pc.printf("Connessione al modem\r\n");
    modem_at_cmd(msg1,(int)strlen(msg1));
    pc.printf("Inviato AT\r\n");
    wait(1);
    modem_at_cmd(msg2,(int)strlen(msg2));
    pc.printf("Inviato EUI\r\n");
    wait(1);
    modem_at_cmd(msg3,(int)strlen(msg3));
    pc.printf("Inviato AK\r\n");
    wait(1);
    modem_at_cmd("AT+ADR=1",(int)strlen("AT+ADR=1"));
    pc.printf("Inviato AK\r\n");
    wait(1);
    modem_at_cmd("AT+DC=0",(int)strlen("AT+DC=0"));
    pc.printf("Inviato AK\r\n");
    wait(1);
    modem_at_cmd(msg4,(int)strlen(msg4));
    pc.printf("Inviato JOIN\r\n");
    wait4join();
}
