#include "mbed.h"
/*
Zähler von 0 bis 39
ein Erhöhen über 39 und ein vermindern unter 0 ist nicht möglich
  a) mit Joystick Up Zählerinhalt um 1 erhöhen
  b) mit Joystick Down Zählerinhalt um 1 vermindern
  c) mit Joystick LEFT Zählerinhalt um 5 erhöhen
  d) mit Joystick RIGHT Zählerinhalt um 5 vermindern
  e) mit Joystick CENTER: -1x Zählerinhalt auf 0 setzten
                          -2x Zählerinhalt auf 10 setzten
                          -3x Zählerinhalt auf 20 setzten
                          -4x Zählerinhalt auf 30 setzten
                          -5x Zählerinhalt auf 0 setzten
                          -2x Zählerinhalt auf 10 setzten
                          usw...
  f) Anzeige: -Einerstelle: Binär auf LED1 - LED4
              -Zehnerstelle mit RGB-LED:    0 = dunkel
                                            10 = grün
                                            20 = rot
                                            30 = blau

Empfehlung: Verwendung der Class BusOut für die Anzeige 
*/                         
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalOut red(p23);
DigitalOut green(p24);
DigitalOut blue(p25);
DigitalIn joyUp(p15);
DigitalIn joyDown(p12);
DigitalIn joyLeft(p13);
DigitalIn joyRight(p16);
DigitalIn joyCenter(p14);

BusOut ledbus(LED1, LED2, LED3, LED4);
BusOut rgbbus(p23, p24, p25);

int main() {
//--VARIABLEN DEFINIERT----------------------------------------------------------------     
    int i = 0;
    int a = 0;
    int c = 0;                          //für Joystick Center

    
    ledbus = 0;
    rgbbus = 7;                         //keine Farbe
    
    while(1) {
//--SCHLEIFEN----------------------------------------------------------------  
        if ( i > 39)
        {
            a = 0;
            i = 0;           
            }
 
         if ( i < 0)
        {
            a = 9;
            i = 39;           
            }
            
            if ( c == 5)
                c = 0;
                        
//--DEFINITION BUTTONS------------------------------------------------------------------            
        if(joyUp == 1)
            i++;
            a++;

        if(joyDown == 1)
            i--;
            a--;
            
        if(joyLeft == 1)
            i=i+5;
            a=a+5;
            
        if(joyRight == 1)
            i=i-5;
            a=a-5;

        if(joyCenter == 1)
            c++;                               
//--VERARBEITUNG ZÄHLER------------------------------------------------------------------   
            if(i<10 || c==0 || c==1)
            rgbbus=7;
            
            if(i>9 && i<20 || c==2)   
                rgbbus = 5;             //grün
                if(i == 10 || c==2)
                    a = 0;
                    else
                    a = i % 10;         //Modulodivision mit % --> Einerstellen mit Rest anzeigen          
                
                if(i>19 && i<30 || c==3)
                rgbbus = 6;             //rot
                if(i==20 || c==3)
                    a=0;
                    else
                    a = i % 10;  
                                      
                    if(i>29 && i<40 || c==4)
                    rgbbus = 3;         //blau
                    if (i==30 || c==4)
                        a = 0;
                        else
                        a = i % 10;


              

//---AUSGABE-----------------------------------------------------------------       
            ledbus=a;                                 
            wait(0.2);
            
        
 //--------------------------------------------------------------------         
 
 /*
        red=0;
        green=1;
        blue=1;
        wait(0.5);
        red=1;
        green=0;
        blue=1;
        wait(0.5);
        red=1;
        green=1;
        blue=0;
        wait(0.5);
        red=0;
        green=0;
        blue=1;
        wait(0.5);
*/
    }
}
