
#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

void DriveUntilObstacle();
void Turn180();
void BlinkTask();
Timer t1;
int i,j;

int main(void)
{
    i=0;
    j=0;
    t1.start();
    InitBertl();
    pex.ClearLeds();
    leds = 9;
    pex.WaitUntilFrontButtonPressed();
    leds=6;
    wait(0.8);
    pex.WaitUntilFrontButtonPressed();
    leds=0;

    while(1) {
        DriveUntilObstacle();
        wait(1);
        Turn180();
        wait(1);
    }
    return 1;
}

void DriveUntilObstacle()
{
    // Motoren ein
    mL.SetPow(0.3);
    mR.SetPow(0.3);
    // in einer While-Schleife warten bis Distanz kleiner MinDistance
    while(1) {
        //mL.SetPow(0.5);
        //mR.SetPow(0.5);
        us.StartMeas();
        wait_ms(10);
        BlinkTask();
        if ((us.distCM*100.0) < 500.0) {
            // Motoren aus
            if (i==0){
                i=1;
            }
            else {
                i=0;
            }
            mL.SetPow(0.0);
            mR.SetPow(0.0);
            pex.ClearLeds();
            break;
        }
    }
}

void Turn180()
{
    if (j==0){
        // Motoren auf 0.5 bis 0.7
        mL.SetPow(0.7);
        mR.SetPow(-0.7);
        j=1;
        pex.SetLeds(LED_FR1|LED_BR1);
        }
    else{
        mL.SetPow(-0.7);
        mR.SetPow(0.7);
        j=0;
        pex.SetLeds(LED_FL1|LED_BL1);
        }
    mL.encCnt=mR.encCnt=0;

    // in einer While-Schleife warten bis
    // bei !!!beiden!!! Motoren die Ticks für eine 180° Drehung erreicht sind
    while (1) {
        if (mL.encCnt>20) {
            mL.SetPow(0.0);
        }
        if (mR.encCnt>20) {
            mR.SetPow(0.0);
        }
        if (mL.encCnt>20 && mR.encCnt>20)
            pex.ClearLeds();
            break;
    }
    // Motoren ausschalten
    mL.SetPow(0.0);
    mR.SetPow(0.0);
    
}

void BlinkTask()
{

    if (t1.read_ms()>100) {
        if (i==0){
            pex.SetLeds(LED_FR1|LED_FL1);
        }
        else {
            pex.SetLeds(LED_BR1|LED_BL1);
        }
    }
    if (t1.read_ms()>200){
        pex.ClearLeds();
        t1.reset();
    }
}

