#include "mbed.h"
#define STOP 0
#define LL 1
#define LR 2

InterruptIn diUp(p15);
InterruptIn diDown(p12);
InterruptIn diStop(p14);
int direction = LL;

BusOut doLeds(LED1,LED2,LED3,LED4);

void stop()
{
    doLeds = 0;
    direction = 0;
    }

void Down()
{
    direction = LL;
    }
void Up()
{
    direction = LR;
    }




int main()
{
    diStop.rise(&stop);
    diDown.rise(&Down);
    diUp.rise(&Up);
    doLeds = 0;
    while(1) {
        if (direction == LL) {
            if (doLeds <= 0)
                doLeds = 8;
            else
                doLeds = doLeds>>1;
        } 
        else if (direction == LR){
            if (doLeds <= 0)
                doLeds = 1;
            else
                doLeds = doLeds<<1;
        }
        if (doLeds != 0)
            wait(0.5);
    }
}
