#include "mbed.h"
 
// MaxSonar EZ1 test program
// by Michael Shimniok http://www.bot-thoughts.com/
//
// Based on datasheet here: http://www.maxbotix.com/uploads/LV-MaxSonar-EZ1-Datasheet.pdf
// Reads from AN (analog) pin connected to mbed p20, assumes 3.3V supply to EZ1 module.
//
// mbed -> EZ1
// -----------
// VOUT -> +5
// GND  -> GND
// p20  -> AN
//
 
AnalogIn ain(p20);
Serial pc(USBTX, USBRX); // tx, rx
 
int main() {
    float adc, volts, inches;
    int feet, in;
    float inch;
    float cm;
    pc.baud(115200);
    
    while (1){
        adc = ain.read();           // read analog as a float
        volts = adc * 3.3;          // convert to volts
        //inches = volts / 0.0064;    // 3.3V supply: 6.4mV per inch
        inches = volts / 0.0098;    // 5V supply: 9.8mV per inch
        feet = (int) inches / 12;   // inches to feet (trunc)
        in = (int) inches % 12;     // remainder -> in(ches)
        cm=in*2.54;
        pc.printf("%8.2f adc %8.2fV %8.2f in %d'%d\   %8.2fcm ""\n", adc, volts, inches, feet, in,cm);
        //pc.printf("%8.2f cm""\r",cm);
 
        //wait(0.05);
        wait(0.5);                 // 20Hz update rate ; note we aren't truly synchronized to the device or anything...   
    }
}
 