#include "mbed.h"


InterruptIn iiUp(p15);
Timer timer1;
int los=0;

// global vars and objects
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX); // tx, rx    ; is default !!! (9600, 8N1)
char recChar=0;
bool recFlag=false;
char recArr[20];
int index=0;

// functions
void flushSerialBuffer() { 
    while (pc.readable()) { 
        pc.getc(); 
    } 
}
    
void readData() {
    
    if(los>=1)
    {
    recChar = pc.getc();
    recArr[index] = recChar;
    index++;
    if ((recChar == '\r') || (index>=19)) {
        recFlag = true;
        recArr[index] = 0;
        
        float t = timer1.read_ms();
        pc.printf(" - That's the input: %f L= %d %s\r\n", t,index,recArr); 
        if(index<5)
        {
           pc.printf("Eingabe zu kurz ");  
        }
        if(index>10)
        {
           pc.printf("Eingabe zu lang ");  
        }
        index = 0; 
        timer1.stop();
        timer1.reset();
        flushSerialBuffer();
        los=0;
        
    }
 }
}
 
 void SendText()
 {
    
   pc.printf("Geben Sie ein Wort mit mindestens 5 und maximal 10 ein:"); 
   timer1.start(); 
   los=1;   
    
 }
    
int main() {
//    pc.baud(115200);
    pc.baud(38400);
    pc.format(8, SerialBase::Odd, 2);
    led2 = 1;

    flushSerialBuffer();
    pc.printf("Hello RS232-USB Virtual Serial Port -World!\r\n");
    
    
    pc.attach(&readData);
    
    
    iiUp.rise(&SendText);
    
    while(1) {
        if (recFlag) {
            flushSerialBuffer();
//            pc.printf(" - That's the input: %s\r\n", recArr);  // non reantrant function
            recFlag = false;
            led2 = !led2;
        }
    }
}