#include "mbed.h"
// global vars and objects
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX); // tx, rx    ; is default !!! (9600, 8N1)
char recChar=0;
bool recFlag=false;
char recArr[20];
int index=0;

// functions
void flushSerialBuffer() { 
    while (pc.readable()) { 
        pc.getc(); 
    } 
}
    
void readData() {
    recChar = pc.getc();
    recArr[index] = recChar;
    index++;
    if ((recChar == '\r') || (index>=19)) {
        recFlag = true;
        recArr[index] = 0;
        index = 0;
        pc.printf(" - That's the input: %s\r\n", recArr);  
        flushSerialBuffer();
    }
}
    
int main() {
//    pc.baud(115200);
    pc.baud(38400);
    pc.format(8, SerialBase::Odd, 2);
    led2 = 1;

    flushSerialBuffer();
    pc.printf("Hello RS232-USB Virtual Serial Port -World!\r\n");
    pc.attach(&readData);
    
    while(1) {
        if (recFlag) {
            flushSerialBuffer();
//            pc.printf(" - That's the input: %s\r\n", recArr);  // non reantrant function
            recFlag = false;
            led2 = !led2;
        }
    }
}