/* 
Serial Communication with a PC
The mbed Microcontroller can communicate with a host PC through a "USB Virtual Serial Port" 
Aufgabenstellung:
.. nach Programmstart:
1) eine Taste (des Joysticks) betätigen: -> 
    a) über Rs232 folgenden Text ausgeben: "Geben Sie ein Wort mit mindestens 5 und maximal 10 ein:"
2) nach erfolgter Eingabe des Wortes werden die Zeichen an den mbed-uC übertragen und von diesem ausgewertet
3) die Auswertung beinhaltet: 
    a) Messen der Zeit zwischen der Eingabeaufforderung (Tastenbetätigung) und dem vollständigen Empfang mit Auswertung am uC
4) Nach erfolgter Auswertung wird die gemessene Zeit und das empfangene Wort über die RS232 an das Terminal gesendet
5) bei neuerlichen Tastendruck beginnt das Programm wieder bei 1)
*/


#include "mbed.h"
#define ARR_SIZE 20

// global vars and objects
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX); // tx, rx    ; is default !!! (9600, 8N1)
char recChar=0;
bool recAllowedFlag=false;
char recArr[ARR_SIZE];
int index=0;
char state = 0; // zustand ist 0: warten auf Eingabe
bool newAction = false;
InterruptIn iiCenter(p14);  // Taste
Timer tiInputTime;

// functions
void flushSerialBuffer() { 
    while (pc.readable()) { 
        pc.getc(); 
    } 
}
    
void readData() {
    recChar = pc.getc();    // read unexpected char
    if (recAllowedFlag) {
        recArr[index] = recChar;
        index++;
        // Emfpang wird beendet, wenn \r, oder 0 emfpangen wird, oder wenn die receiveArr_size erreicht wird
        if ((recChar == '\r') || (recChar == 0) || (index>= ARR_SIZE-1)) {
            recAllowedFlag = false;
            recArr[index] = 0;
            pc.printf(" - Eingabe beendet; Wort =  %s\r\n", recArr);  
            flushSerialBuffer();
            newAction = true;
        }
    }
}

void startButton() {
    newAction = true;
    state = 0;    
    index = 0;  // reset index for input
    recAllowedFlag = true; // allow receiving
}       
    
void checkWord() {    
    if ((index-1 >=5) && (index-1 <=10)) {
        pc.printf("Eingabe korrekt: Wort = %s\r\n", recArr);    
    }
    else {
        pc.printf("Eingabe inkorrekt: Wort = >%s<; Laenge = %d\r\n", recArr, index-1);            
    }
    float neededTime = tiInputTime.read();
    pc.printf("-- benoetigte Eingabezeit = %5.2f sec\r\n", neededTime);
}    
    
int main() {
    pc.baud(115200);
    //pc.format(8, SerialBase::Odd, 2);   // 8bit, ungerade Parität, 2 Stoppbits
    led2 = 1;
    iiCenter.rise(&startButton);

    flushSerialBuffer();
    pc.printf("\r\nHello, zum Starten betaetige bitte den Joystick-Center-Button\r\n");
    pc.attach(&readData);
    
    while(1) {
        if (newAction) {
            newAction = false;
            switch (state) {
                case 0:
                    pc.printf("Geben Sie ein Wort mit mindestens 5 und maximal 10 ein (mit Eingabe-Taste abschliessen)\r\n"); 
                    state = 1; 
                    tiInputTime.start();
                    break;
                
                case 1:
                    tiInputTime.stop();
                    if (!recAllowedFlag) {
                        flushSerialBuffer();
                        //pc.printf(" - That's the input: %s\r\n", recArr);  // non reantrant function
                        led2 = !led2; 
                    }
                    checkWord();
                    tiInputTime.reset();
                    pc.printf("\r\nHello, zum Starten betaetige bitte den Joystick-Center-Button\r\n");
                    break;
                
                default: 
                    pc.printf("\r\nERROR 1: Unexpected behaviour!!- Press reset button\r\n");
                    break;
            }
        }
        
    } // while(1)
}
