#include "mbed.h"
#include "ButtonEventCounter.h"

PwmOut lr(p5), lg(p34), lb(p36); // Definition LED grün, gelb, rot PWM
BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);

Serial pc(USBTX, USBRX);

ButtonEventCounter btg(P1_16);  //SW4
ButtonEventCounter btb(P0_23);  //SW4
ButtonEventCounter btr(P0_10);  //SW1
DigitalIn updown(P0_15);        //Sw2

int main() 
{
    pc.baud(115000);
    leds=0;
    lr.period_ms(2); lg.period_ms(2); lb.period_ms(2);
    lr.write(1.0); lg.write(1.0); lb.write(1.0);
    
    Timer tm; tm.start();
    while(1)            
    {
        if (tm.read_ms()>100)
        {
        tm.reset();
        btr.CheckButton(updown.read());
        btg.CheckButton(updown.read()); 
        btb.CheckButton(updown.read());  
        
        pc.printf("V %d  %d  %d\n", btr.val, btg.val, btb.val);
        
        lr.write(1.0-btr.GetValF());
        lg.write(1.0-btg.GetValF());
        lb.write(1.0-btb.GetValF());
                
        }          
        
    }
}
