#include "mbed.h"
#include "Serial_HL.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

//BusOut leds(LED1,LED2,LED3,LED4);
BusOut leds(P1_13,P1_12,P1_7,P1_6,P1_4,P1_3,P1_1,P1_0,LED4,LED3,LED2,LED1);
int ledsnow=0;
PwmOut r(p36);
PwmOut g(p5);
PwmOut b(p34);
BusIn btn(P0_15);
int buttn;
int zeit;
int times;

int CommandHandler(int time1);

int main(void)
{
    r=1.0;
    b=1.0;
    g=1.0;
    pc.format(8,SerialBLK::None,1);
    pc.baud(500000);
    leds = 9;
    //zeit=200;

    ua0.SvMessage("SvTest_Serial_HL"); // Meldung zum PC senden

    int16_t sv1=0, sv2=100;
    Timer stw;
    stw.start();
    while(1) {
        
     zeit=CommandHandler(zeit);

     //times=zeit;
     
        if( ua0.acqON && (stw.read_ms()>zeit) ) { // 10Hz
            // dieser Teil wird mit 10Hz aufgerufen
            stw.reset();
            sv1++;sv2++;
            if( ua0.acqON ) {
                // nur wenn vom PC aus das Senden eingeschaltet wurde
                // wird auch etwas gesendet
                ua0.WriteSvI16(1, zeit);
                ua0.WriteSvI16(2, r*100);
                r=r-0.05;
              //  b=b-0.05;
              //  g=g-0.05;
                if(r<=0)
                {
                    r=1;g=1;b=1;
                }  
                        
            }
        }
    }
    return 1;
}

int  CommandHandler(int time1)
{
    uint8_t cmd;
    int16_t idata1, idata2;

    // Fragen ob überhaupt etwas im RX-Reg steht
    if( !pc.IsDataAvail() )
        return time1;

    // wenn etwas im RX-Reg steht
    // Kommando lesen
    cmd = ua0.GetCommand();

    if( cmd==2 ) {
        // cmd2 hat 2 int16 Parameter
        idata1 = ua0.ReadI16();
        idata2 = ua0.ReadI16();
        // für die Analyse den Wert einfach nur zum PC zurücksenden
        ua0.SvPrintf("Command2 %d %d", idata1, idata2);
    }
    
    if( cmd==3)
    {
        int time1=0;
        idata1 = ua0.ReadI16();
        time1=idata1;
      //  ledsnow=leds;
      //  blabla=leds;
        ua0.SvPrintf("Done");
        return time1;
      
     }
     
     if(cmd==4)
     
     ua0.SvPrintf("LED:%i",ledsnow);
    
    
}


