#include "mbed.h"
#include "Serial_HL.h"
#include "Bertl14.h"
#include "BertlObjects.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

void CommandHandler();

AnalogInHL ls1(p18), ls2(p16), ls3(p19), ls4(p17);

int main(void)
{
    pc.format(8,SerialBLK::None,1); pc.baud(500000); // 115200
    leds = 9;
  ua0.SvMessage("LineSensTest"); // Meldung zum PC senden
  
  Timer stw; stw.start();
  while(1)
  {
    CommandHandler();
    if( (stw.read_ms()>10) ) // 100Hz
    { // dieser Teil wird mit 100Hz aufgerufen
      stw.reset();
            if( ua0.acqON ) {
        // nur wenn vom PC aus das Senden eingeschaltet wurde
        // wird auch etwas gesendet
        ua0.WriteSvI16(1, ls1.Read());
        ua0.WriteSvI16(2, ls2.Read());
        ua0.WriteSvI16(3, ls3.Read());
        ua0.WriteSvI16(4, ls4.Read());
      }
    }
  }
  return 1;
}

void CommandHandler()
{
  uint8_t cmd;
  int16_t idata1, idata2;
  
  // Fragen ob überhaupt etwas im RX-Reg steht
  if( !pc.IsDataAvail() )
    return;
  
  // wenn etwas im RX-Reg steht
    // Kommando lesen
    cmd = ua0.GetCommand();

  if( cmd==2 )
    {
        // cmd2 hat 2 int16 Parameter
    idata1 = ua0.ReadI16(); idata2 = ua0.ReadI16();
    // für die Analyse den Wert einfach nur zum PC zurücksenden
    ua0.SvPrintf("Command2 %d %d", idata1, idata2);
  }
    if( cmd==3 )
    {
        idata1 = ua0.ReadI16();
        leds = idata1;
        ua0.SvMessage("Leds schalten");
    }
    if( cmd==4 )
    {
        idata1 = leds;
        ua0.SvPrintf("LEDS %d", idata1);
    }
}



