#include "mbed.h"
#include "BtnEventM0.h"

//          LSB                                                  MSB
BusOut lb (P1_7, P1_6, P1_4, P1_3, P1_1, P1_0, LED4, LED3, LED2, LED1);

// Statusled zeigt uns in welchem Zustand die Statemachine gerade ist
BusOut stLED (P1_13, P1_12);

// erledigt für uns die Abfrage der positiven Flanke
BtnEventM0 sw4(P1_16), sw3(P0_23);

class Fahrradleuchte 
{
    public:
     void Init()
     {
       state = 1; t1.start();    
     }
     void State1Func();
     void State2Func();
     void State3Func();
    public:
     void State1Action();
     void State2Action();
     void State3Action();
    public:
     int state;
     Timer t1;
};

// Ein Objekt der Klasse Fahrradleuchte anlegen
Fahrradleuchte fl;   

int main()
{
  sw4.Init(); sw3.Init();
  fl.Init();   
  while (1)
  {
    if (fl.state == 1) 
      fl.State1Func(); 
    if (fl.state == 2) 
      fl.State2Func();
    if (fl.state == 3) 
      fl.State3Func();      
 }
}

void Fahrradleuchte::State1Func()
{ 
  // Einmalige Aktionen beim Eintritt in die Zustandsfunktion
  t1.reset();
  stLED = 1; // Anzeigen, dass wir im Zustand 1 sind
  
  // Zyklische Aktionen in der Zustandsfunktion   
  while (1)
  {
    State1Action();
    if (sw4.CheckFlag())
      { state = 2; return; }
    if (sw3.CheckFlag())
      { state = 3; return; }    
  }
}

void Fahrradleuchte::State1Action()
{
 // LED1 mit 500ms blinken 
 if (t1.read_ms() > 500)
 {
  t1.reset();
  if (lb == 0) 
   lb = 512; //LED1
  else  
   lb = 0;
 }     
}

void Fahrradleuchte::State2Func()
{ 
  // Einmalige Aktionen beim Eintritt in die Zustandsfunktion
  t1.reset();
  stLED = 2; // Anzeigen, dass wir im Zustand 2 sind
  
  // Zyklische Aktionen in der Zustandsfunktion   
  while (1)
  {
    State2Action();
    if (sw4.CheckFlag())
      { state = 3; return; }
    if (sw3.CheckFlag())
      { state = 1; return; }    
  }
}

void Fahrradleuchte::State2Action()
{
 // LED2 mit 200ms blinken 
 if (t1.read_ms() > 200)
 {
  t1.reset();
  if (lb == 0) 
   lb = 256; //LED2
  else  
   lb = 0;
 }     
}

void Fahrradleuchte::State3Func()
{ 
  // Einmalige Aktionen beim Eintritt in die Zustandsfunktion
  t1.reset();
  stLED = 3; // Anzeigen, dass wir im Zustand 3 sind
  
  // Zyklische Aktionen in der Zustandsfunktion   
  while (1)
  {
    State3Action();
    if (sw4.CheckFlag())
      { state = 1; return; }
    if (sw3.CheckFlag())
      { state = 2; return; }    
  }
}

void Fahrradleuchte::State3Action()
{
 // LED3 mit 100 blinken 
 if (t1.read_ms() > 100)
 {
  t1.reset();
  if (lb == 0) 
   lb = 128; //LED3
  else  
   lb = 0;
 }     
}
