#include "mbed.h"

#define ARR_SIZE 5

BusOut _led1(LED1), _led2(LED2), _led3(LED3), _led4(LED4);
Serial _pc(USBTX, USBRX);
InterruptIn _async(P1_16);
Timer t1;
char _recChar = 0, _recArr[ARR_SIZE];
int _index = 0, _failstate = 0;

void ReadData();
void Interrupt();
void Error();
void WriteData();
void ToggleLeds();
void FlushSerialBuffer();
void Start();
void Init();
void Output();
void Failstate();

int main(){
    Init();
    Start();
    _pc.attach(&ReadData);
    Interrupt();
    while(1){
        if(_failstate == 1){
            t1.start();
            if(t1.read_ms() >= 100 && _failstate == 1){
                ToggleLeds();
                t1.stop();
                t1.reset();  
            }             
        }
    }
}
void ReadData(){
    _recChar = _pc.getc();
    _recArr[_index] = _recChar;
    _index++;
    if(_recChar == 'a' || _recChar == 'A'){
        _led1 = _led2 = _led3 = _led4 = 0;
        Output();
        _recArr[_index] = 0;
        _index = 0; 
        FlushSerialBuffer();
    }
    else if(_recChar == 'e' || _recChar == 'E'){
        _led1 = _led2 = _led3 = _led4 = 1;
        Output();
        _recArr[_index] = 0; 
        _index = 0;
        FlushSerialBuffer();
    }
    else if(_recChar == 't' || _recChar == 'T'){
        ToggleLeds();
        Output();
        _recArr[_index] = 0;
        _index = 0;
        FlushSerialBuffer();
    }
    else{
        Failstate();
        FlushSerialBuffer();
    }
}
void Interrupt(){
    _async.rise(&Error);
}
void Error(){
            _failstate = 0;
            _led1 = _led4 = 1; _led2 = _led3 = 0;           
}
void ToggleLeds(){
    _led1 = !_led1; _led2 = !_led2; _led3 = !_led3; _led4 = !_led4;    
}
void FlushSerialBuffer(){ 
    while(_pc.readable()){ 
        _pc.getc(); 
    }
}
void Start(){
    _pc.printf("Hallo\r\nBitte geben Sie einen Steuerstring nach untem stehenden Format ein\r\nFormat des Strings:\r\n\   a oder A --> LEDs aus\r\n   e oder E --> LEDs ein\r\n   Lx,E --> LED x ein (x = 1..4)\r\n   Lx,A --> LED x aus (x = 1..4)\r\n   t --> alle LEDs toggeln (leuchtende LEDs aus, dunkle LEDs ein)\r\n");
}
void Init(){
    _led1 = _led2 = _led3 = _led4 = 0;
    _pc.baud(115200);
    _pc.format(8,SerialBase::None, 1);
}
void Output(){
    _pc.printf("Steuerbefehl <%s> ausgefuehrt\r\nBitte geben Sie einen Steuerstring ein\r\n", _recArr);
}
void Failstate(){ 
    _failstate = 1;   
    _led1 = _led2 = _led3 = _led4 = 0;
    _pc.printf("Ein Fehler ist aufgetreten\r\n");
    _recArr[_index] = 0;
    _index = 0;
}