#include "mbed.h"

#define ARR_SIZE 5

BusOut _led1(LED1), _led2(LED2), _led3(LED3), _led4(LED4);
Serial _pc(USBTX, USBRX);
InterruptIn _asyncError(p14);

char _recChar=0;
char _recArr[ARR_SIZE];
int _index=0;
int _StateError=0;
bool _error;
Ticker _tick;
bool _recAllowedFlag;

void Init();
void ReadData();
void SetError();
void CheckWord();
void FlushSerialBuffer();
void flashLeds();




int main()
{

    Init();
    _pc.attach(&ReadData);
    _asyncError.rise(&SetError);

    while(1) {
        if(_error) {

            switch (_StateError) {
                case 0:
                    _pc.printf("Unbekannter Befehl \r\n");
                    _tick.attach_us(&flashLeds, 100*1000);
                    break;


                case 1:
                    _pc.printf("Falscher Syntax \r\n");
                    _tick.attach_us(&flashLeds, 100*300);
                    break;

                case 2:
                    _led1=0;
                    _led2=1;
                    _led3=1;
                    _led4=0;
                    break;
            }
        }
    }
}
// Init

void Init()
{
    _led1=0;
    _led2=0;
    _led3=0;
    _led4=0;
    _error=false;
    _recAllowedFlag=false;
    _pc.baud(115200);
    _pc.format(8,SerialBase::None,1);
    _pc.printf("Hallo\r\n");
    _pc.printf("Geben sie den Steuerstring ein : \r\n");
    _pc.printf("Format: a or A -> LEDs aus \r\n");
}


void ReadData()
{
    _error=false;
    _StateError=0;
    _recChar = _pc.getc();
    _recArr[_index] = _recChar;
    _index++;
    if(_recChar== 0 || _recChar == '\r') {
        if(_error==false)
            CheckWord();
    }

}

void SetError()
{
    _error=true;
    _StateError=2;
}
void CheckWord()
{
// reset LED´s
    if(_recArr[0] == 'r' ||   _recArr[0] == 'R') {
        if(_recArr[3]== 1)
            _led1=0;

        if(_recArr[3]== 2)
            _led2=0;

        if(_recArr[3]== 3)
            _led3=0;

        if(_recArr[3]== 4)
            _led4=0;


        FlushSerialBuffer();

    }
// set LED
    if(_recArr[0] == 's' ||   _recArr[0] == 'S') {
        if(_recArr[3]== 1)
            _led1=1;

        if(_recArr[3]== 2)
            _led2=1;

        if(_recArr[3]== 3)
            _led3=1;

        if(_recArr[3]== 4)
            _led4=1;

        FlushSerialBuffer();
    }
// invert all LED´s
    if(_recArr[0] =='I') {
        _led1=!_led1;
        _led2=!_led2;
        _led3=!_led3;
        _led4=!_led4;
        FlushSerialBuffer();
    }
// check for correct command
    if(_recArr[0]!=('s'||'S'||'r'||'R'||'I')) {
        _error=true;
        _StateError=1;
    }
// check for syntax error
    if(_recArr[3]>5 || _recArr[3]<1) {
        _error=true;
        _StateError=2;
    }

    _pc.printf(" - Eingabe beendet; Wort =  %s\r\n", _recArr);


    _pc.printf("Geben sie den Steuerstring ein : \r\n");
    _pc.printf("Format siehe Blatt  \r\n");

}

void FlushSerialBuffer()
{
    while (_pc.readable()) {
        _pc.getc();
    }
}

// flash all led´s
void flashLeds()
{
    _led1=!_led1;
    _led2=!_led2;
    _led3=!_led3;
    _led4=!_led4;
}

