/*----------------------------------------------------------------------------
LAB EXERCISE 9 - Analog input and PWM
 ----------------------------------------
    Use two potentiometers to adjust the volume and pitch of the output sound wave.
    
    Inputs: Virtual potentiometers 1 and 2
    Output: Virtual speaker,  Real PC

    GOOD LUCK!
 *----------------------------------------------------------------------------*/

#include "mbed.h"
#include "pindef.h"

/*
Define the PWM speaker output
Define analog inputs
Define serial output
*/

    PwmOut Audio(PB_10);     // Audi out 
    AnalogIn Pot1(PA_0);    //linear potentiomenter 1
    AnalogIn Pot2(PA_1);    //linear potentiomenter 2
    


//Define variables
float i;

/*----------------------------------------------------------------------------
 MAIN function
 *----------------------------------------------------------------------------*/

int main(){
    double i=0;      //incrementor for saw-tooth
    uint16_t Freq_set, Duty_set;    // Values to store potentiometer settings for Duty cyle and frequency 
    float period, PulseW; 
    
    
    while(1){
        /*
        Print values of the potentiometers to the PC serial terminal
        Create a saw-tooth sound wave
        Make the period and volume adjustable using the potentiometers
        */
        Freq_set = Pot1.read_u16();
        Duty_set = Pot2.read_u16();
        
         printf(" value at Potentiometer 1: %u\r\n", Freq_set);
         printf(" value at Potentiometer 2: %u\r\n", Duty_set );
        
        if (i<1){
            i+=0.05;  //increment saw-tooth
            
        }
        else{
            i=0; //reset saw-tooth
        }
        
        
        //Calcuate period in us for freq between 320Hz and 8KHz
        period = 3125 - 3* ((float)Freq_set *1000) / 65535;
        
        
        
        //Calculate duty cycle from 0 to 1 scaled by i 
        PulseW = (float)Duty_set / 65535 * period*i;
        
        

        
        //Generate PWM
        Audio.period_us((int)(period));
        Audio.pulsewidth_us((int)PulseW);
        //Audio.period_ms(100);
        //Audio.pulsewidth_us((int)(period/2));
        
        wait_us((int)(period));
        
    }
}

// *******************************ARM University Program Copyright © ARM Ltd 2014*************************************
