/* #############################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-F103C8_Torreta
**    Procesador     : STM32F103C8T6
**    Plataforma     : Blue Pill
**    Herramienta    : Mbed Compiler
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define     Ticker_Rate     1000            // Periodo de interrupción (us)
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
Ticker      Barrido;                    // Interrupción del Timer
//BusOut      Torreta(D0,D1,D2,D3,D4,D5,D6,D7); // Utilizando las definiciones Arduino
BusOut      Torreta(PB_4,PB_3,PA_15,PA_12,PA_11,PA_10,PA_9,PA_8); // 
DigitalOut  Led_Monitor (LED1);         // Led monitor de la Tarjeta STM32F103C8
//PwmOut     Buzzer(PB_1);                // PB1_TIM3_CH4N
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint8_t Secuencias[]={
        0x03, 0x03, 0xC0, 0xC0, 0x03, 0x03, 0xC0, 0xC0, //   8
        0x03, 0x03, 0xC0, 0xC0, 0x03, 0x03, 0xC0, 0xC0, //  16
        0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, //  24
        0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, 0x03, 0xC0, //  32
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0xC0, //  40
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0x00, //  48
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0x00, //  56
        0x03, 0x00, 0x03, 0x00, 0xC0, 0x00, 0xC0, 0x00, //  64  
        0x07, 0x08, 0x13, 0x20, 0xC0, 0x20, 0xC8, 0x04, //  72
        0x07, 0x08, 0x13, 0x20, 0xC0, 0x20, 0xC8, 0x04, //  80 
        0x07, 0x0B, 0xD0, 0xE0, 0x07, 0x0B, 0xD0, 0xE0, //  88
        0x07, 0x0B, 0xD0, 0xE0, 0x07, 0x0B, 0xD0, 0xE0, //  96 
        0x23, 0x13, 0xC8, 0xC4, 0x23, 0x13, 0xC8, 0xC4, // 104
        0x23, 0x13, 0xC8, 0xC4, 0x23, 0x13, 0xC8, 0xC4, // 112
        0x23, 0x10, 0xC8, 0x04, 0x23, 0x10, 0xC8, 0x04, // 120
        0x23, 0x10, 0xC8, 0x04, 0x23, 0x10, 0xC8, 0x04, // 128   
        0x07, 0x43, 0xD0, 0xC4, 0x07, 0x43, 0xD0, 0xC4, // 136
        0x07, 0x43, 0xD0, 0xC4, 0x07, 0x43, 0xD0, 0xC4, // 144           

        0x03, 0x04, 0x08, 0x10, 0x20, 0xC0, 0x20, 0x10, // 152
        0x08, 0x04, 0x03, 0x04, 0x08, 0x10, 0x20, 0xC0, // 160 
        0x20, 0x10, 0x08, 0x04, 0x03, 0x04, 0x08, 0x10, // 168
        0x20, 0xC0, 0x20, 0x10, 0x08, 0x04, 0x03, 0x04, // 176       
        0x08, 0x10, 0x20, 0xC0, 0x20, 0x10, 0x08, 0x04, // 184
      
        0x03, 0x18, 0xC0, 0x3C, 0x03, 0x24, 0xC0, 0x3C, // 192              

        0x04, 0x08, 0x10, 0x20, 0x04, 0x08, 0x10, 0x20, // 200
        0x04, 0x08, 0x10, 0x20, 0x04, 0x08, 0x10, 0x20, // 208
        0x20, 0x10, 0x08, 0x04, 0x20, 0x10, 0x08, 0x04, // 216
        0x20, 0x10, 0x08, 0x04, 0x20, 0x10, 0x08, 0x04, // 224
        0x03, 0x04, 0x03, 0x08, 0x03, 0x10, 0x03, 0x20, // 232
        0x03, 0x04, 0x03, 0x08, 0x03, 0x10, 0x03, 0x20, // 240        
        0xC0, 0x20, 0xC0, 0x10, 0xC0, 0x08, 0xC0, 0x04, // 248
        0xC0, 0x20, 0xC0, 0x10, 0xC0, 0x08, 0xC0, 0x04, // 256
        0x04, 0x08, 0x10, 0x20, 0x20, 0x10, 0x08, 0x04, // 264
        0x04, 0x08, 0x10, 0x20, 0x20, 0x10, 0x08, 0x04, // 272
        0x88, 0x44, 0x11, 0x22, 0x88, 0x44, 0x22, 0x11, // 280
        0x88, 0x44, 0x11, 0x22, 0x88, 0x44, 0x22, 0x11, // 288
        0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88, // 296
        0x11, 0x22, 0x44, 0x88, 0x11, 0x22, 0x44, 0x88, // 304
        0x18, 0x24, 0x18, 0x24, 0x18, 0x24, 0x18, 0x24, // 312
        0x18, 0x24, 0x18, 0x24, 0x18, 0x24, 0x18, 0x24, // 320
        0x18, 0x81, 0x3C, 0xC3, 0x24, 0x42, 0x0F, 0xF0, // 328
        0x18, 0x81, 0x3C, 0xC3, 0x24, 0x42, 0x0F, 0xF0, // 336
        0x18, 0xC3, 0x24, 0xC3, 0x18, 0xC3, 0x24, 0xC3, // 344
        0x18, 0xC3, 0x24, 0xC3, 0x18, 0xC3, 0x24, 0xC3, // 352
        0x20, 0x30, 0x10, 0x18, 0x08, 0x0C, 0x04, 0x03, // 360
        0x04, 0x0C, 0x08, 0x18, 0x10, 0x30, 0x20, 0xC0, // 368
        0x20, 0x30, 0x10, 0x18, 0x08, 0x0C, 0x04, 0x03, // 376
        0x04, 0x0C, 0x08, 0x18, 0x10, 0x30, 0x20, 0xC0, // 384
        0x81, 0x81, 0x7E, 0x7E, 0x81, 0x81, 0x7E, 0x7E, // 392
        0x81, 0x7E, 0x81, 0x7E, 0x81, 0x7E, 0x7E, 0x81, // 400
        0x81, 0x00, 0x81, 0x00, 0x7E, 0x00, 0x7E, 0x00, // 408
        0x81, 0x00, 0x81, 0x00, 0x7E, 0x00, 0x7E, 0x00, // 416        
        0x80, 0x00, 0x01, 0x00, 0x7E, 0x00, 0x7E, 0x00, // 424
        0x80, 0x00, 0x01, 0x00, 0x7E, 0x00, 0x7E, 0x00, // 432

        0x33, 0xCC, 0x33, 0xCC, 0x33, 0xCC, 0x33, 0xCC, // 440
        0x03, 0x3C, 0x03, 0x3C, 0xC0, 0x3C, 0xC0, 0x3C, // 448
        0x03, 0x3C, 0x03, 0x3C, 0xC0, 0x3C, 0xC0, 0x3C, // 456        
        0x3C, 0x00, 0xC3, 0x00, 0x3C, 0x00, 0xC3, 0x00, // 464
        0x3C, 0x00, 0xC3, 0x00, 0x3C, 0x00, 0xC3, 0x00, // 472
        0x3C, 0x3C, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, // 480
        0x3C, 0x3C, 0x00, 0x00, 0x3C, 0x3C, 0x00, 0x00, // 488
        0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, // 496
        0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, 0x3C, 0x00, // 504
        0xC3, 0x3C, 0xC3, 0x3C, 0xC3, 0x3C, 0xC3, 0x3C, // 512
        0xC3, 0x3C, 0xC3, 0x3C, 0xC3, 0x3C, 0xC3, 0x3C, // 520
        0xC0, 0x3C, 0x03, 0x3C, 0xC0, 0x3C, 0x03, 0x3C, // 528
        0xC0, 0x3C, 0x03, 0x3C, 0xC0, 0x3C, 0x03, 0x3C, // 536        
        0xC0, 0x3C, 0x03, 0x3C, 0xC0, 0x3C, 0x03, 0x3C, // 544
        0xC0, 0x3C, 0x03, 0x3C, 0xC0, 0x3C, 0x03, 0x3C, // 552
        0x00, 0x28, 0x00, 0x14, 0x00, 0x28, 0x00, 0x14, // 560
        0x00, 0x28, 0x00, 0x14, 0x00, 0x28, 0x00, 0x14, // 568
        0xC0, 0xF0, 0x30, 0x0C, 0x0F, 0xC0, 0xF0, 0x30, // 576
        0x0C, 0x0F, 0xC0, 0xF0, 0x30, 0x0C, 0x0F, 0x03, // 584
        0x03, 0x0F, 0x0C, 0x30, 0xF0, 0xC0, 0x0F, 0x0C, // 592
        0x30, 0xF0, 0xC0, 0x0F, 0x0C, 0x30, 0xF0, 0xC0, // 600
        0x00, 0xC0, 0xF0, 0x30, 0x3C, 0x0C, 0x0F, 0x03, // 608
        0x00, 0xC0, 0xF0, 0x30, 0x3C, 0x0C, 0x0F, 0x03, // 616
        0x00, 0x03, 0x0F, 0x0C, 0x3C, 0x30, 0xF0, 0xC0, // 624
        0x00, 0x03, 0x0F, 0x0C, 0x3C, 0x30, 0xF0, 0xC0, // 632
        0x00, 0xC0, 0xF0, 0x30, 0x3C, 0x0C, 0x0F, 0x03, // 640
        0x00, 0xC0, 0xF0, 0x30, 0x3C, 0x0C, 0x0F, 0x03, // 648        
        0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xF0, // 656
        0x00, 0x0F, 0xFF, 0xF0, 0x00, 0x0F, 0xFF, 0xF0, // 674
        0x00, 0xF0, 0x00, 0x0F, 0x00, 0xF0, 0x00, 0x0F, // 682
        0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0xFF };

uint16_t No_Secuencias=689;     // Número de secuencias a desplegar
uint16_t i=0;                   // Indice para las secuencias
uint16_t delay=250;             // Tiempo de retardo entre secuencias (en ms)
uint16_t contador=0;            // Contador de mili segundos

/* END Global Variables */           
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void);  

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{       // Inicialización de variables locales, puertos e interrupciones van aquí !!!
confSysClock();     // Inicialización del Sistema, 
Barrido.attach_us(&Barrido_OnInterrupt, Ticker_Rate);   // Periodo de la Interrupción por Timer = 1ms (Tcker_Rate=1000)

    while (true)                // El Lazo del Programa principal está aquí !!!
    {
                                //El Programa principal no hace nada !!!
    }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void Barrido_OnInterrupt()
{
    /* Rutina de Atención a la Interrupción */
    /* Write your code here ... */
    
    contador++;                     // Incremeta el contador de mili segundos
    if (contador == delay)          // Contador es igual al retardo programado?
    {
    Torreta=Secuencias[i];          // Escribe la secuencia
    i++;                            // Incrementa el índice
    if (i >= No_Secuencias) i=0;    // Es la última secuencia?
    contador =0;                    // Reinicia contador de retardo
    Led_Monitor = !Led_Monitor;     // Parpadeo del Led Monitor
    }
}
/* END Events */


/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                    // Las Funciones Prototipo van aquí !
//void confSysClock(void);    // Configure system clock (72MHz HSE clock, 48MHz USB clock)

/* END functions */    
                
/* END program */

/*+-----------------------------------------------------------------------------       
*+ La documentación va aquí!:
+--------------------------------------------------------------------------------
|                               EJERCICIO
|
| 1.-   Modificar este programa para: 
|       a) Agregar más secuencias (mínimo 32).
|       b) Realizar el barrido del arreglo de atrás hacia adelante y repetir
| 2.-   Modificar el programa para incluir secuencias de sonidos utiliando el 
|       módulo PWM (Sirena).
|       
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-   Modificar el programa para que despliegue un rango de secuencias  
|       determinado.
| 2.-   Modificar el programa para incluir un menú de selección de secuencias.
|       a) Para la Torreta
|       b) Para la Sirena
|       c) Combinados
| 3.-   Volver a realizar éste programa utilizando tambien con apuntadores.
|
|       Mucha Suerte!                       
|
*+----------------------------------------------------------------------------*
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved            
*+
*+  Welcome to The Beaners Proyect Community!                   
*+----------------------------------------------------------------------------*/

/* END Mbed */   