/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-F103C8_Barrido_Teclado
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto hace...
**         This module contains user's application code.
**   Componentes     : GPIO, Timer, etc .
**   Configuraciones : Includes, Stacks y Drivers externos
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Added support for Led_RGB
**                    22/09/2018 
**                    Added LCD Menu, Beta version (with bugs)
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
//#include "Led_RGB.h"
//#include "Serial.h"
//#include "stdio.h"

/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define     on              0           // Estado para boton presionado
#define     off             1           // Estado para boton sin presionar
#define     hold            2           // Estado para boton mantenido
#define     release         3           // Estado para boton liberado
#define     TRUE            1
#define     FALSE           0
#define     Ticker_Period   1000        // Periodo de Tiempo del Ticker (us)
#define     Rate_Period     2           // Tiempo de Encendido de los Digitos (ms)
#define     Scan_Time       2           // Tiempo de Barrido del Display (ms)
#define     Shift_Time      2           // Tiempo de corrimiento  (x Counter_Time)
#define     Counter_Time    100         // Tiempo de counter (ms)
#define     String_Size     20          // Tamaño del Buffer de Caracteres
#define     Digit_Null      0xFF        // Valor para apagar los Segmentos 
#define     Degree_Symbol   0x0F        // Valor para el Símbolo de Grados
#define     DO2             0.0078125            // 128 Hz      (Escala Filosófica)
#define     DOs2            0.0073740180703125   // 136 Hz
#define     RE2             0.006960146234375    // 144 Hz
#define     REs2            0.0065695032421875   // 152 Hz
#define     MI2             0.006200785359375    // 161 Hz
#define     FA2             0.005852762015625    // 171 Hz
#define     FAs2            0.0055242717265625   // 181 Hz
#define     SOL2            0.0052142181796875   // 192 Hz
#define     SOLs2           0.0049215666015625   // 203 Hz
#define     LA2             0.004645340296875    // 215 Hz
#define     LAs2            0.004384617375       // 228 Hz
#define     SI2             0.0041385277109375   // 242 Hz
#define     DO3             0.00390625           // 256 Hz
#define     DOs3            0.00368700903515625  // 271 Hz
#define     RE3             0.0034800731171875   // 287 Hz
#define     REs3            0.00328475162109375  // 304 Hz
#define     MI3             0.0031003926796875   // 323 Hz
#define     FA3             0.0029263810078125   // 342 Hz
#define     FAs3            0.0055242717265625   // 362 Hz
#define     SOL3            0.00260710908984375  // 384 Hz
#define     SOLs3           0.00246078330078125  // 406 Hz
#define     LA3             0.0023226701484375   // 431 Hz
#define     LAs3            0.0021923086875      // 456 Hz
#define     SI3             0.00206926385546875  // 483 Hz
#define     DO4             0.00390625           // 512 Hz
#define     DOs4            0.001843504517578125 // 542 Hz
#define     RE4             0.00174003655859375  // 575 Hz
#define     REs4            0.001642375810546875 // 609 Hz
#define     MI4             0.00155019633984375  // 645 Hz
#define     FA4             0.00146319050390625  // 683 Hz
#define     FAs4            0.001381067931640625 // 724 Hz
#define     SOL4            0.001303554544921875 // 767 Hz
#define     SOLs4           0.001230391650390625 // 813 Hz
#define     LA4             0.00116133507421875  // 861 Hz
#define     LAs4            0.00109615434375     // 912 Hz
#define     SI4             0.001034631927734375 // 966 Hz
#define     DO5             0.001953125          // 1024 Hz
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
BusIn       Renglones (PA_8, PA_9, PA_10, PA_11);   // Definición para los Renglones
BusOut      Anodos    (PB_6, PB_7, PB_8, PB_9);     // Definición para los Ánodos
BusOut      Catodos   (PA_0, PA_1,PA_2,PA_3,PA_4,PA_5,PA_6,PA_7);    // Definición para los Cätodos
DigitalOut  Led_Verde (PC_11);          // Led de Actividad del Programa
DigitalOut  Led_Rojo  (PB_11);          // Led de Actividad del Programa
PwmOut      Buzzer    (PB_13);          // Salida del Buzzer
Ticker      Barrido;                    // Interrupción por el Temporizador
// *****    Host PC Terminal Communication channels
Serial      Terminal (PA_2, PA_3);           // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial      Terminal(USBTX, USBRX);     // Activa la Terminal a traves del Puerto USB
/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint16_t Rate=1000;
//             Offset:  0    1    2    3    4    5    6    7    8    9   10    11  12   13   14   15   16   17   18   19   20   21  22    23   24   25   26   27   28   29   30   31   32   33   34   35   36   37   38   39   40   41   42   43   44   45   46   47  48   49   50   51   52   53   54   55   56   57   58   59   60   61   62   63   64   65   66   67   68   69   70   71   72   73   74   75   76   77   78   79   80   81   82   83   84   85   86   87   88   89   90   91  92
//Caracter a Desplegar: 0    1    2    3    4    5    6    7    8    9    A     b   C    d    E    f    G    h    I    j    K    L   M     n    o    P    q    r    S    t    u    V    W    X    y    Z  space a    e    /e   @    ñ    [    ]    U    /U   /_   -    _   _/_  /=   =   ==    °   +/c   +n   +/c  +u   o    c    n    /c   u    ^    ¬   + >   ^   / v   <    v    >   i    +i   /i   +/i  ii   +ii  #   /#    J    /J   -J   -/J  |    ||     |  +    /+   F    +F   /F   +/F  null         !  "   #   $  %   &   '   (    )   *   +   -   .   /   :   ;   <   >   ?   @
uint8_t  Segmentos[]={0x81,0xE7,0x49,0x43,0x27,0x13,0x11,0xC7,0x01,0x03,0x05,0x31,0x99,0x61,0x19,0x1D,0x91,0x35,0xBD,0xE3,0x2D,0xB9,0x85,0x75,0x71,0x0D,0x07,0x7D,0x13,0x39,0xF1,0xB1,0xA1,0x25,0x23,0x49,0xFF,0x41,0x09,0x03,0x11,0x55,0x99,0xC3,0xA1,0x85,0xDF,0x7F,0xFB,0xDB,0x7B,0x5F,0x5B,0x0F,0x1F,0x8F,0x4F,0x2F,0x71,0x79,0x75,0x73,0xF1,0x3F,0x9F,0xCF,0x6F,0x7D,0xF9,0xF3,0x77,0xFD,0xBF,0xF7,0xEF,0xF5,0xAF,0x6D,0x37,0xE3,0xB9,0x9D,0xC7,0xBD,0xA5,0xE7,0x3D,0x67,0x1D,0x47,0x63,0x39,0x00};
uint8_t  Digitos[]={0x08,0x04,0x02,0x01,0x00,0x0F};     // Millares, Centenas, Decenas, Unidades, Apagados, Encendidos
uint8_t  Numeros[]={1,0,2,4};
uint8_t  Cadena[]={33,0,21,10,36,14,28,18,22,36,35,10,12,10,29,14,23,12,24,36,36};
uint8_t  Tecla[]={1,2,3,10,4,5,6,11,7,8,9,12,75,0,74,13};
uint8_t  Boton[]={1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1};
uint8_t  Boton_Ant[]={1,1,1,1, 1,1,1,1, 1,1,1,1, 1,1,1,1};
uint8_t  Edo_Boton[]={off,off,off,off, off,off,off,off, off,off,off,off, off,off,off,off};
uint8_t  Renglon[]={0,0,0,0};
uint8_t  punto_decimal=0;   //Posición del punto decimal: 0=sin punto, 1=unidades, 2=decenas, 3=centemas 4=millares,  
uint8_t  cont_1ms;
uint8_t  cont_10ms;
uint8_t  cont_100ms;
uint8_t  cont_1s;
uint8_t  scan_rate=25;
uint8_t  shift_rate=0;
uint16_t counter=250;
uint8_t  i=0;
uint8_t  j=0;
uint8_t  valor=0;
uint8_t  nchar=0;
bool     flag1=FALSE;
bool     flag2=FALSE;
bool     Blinking=FALSE;
bool     mode=0;

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Barrido_OnInterrupt(void);  
void Buzzer_SetPeriodMode(float Periodo,bool Estado);
/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()
{
                        // Inicialización de variables, puertos e interrupciones
  confSysClock();       // Configure system clock (72MHz HSE clock, 48MHz USB clock)                                               
  Barrido.attach_us(&Barrido_OnInterrupt, Ticker_Period);   // Periodo de Interrupción del Timer = 1ms (Ticker_Period=1000)
  Renglones.mode(PullUp);   // Habilita los Pull-Up's de las entradas de los renglones
  Terminal.baud(115200);    // Establece la velocidad de Transmisión de la Terminal
  Terminal.printf("\e[2J");                       // Clear Screen  
  Terminal.printf(" System is Wake Up!.\n\r");    // e inicia la  comunicación serial
  Terminal.printf ("\t\e[1;37;41mInstituto Politecnico Nacional\e[0m\n\r");
  Terminal.printf ("\e[1;37;42mESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\e[0m\n\r\v");
  Terminal.printf ("\t\e[1;34;40mBarrido \e[1;37;40mdel \e[1;31;40mDisplay \e[1;33;40mde \e[1;32;40m7 Segmentos\e[0m \e[1;35;40my \e[1;36;40mTeclado \n\r\v\v\e[0m");
  while (TRUE) 
  {                   //El Programa principal está aquí !!!      
    nchar=0;                            // Inicializa el contador de caracteres a desplegar   
    if (flag1==TRUE)
      {
//        Buzzer_SetPeriodMode(LA4,FALSE);// Apaga el Buzzer            
//        Buzzer=off;                     // Apaga el Buzzer
            //------------------ Barrido de los Digitos ------------------------
        Anodos=Digitos[4];              // Apaga todos los Digitos (Evita fantasmas)   
        Catodos=Segmentos[Numeros[i]];  // Escribe los segmentos del Dígito
        if (i==4-punto_decimal) Catodos=(Segmentos[Numeros[i]]& 0xFE); // Enciende el punto decimal 
        Anodos=Digitos[i];              // Activa el Dígito/columna  
            //------------------ Barrido del Teclado ---------------------------                         
        valor=Renglones;                // Lee los renglones. Posibles valores: 0xFF,0xFE,0xFD,0xFB,0xF7
        if (valor==0x0E)
        {
          if (i==0) printf ("Tecla=1\r");  
          if (i==1) printf ("Tecla=2\r");
          if (i==2) printf ("Tecla=3\r");  
          if (i==3) printf ("Tecla=F1\r");
        }
        if (valor==0x0D)
        {
          if (i==0) printf ("Tecla=4\r");  
          if (i==1) printf ("Tecla=5\r");
          if (i==2) printf ("Tecla=6\r");  
          if (i==3) printf ("Tecla=F2\r");
        }        
        if (valor==0x0B)
        {
          if (i==0) printf ("Tecla=7\r");  
          if (i==1) printf ("Tecla=8\r");
          if (i==2) printf ("Tecla=9\r");  
          if (i==3) printf ("Tecla=F3\r");
        }
        if (valor==0x07)
        {
          if (i==0) printf ("Tecla=*\r");  
          if (i==1) printf ("Tecla=0\r");
          if (i==2) printf ("Tecla=#\r");  
          if (i==3) printf ("Tecla=F4\r");
        }        
        if (valor==0x0F)
        {
          if (i==0) printf ("Tecla=H\r");  
          if (i==1) printf ("Tecla=O\r");
          if (i==2) printf ("Tecla=L\r");  
          if (i==3) printf ("Tecla=A\r");
        }        
         
//        Renglon[i]=(valor>>i)&1;        // Obtiene el valor de cada bit del renglón 
//        Boton[i+j]=Renglon[i];          // Llena el renglon-columna correspondiente
        Terminal.printf("Tecla Oprimida: %c\r",valor);              
/*        if (Boton[i+j]==1)
        {
//          Buzzer_SetPeriodMode(DO5,TRUE); // Selecciona Tono y lo habilita
//          Buzzer=on;                      // Enciende el Buzzer
        }
        if ( Boton[i+j] &&  Boton_Ant[i+j]) 
        {
          Edo_Boton[i+j]= off;          // El Botón está Apagado
        }   
        if (!Boton[i+j] &&  Boton_Ant[i+j]) 
        {
          Edo_Boton[i+j]= on;           // El Botón está Encendido
        }  
        if (!Boton[i+j] && !Boton_Ant[i+j]) 
        {
           Edo_Boton[i+j]= hold;        // El Botón está Presionado
        } 
        if ( Boton[i+j] && !Boton_Ant[i+j]) 
        {
           Edo_Boton[i+j]= release;     // El Botón está Liberado
        } 
        Boton_Ant[i+j]=Boton[i+j];      // Actualiza el valor del botón anterior
        if (valor != 0xFF)
        {
           Numeros[0]= Digit_Null;      // Millares
           Numeros[1]= Digit_Null;      // Centenas
           Numeros[2]= Digit_Null;      // Decenas
           Numeros[3]= Tecla[i+j];      // Unidades
           mode=2;
        }    
*/
        i++;                            // Incrementa la columna
        if (i==4)                       // Se terminó de barrer las columnas?  
        {
          i=0;                          // Reinicia las columnas
          j=j+4;                        // Brinca al siguiente renglón
          if (j==16) j=0;               // Se terminó de barrer los renglones? Reinicia los renglones
          
          if (mode==1)                  // Se va a desplegar un mensaje?
          {
            Numeros[i]=Cadena[i+nchar]; // Cargamos 4 caracteres en el buffer de despliege
            if (nchar >= String_Size) nchar=0;   // Restablece el contador de caractres
          }
            if (mode==2)                // Se va a desplegar un el valor de la botonera
            {
              if ( Blinking==1) punto_decimal=3;  // Activa los puntos del Reloj
              if ( Blinking==0) punto_decimal=0;  // Desactiva los puntos del Reloj
              if (i==4-punto_decimal)
              Catodos=Segmentos[Numeros[i]&0xFE];  // Enciende el punto decimal 
              Terminal.printf("Tecla Oprimida: %c\r",valor);                   
            }
            Led_Rojo=!Led_Rojo;         // Parpadeo del Led Rojo
        }
                
        flag1=FALSE;                    // Apaga la Bandera 1
    }    
    if (flag2==TRUE)                    // Está puesta la Bandera 2?
    {
      Led_Verde=!Led_Verde;             // Parpadeo del Led Verde
      flag2=FALSE;                      // Apaga la Bandera 2
    } 
  }
}
/* END main() */
/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
void Barrido_OnInterrupt()          // Rutina de Atención al Ticker
{
    cont_1ms++;                     // Incrmenta el contador de milisegundos
    scan_rate--;                    // Decrementa el tiempo de  despliege
    counter--;                      // Decrementa el contador de eventos
    if(!scan_rate)                  // Se terminó el tiempo de barrido 
    {
        scan_rate=Rate_Period;      // Restablece el tiempo de barrido? 
        flag1=TRUE;                 // Enciende la bandera para las rutinas de despliege y teclado 
    }        
    if (cont_1ms>=10)
    {
        cont_10ms++;
        cont_1ms=0;
    }      
    if (cont_10ms>=10)
    {
        cont_100ms++;
        cont_10ms=0;
    }    
    if (cont_100ms>=10)
    {
        cont_1s++;
        cont_100ms=0;
    }    
    if (cont_1s>=10) 
    {
        cont_1s=0;
    }
    if (!counter)                   // Se terminó de contar? 
    {
        counter=500;                // Restablece el contador
        Blinking= !Blinking;        // Parpadeo
        shift_rate --;              // Decrementa el tiempo del corrimiento
        flag2=TRUE;                 // Prende la bandera para realizar un desplazamiento         
    }
    if (!shift_rate)                // Se terminó el tiempo de corrimiento? 
    {    
        mode=!mode;                 // Tiempo entre desplazamientos del mensaje
        shift_rate = Shift_Time;    // Restablece el tiempo de los corrimientos
    }
}   
/* END Events */

/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Buzzer_SetPeriodMode(float Periodo,bool Estado)
{
    Buzzer.period(Periodo);
    Buzzer.pulsewidth(Periodo/2);
    if (Estado==1)Buzzer=0.5; 
    if (Estado==0)Buzzer=0.0; 
}
                
/* END Routines */ 

/* END program */ 
/*+-----------------------------------------------------------------------------
*+        CD4041   Quad Buffer/Inverter 
*+------------------------------------------------------------------------------
*+
*+             |\    1
*+             | \-------  A1
*+          3  |  \
*+ PB_12  -----|   >
*+             |  /  2
*+             | /o------ COL1
*+             |/
*+
*+
*+             |\    8
*+             | \-------  A2
*+          10 |  \
*+ PB_13  -----|   >
*+             |  /  9
*+             | /o------ COL2
*+             |/
*+
*+
*+             |\    4
*+             | \-------  A3
*+          6  |  \
*+ PB_14  -----|   >
*+             |  /  5
*+             | /o------ COL3
*+             |/
*+
*+
*+
*+             |\    11
*+             | \-------  A4
*+          13 |  \
*+ PB_15  -----|   >
*+             |  /  12
*+             | /o------ COL4
*+             |/
*+
*+------------------------------------------------------------------------------
*+ Descripción del Display de 7 Segmentos de Anodos Comunes en modo multiplexado
*+------------------------------------------------------------------------------
*+                            13 12 11 10  9  8
*+                             |  |  |  |  |  |                         
*+                             |  |  |  |  |  |  
*+               --------------------------------------------------
*+              |               A  a  f  A  A  b                   |
*+              |               4        3  2                      |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____     _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/ .  /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |                              A                   |
*+              |               e  d  p  c  g  1                   |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |  |                       
*+                              |  |  |  |  |  |  |
*+                              1  2  3  4  5  6  7                                  
*+
*+                              Display: HS410561K-D30
*+
*+
*+                            13 12 11 10  9  8
*+                             |  |  |  |  |  |                         
*+                             |  |  |  |  |  |  
*+               --------------------------------------------------
*+              |               A  g  f  p  a  b                   |
*+              |               4                                  |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____     _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/    /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |                  A  A        A                   |
*+              |               e  3  2  c  d  1                   |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |  |                       
*+                              |  |  |  |  |  |  |
*+                              1  2  3  4  5  6  7                                  
*+
*+                               Display: BQ-M544RE
*+
*+
*+                            12 11  10 9  8  7
*+                             |  |  |  |  |  |                           
*+                             |  |  |  |  |  |    
*+               --------------------------------------------------
*+              |              A  a  f  A  A  b                    |
*+              |              4        3  2                       |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____  .  _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/ .  /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |                     A        A                   |
*+              |               e  d  p  c  g  1                   |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |  
*+                              |  |  |  |  |  |             p1 = g
*+                              1  2  3  4  5  6             p2 = c             
*+                                                           p3 = d
*+                              Display: HS-5463BS           p4 = e
*+                              Cátodo Común                 pu = b
*+                                                           pd = f
*+
*+
*+                            16 15 14 13    11 
*+                             |  |  |  |    |                           
*+                             |  |  |  |    |    
*+               --------------------------------------------------
*+              |              b  g  a  c    f                     |
*+              |                                                  |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____  .  _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/ .  /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |               A  A     A     A     A             |
*+              |               4  3  d  p  e  2  p  1             |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |  |  |                      
*+                              |  |  |  |  |  |  |  |
*+                              1  2  3  4  5  6  7  8                                  
*+
*+                              Display: KEM-3942BSR
*+
+*
*+
*+                            12 11 10  9  8  7
*+                             |  |  |  |  |  |                         
*+                             |  |  |  |  |  |  
*+               --------------------------------------------------
*+              |              A  a  f  A  A  b                    |
*+              |              4        3  2                       |
*+              |  ______________________________________________  |             
*+              | |       ____      ____      _____     _____    | |
*+              | |     /     /   /     /    /     /   /     /   | |
*+              | |    /____ /   /____ / .  /____ /   /____ /    | |
*+              | |   /     /   /     / .  /     /   /     /     | |
*+              | |  /____ /.  /_____/ .  /____ /.  /____ /.     | |
*+              | |                                              | |
*+              | |______________________________________________| |
*+              |                                                  |
*+              |                              A                   |
*+              |               e  d  p  c  g  1                   |
*+               --------------------------------------------------
*+                              |  |  |  |  |  |                        
*+                              |  |  |  |  |  |  
*+                              1  2  3  4  5  6                                    
*+
*+                              Display: FYQ-2841BH
*+
*+
*+       FRDM-KL46Z     PTA17 PTA16 PTA15 PTA14
*+      STM32-F103C8    PB_15 PB_14 PB_13 PB_12
*+                        A4    A3    A2    A1
*+                       Mill  Cent  Dec   Uni
*+  
*+     FRDM_KL25Z       PTE23 PTE22 PTE21 PTE20   PTE5  PTE4  PTE3  PTE2     #    Hex     Offset
*+     FRDM-KL46Z       PTE23 PTE22 PTE21 PTE20   PTE19 PTE18 PTE17 PTE16    #    Hex     Offset
*+     STM32-F103C8      PA_8  PA_9 PA_10 PA_11   PA_12 PA_15  PB_3  PB_4    #    Hex     Offset
*+            a
*+         ______         g     f     a     b       c     d     e     p       
*+        /     /         1     0     0     0       1     0     0     0      0    0x81      0
*+     f /  g  / b        1     1     0     1       1     1     1     0      1    0xE7      1
*+      /_____/           1     0     1     1       0     1     0     0      2    0x49      2
*+     /     /            1     0     0     1       0     1     0     0      3    0x43      3
*+  e /     / c           1     1     0     1       0     0     1     0      4    0x27      4
*+   /_____/ .            1     0     0     1       0     0     0     1      5    0x13      5
*+      d    p            1     0     0     0       0     0     0     1      6    0x11      6
*+                        1     1     0     1       1     1     0     0      7    0xC7      7
*+                        1     0     0     0       0     0     0     0      8    0x01      8
*+                        1     0     0     1       0     0     0     0      9    0x03      9
*+                        1     1     0     0       0     0     0     0      A    0x05      10
*+                        1     0     0     0       0     0     1     1      b    0x31      11
*+                        1     0     1     0       1     0     0     1      C    0x99      12
*+                        1     0     0     0       0     1     1     0      d    0x61      13
*+                        1     0     1     0       0     0     0     1      E    0x19      14
*+                        1     1     1     0       0     0     0     1      f    0x1D      15
*+                        1     0     0     0       1     0     0     1      G    0x91      16
*+                        1     1     0     0       0     0     1     1      h    0x35      17
*+                        1     1     0     1       1     1     1     1      i    0xBD      18
*+                        1     0     0     0       1     1     1     0      J    0xE3      19
*+                        1     0     1     0       0     0     1     0      k    0x2D      20
*+                        1     0     1     0       1     0     1     1      L    0xB9      21
*+                        1     1     0     0       1     0     0     0      M    0x85      22
*+                        1     1     0     0       0     1     1     1      n    0x75      23
*+                        1     0     0     0       0     1     1     1      o    0x71      24
*+                        1     1     1     0       0     0     0     0      P    0x0D      25
*+                        1     1     0     1       0     0     0     0      q    0x07      26
*+                        1     1     1     0       0     1     1     1      r    0x7D      27
*+                        1     0     0     1       0     0     0     1      s    0x13      28
*+                        1     0     1     0       0     0     1     1      t    0x39      29
*+                        1     0     0     0       1     1     1     1      u    0xF1      30
*+                        1     0     0     0       1     0     1     1      V    0xB1      31
*+                        1     0     0     0       1     0     1     0      w    0xA1      32
*+                        1     1     0     0       1     0     1     0      X    0x25      33
*+                        1     0     0     1       0     0     1     0      y    0x23      34
*+                        1     0     1     0       1     1     0     0      Z    0x49      35
*+                        1     1     1     1       1     1     1     1   space   0xFF      36
*+                        0     1     0     0       0     0     0     1      a    0x41      37
*+                        0     0     0     0       1     0     0     1      e    0x09      38
*+                        0     0     0     0       0     0     1     1     /e    0x03      39
*+                        0     0     0     1       0     0     0     1      @    0x11      40
*+                        0     1     0     1       0     1     0     1      ñ    0x55      41
*+                        1     0     0     1       1     0     0     1      [    0x99      42
*+                        0     0     0     0       1     0     0     1      ]    0xC3      43
*+                        1     0     1     0       0     0     0     1      U    0xA1      44
*+                        1     0     0     0       0     1     0     1     /U    0x85      45
*+                        1     1     0     1       1     1     1     1     /_    0xDF      46
*+                        0     1     1     1       1     1     1     1      -    0x7F      47
*+                        1     1     1     1       1     0     1     1      _    0xFB      48
*+                        1     1     0     1       1     0     1     1    _/_    0xDB      49
*+                        0     1     1     1       1     0     1     1     /=    0x7B      50
*+                        0     1     0     1       1     1     1     1      =    0x5F      51
*+                        0     1     0     1       1     0     1     1     ==    0x5B      52
*+                        0     0     0     0       1     1     1     1      °    0x0F      53
*+                        1     1     1     1       0     0     0     1    + c    0xF1      38
*+                        1     1     1     1       0     1     0     0    +/c    0xF4      39
*+                        1     0     1     0       0     1     1     1      c    0xA7      40
*+                        1     0     0     1       0     1     1     1     /c    0x97      41
*+                        1     1     1     1       0     0     1     0    + u    0xF2      42
*+                        1     1     1     1       1     0     0     0    + n    0xF8      43
*+                        1     0     1     0       1     0     0     1      [    0xA9      44
*+                        1     0     0     1       1     1     0     0      ]    0x9C      45
*+                        1     1     1     1       0     0     0     0      °    0xF0      46
*+                        1     1     1     1       1     1     0     0      ¬    0xFC      47
*+                        1     1     1     1       0     1     1     0    + >    0xF6      48
*+                        1     1     1     0       0     1     1     1     ^     0xE7      49
*+                        1     0     1     0       1     1     1     1    / <    0xAF      50
*+                        1     0     0     1       1     1     1     1    / v    0x9F      51
*+                        1     1     0     1       0     1     1     1      >    0xD7      52
*+                        1     1     1     1       0     0     1     1      v    0xF3      53
*+                        1     1     1     1       1     0     0     1      <    0xF9      54
*+                        1     1     1     1       1     1     0     1    / _    0xBF      55
*+                        1     1     1     1       0     1     1     1      -    0xF7      56
*+                        1     0     1     1       1     1     1     1      _    0xFD      57
*+                        1     1     1     1       0     1     0     1      =    0xF5      58
*+                        1     0     1     1       0     1     1     1    / =    0xB7      59
*+                        1     0     1     1       0     1     0     1     ==    0xB5      60
*+                        1     0     1     1       1     1     0     1     _¬    0xBD      61
*+                        1     1     0     0       1     1     1     1     ii    0xCF      62
*+                        1     1     1     1       1     0     1     0      #    0xFA      63
*+                        1     0     0     1       1     1     1     0      j    0x9E      64
*+                        1     1     0     1       1     1     0     0     /j    0xDC      65
*+                        1     1     1     0       1     0     0     1    - j    0xE9      66
*+                        1     0     1     0       1     0     1     1    -/j    0xAB      67
*+                        1     0     0     0       1     1     1     0    - J    0x8E      68
*+                        1     1     0     1       1     0     0     0    -/J    0xD8      69
*+                        1     1     1     0       1     0     1     1     |     0xEB      70
*+                        1     1     0     0       1     0     1     0     ||    0xCA      71
*+                        1     1     0     1       0     1     1     0      +    0xD6      72
*+                        1     1     1     0       0     0     1     1     /+    0xE3      73
*+                        1     0     0     1       1     0     1     1  espacio  0xFF      74
*+
*+ Nota: Cada dígito se activa al hacer la señal A correspondiente en "alto"
*+       y enviar las señales de los segmentos que se desean encender en "bajo" 
*+
*+----------------------------------------------------------------------------*/
/*..............................................................................
:
:               TECLADO MATRICIAL DE 4X4 DE MEMBRANA
:
:                  C1       C2        C3        C4
:                  |         |         |        |
:                  |         |         |        |
:                  | 1       |  2      | 3      | F1
:            R1 __/ ________/ ________/ ________/
:                  |         |         |         |
:                  | 4       |  5      | 6      | F2
:            R2 __/ ________/ ________/ ________/
:                  |         |         |         |
:                  | 7       |  8      | 9      | F3
:            R3 __/ ________/ ________/ ________/
:                  |         |         |         |
:                  | *       |  0      | #      | F4
:            R4 __/ ________/ ________/ ________/
:
:
:            Función: REN1 REN2 REN3 REN4 COL1 COL2 COL3 COL4
:                Pin:  1    2    3    4    5    6    7    8
................................................................................
:
:             TECLADO MATRICIAL DE 4X4 DE PUSH BOTTONS
:
:                  C1       C2        C3        C4
:                  |         |         |        |
:                  |         |         |        |
:                  | S1      |  S2     | S3     | S4
:            R1 __/ ________/ ________/ ________/
:                  |         |         |         |
:                  | S5      |  S6     | S7      | S8
:            R2 __/ ________/ ________/ ________/
:                  |         |         |         |
:                  | S9      |  S10    | S11    | S12
:            R3 __/ ________/ ________/ ________/
:                  |         |         |         |
:                  | S13     |  S14    | S15     | S16
:            R4 __/ ________/ ________/ ________/
:
:
:            Función: COL1 COL2 COL3 REN4 REN1 REN2 REN3 REN4
:                Pin:  1    2    3    4    5    6    7    8
**+----------------------------------------------------------------------------*
*+
*+   Powered by
*+
*+          T H E     A N T U L I U ' S   T E A M   R&D  Unltd 
*+
*+  Research, Development, Systems, Equipment, Support & Spare Parts.
*+  (C) Copyright 1989-2019, All Rights Reserved            
*+
*+  Welcome to The Beaners Proyect Community!                   
*+----------------------------------------------------------------------------*/
/* END Documentation */
/* END Mbed */ 