/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Hola_Mundo
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         This module contains user's application code.
**   Componentes     : Serial, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocidades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Ejemplpo del Hola Mundo
**                    27/09/2010 
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/
#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO

/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/

// *****    Host PC Terminal Communication channels
Serial      terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial      terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
uint32_t Baud_Rate = 115200;          // Velocidad de Transmisión (Bauds)

/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void);   // Función que inicializa la Tarjeta
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                   // Inicialización de variables, puertos e interrupciones
 confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
 Setup(); 
 terminal.printf ("ESCUELA SUPERIOR DE INGENIERIA MECANICA Y ELECTRICA\n\r");
 printf ("\vHola Mundo!\r");
 printf ("\n\nPresiona cualquier tecla para continuar...");    
 char opcion = terminal.getc();
    
 while (TRUE)                // El Lazo del Programa principal está aquí !!!
 {
    printf("\n\r\v\tHola ESIME - IPN!!!\n\r\v");
    printf ("\033[1;31mEste es un texto rojo.\n\r\033[0m"); 
    printf ("\033[1;32mEste es un texto verde.\n\r\033[0m");
    printf ("\033[1;34mEste es un texto azul.\n\r\033[0m");     
    printf ("\v\tHecho en \033[1;32mMe\033[0mxi\033[1;31mco.\n\r\v\v\033[0m");
    printf ("\n\r Pulse cualquier tecla para continuar!\r");   
    opcion = terminal.getc();
    terminal.putc(opcion);
    terminal.printf("\n\a\f");
 }
}
/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.
  terminal.printf("System is Wake Up!.\n\r"); 
}                

/* END routines */ 
 
/* END program */                

/*+-----------------------------------------------------------------------------  
*+ La documentación va aquí!:
+-------------------------------------------------------------------------------
|                SECUENCIAS DE ESCAPE PARA LA TERMINAL SERIAL
|
| SECUENCIA         VALOR                       DESCRIPCIÓN
|
|   \n              Nueva línea (new line). El cursor pasa a la primera posición
|                                           de la línea siguiente 
|   \r              Retorno de carro (carriage return). El cursor pasa a la 
|                                           primera posición de la línea donde 
|                                           nos encontremos.
|   \t              Tabulador (tab). El cursor pasa a la siguiente posición de 
|                                           tabulación.
|   \a              Alerta (bell). Crea un aviso bien de forma visible o bien 
|                                           mediante sonido.
|   \b              Espacio atrás (backspace). Hace retroceder el cursor una 
|                                           posición a la izquierda.
|   \f              Alimentación de página (form feed). Crea una nueva página.
|   \v              Tabulación vertical (vertical tab).
|   \0              Caracter Nulo (null).
|   \'              Apóstrofo o comilla simple.
|   \”              Muestra la comilla doble.
|   \?              Muestra un interrogante.
|   \\              Muestra la barra invertida.
|   \número_octal   Muestra el carácter ASCII correspondiente según el número 
|                                           octal que se haya especificado.
|   \xnúmero_hexadecimal    Muestra el carácter ASCII correspondiente según el 
|                                           número hexadecimal que se haya 
|                                           especificado.
|   \unnnn          Muestra Caracter en código unicode.
|   \unnnnnnnn      Muestra varios caracteres en código unicode.
|
|   Tambien consultar:
| https://www.enmimaquinafunciona.com/pregunta/170760/secuencias-de-escape-terminales-en-la-pantalla-gnu
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-   Utilizando printf y las secuencias de escape, crear una Carátula de 
|       prentación con los datos personales y escolares. 
|
+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/

/* END documentation */ 

/* END Mbed */