#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
 
Serial pc(USBTX, USBRX); 
Ticker t;
InterruptIn risingEdge(p8); //halleffect sensor
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
AnalogIn batt(p19);

 
volatile int count = 0.0;
volatile float vel = 0.0;
float pbatt = 0.0;
 
void pulses() //hall effect triggers
{
    count++;
}
void halleffect() //calculates velocity
{
    float temp = count;
    count = 0;
    temp = temp/4; // four magnets in trigger - gives rps
    vel = temp * 3.14159 * 0.035 * 2 *60 * 60 * 0.000621371 ; // radius of .035m  
}

void display(void const *argument) //update battery voltage display and velocity
{
    while(1)
    {
    float battAdj = float(batt * 3.3 * 3.968);
    uLCD.color(WHITE);
    uLCD.locate(2,2);
    uLCD.printf("%3.1f", vel*0.67);
    uLCD.locate(2,3);
    uLCD.printf("MPH");
    //if (battAdj == pbatt) break;
    if (battAdj >= 11) {
        uLCD.filled_rectangle(6,99,29,16,GREEN);
        pbatt = battAdj;
    }
    else if ((battAdj >= 9)&&(battAdj < 11)) {
        uLCD.filled_rectangle(6,99,29,16,WHITE);
        uLCD.filled_rectangle(6,99,29,45,(GREEN+RED));
        pbatt = battAdj;
    }
    else if (battAdj < 9) {
        uLCD.filled_rectangle(6,99,29,16,WHITE);
        uLCD.filled_rectangle(6,99,29,70,RED);
        pbatt = battAdj;
    }    
    Thread::wait(1000);
    }

}
 
int main() 
{
    uLCD.cls();
    uLCD.baudrate(3000000); //jack up baud rate to max
    uLCD.background_color(BLACK);
    uLCD.cls();
    uLCD.text_width(3.5); 
    uLCD.text_height(3.5);
    uLCD.filled_rectangle(5,100,30,15,WHITE);
    uLCD.filled_rectangle(12,15,22,10,WHITE);
    risingEdge.rise(&pulses); //interrupt routine
    t.attach(&halleffect, 1.0); //calculate velocity every second
    Thread displaythread(display); //update display
    while(1) {
    
    }
}