#include "mbed.h"
#include "rtos.h"
#include "wave_player.h"
#include "SDFileSystem.h"
#include "uLCD_4DGL.h"
RawSerial Blue(p28,p27);
Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
PwmOut led_red(p21);
PwmOut led_green(p22);
PwmOut led_blue(p23);
SDFileSystem sd(p5, p6, p7, p8, "sd");
uLCD_4DGL uLCD(p9,p10,p11);

float x = 0.0;
bool gfxstatus = false;
bool textstatus = false;
int soundmode = 0;
int gfxmode = 0;
int rgbmode = 0;

Mutex stdio_mutex;
Mutex sound_mutex;
Mutex sound_mutex_2;
Mutex blue_mutex;
AnalogOut DACout(p18);
wave_player waver(&DACout);

Thread t1;
Thread t2;
Thread t3;
Thread t4;

FILE *wave_file;

#include "cylonbyc.h"
Ticker sampletick;
#define sample_freq 11025.0
//get and set the frequency from wav conversion tool GUI
int i=0;

//interrupt routine to play next audio sample from array in flash
void audio_sample ()
{
    sound_mutex_2.lock();
    DACout.write_u16(sound_data[i]);
    i++;
    if (i>= NUM_ELEMENTS) {
        i = 0;
        sampletick.detach();
    }
    sound_mutex_2.unlock();
}

//global variables for main and interrupt routine
volatile bool button_ready = 0;
volatile int  bnum = 0;
volatile int  bhit  ;
//state used to remember previous characters read in a button message
enum statetype {start = 0, got_exclm, got_B, got_num, got_hit};
statetype state = start;

//Interrupt routine to parse message with one new character per serial RX interrupt
void parse_message()
{

    led2 = !led2;

    while(Blue.readable()) {
        blue_mutex.lock();
        switch (state) {
            case start:
                if (Blue.getc()=='!') {
                    state = got_exclm;
                } else state = start;
                break;
            case got_exclm:
                if (Blue.getc() == 'B') {
                    state = got_B;
                } else state = start;
                break;
            case got_B:
                bnum = Blue.getc();
                state = got_num;
                break;
            case got_num:
                bhit = Blue.getc();
                state = got_hit;
                break;
            case got_hit:
                if (Blue.getc() == char(~('!' + ' B' + bnum + bhit))) button_ready = 1;
                state = start;
                break;
            default:
                Blue.getc();
                state = start;
        }
        blue_mutex.unlock();
    }

    //pc.printf("Left interrupt\n");

}

inline float random_number()
{
    return (rand()/(float(RAND_MAX)));
}

// mode = 0 shows alternating orbs and SONIC SCREWDRIVER
// mode = 1 shows a rectangle and TARDIS APPROACHING
void LCD_write(int user, int LCD_mode)
{
    stdio_mutex.lock();

    if(user == 0) {
        if(LCD_mode == 0) {
            uLCD.filled_rectangle(60,12,68,40, WHITE);
            uLCD.filled_rectangle(56,12,72,16, WHITE);
            uLCD.filled_rectangle(48,16,80,64, WHITE);
            uLCD.filled_rectangle(56,24,60,32, WHITE);
            uLCD.filled_rectangle(68,24,72,32, WHITE);
            if(gfxstatus) {
                uLCD.filled_circle(96, 32, 10, WHITE);
                uLCD.filled_circle(32, 32, 10, BLUE);
            } else {
                uLCD.filled_circle(32, 32, 10, WHITE);
                uLCD.filled_circle(96, 32, 10, BLUE);
            }
        } else if (LCD_mode == 1) {
            uLCD.filled_circle(96, 32, 10, WHITE);
            uLCD.filled_circle(32, 32, 10, WHITE);
            if(gfxstatus) {
                uLCD.filled_circle(64,58,10,WHITE);
                uLCD.filled_rectangle(60,12,68,40, WHITE);
                uLCD.filled_rectangle(56,12,72,16, BLUE);
                uLCD.filled_rectangle(48,16,80,64, BLUE);
                uLCD.filled_rectangle(56,24,60,32, WHITE);
                uLCD.filled_rectangle(68,24,72,32, WHITE);
            } else {
                uLCD.filled_rectangle(56,12,72,16, WHITE);
                uLCD.filled_rectangle(48,16,80,64, WHITE);
                uLCD.filled_rectangle(60,12,68,40, BLUE);
                uLCD.filled_circle(64,58,10,BLUE);
            }
        }
    } else if (user == 1) {
        if(LCD_mode == 0) {
            if(textstatus) {
                uLCD.locate(6, 9);      // Move cursor
                uLCD.color(BLUE);
                uLCD.printf("SONIC");
                uLCD.locate(4,13);      // Move cursor
                uLCD.color(WHITE);
                uLCD.printf("SCREWDRIVER");

            } else {
                uLCD.locate(6, 9);      // Move cursor
                uLCD.color(WHITE);
                uLCD.printf("SONIC");
                uLCD.locate(4,13);      // Move cursor
                uLCD.color(BLUE);
                uLCD.printf("SCREWDRIVER");
            }
        } else if(LCD_mode == 1) {
            if(textstatus) {
                uLCD.locate(6, 9);      // Move cursor
                uLCD.color(BLUE);
                uLCD.printf("TARDIS");
                uLCD.locate(4,13);      // Move cursor
                uLCD.color(WHITE);
                uLCD.printf("APPROACHING");

            } else {
                uLCD.locate(6, 9);      // Move cursor
                uLCD.color(WHITE);
                uLCD.printf("TARDIS");
                uLCD.locate(4,13);      // Move cursor
                uLCD.color(BLUE);
                uLCD.printf("APPROACHING");
            }
        }

    }
    stdio_mutex.unlock();
}

void LCD_thread_1()   // Displays two alternating circles on the LCD
{
    while (true) {
        //led1 = !led1;
        gfxstatus = !gfxstatus;
        LCD_write(0,gfxmode);
        Thread::wait(1000);
    }
}

void LCD_thread_2()   // Displays "Please seek shelter" on the LCD
{
    while (true) {
        //led2 = !led2;
        textstatus = !textstatus;
        LCD_write(1,gfxmode);
        Thread::wait(1000);
    }
}

// mode = 0 gives Sonic Screwdriver (welding) lighting
// mode = 1 gives Tardis (warmup/cooldown) lighting
void RGB_write(int RGB_mode)
{

    if(RGB_mode == 0) {
        for(int j = 0; j < 80; j++) {
            //get a new random number for PWM
            x = random_number();
            //add some exponential brightness scaling
            //for more of a fast flash effect
            led_red = x*x*x;
            led_green = x*x*x;
            led_blue = x*x*x;
            Thread::wait(20);
        }
        led_red = 0;
        led_green = 0;
        led_blue = 0;
    } else if(RGB_mode == 1) {
        //LED warm up effect using PWM
        for(int j=0; j<25; j++) {
            //led_red = i/25.0;
            led_green = j/25.0;
            led_blue = j/25.0;
            Thread::wait(20);
        }
        //LED at full brightness level
        //led_red = 1.0;
        led_blue = 1.0;
        led_green = 1.0;
        Thread::wait(700);
        //LED cool down effect using PWM
        for(int j=25; j>0; j--) {
            //led_red = i/25.0;
            led_green = j/25.0;
            led_blue = j/25.0;
            Thread::wait(20);
        }
        //LED off
        led_red = 0.0;
        led_green = 0.0;
        led_blue = 0.0;
    }
}
void RGB_thread()
{
    while (true) {
        //led3 = !led3;
        RGB_write(rgbmode);
        Thread::wait(1000);
    }
}
void Sound_write(int snd_mode)
{
    stdio_mutex.lock();

    if(soundmode == 0) {

        //sampletick.attach(&audio_sample, 1.0 / sample_freq);

        wave_file=fopen("/sd/sonic.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
    } else if(soundmode == 1) {

        wave_file=fopen("/sd/tardis.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
    }
    stdio_mutex.unlock();
}

void Sound_thread()
{
    while(true) {
        led1 = !led1;
        Sound_write(soundmode);
        Thread::wait(1310);
    }
}


int main()
{
    uLCD.background_color(WHITE);
    uLCD.cls();
    uLCD.textbackground_color(WHITE);

    t1.start(LCD_thread_1);
    t2.start(LCD_thread_2);
    t3.start(RGB_thread);
    t4.start(Sound_thread);

    //pc.printf("hi\n");
    Blue.attach(&parse_message,Serial::RxIrq);
    //pc.printf("bye\n");



    while (true) {

        if(button_ready && (bnum=='5')) { // button 4 changed
            pc.printf("Sound Mode Mode = 0\n");
            soundmode = 0;
            button_ready = 0; //reset flag after reading button message
        } else if(button_ready && (bnum=='6')) { // button 4 changed
            pc.printf("Sound Mode = 1\n");
            soundmode = 1;
            button_ready = 0; //reset flag after reading button message
        } else if(button_ready && (bnum=='1')) { // button 4 changed
            pc.printf("Graphics Mode = 0\n");
            gfxmode = 0;
            button_ready = 0; //reset flag after reading button message
        } else if(button_ready && (bnum=='2')) { // button 4 changed
            pc.printf("Graphics Mode = 1\n");
            gfxmode = 1;
            button_ready = 0; //reset flag after reading button message
        } else if(button_ready && (bnum=='3')) { // button 4 changed
            pc.printf("Light Mode = 0\n");
            rgbmode = 0;
            button_ready = 0; //reset flag after reading button message
        } else if(button_ready && (bnum=='4')) { // button 4 changed
            pc.printf("Light Mode = 1\n");
            rgbmode = 1;
            button_ready = 0; //reset flag after reading button message
        }


        Thread::wait(50);
    }
}
