#include "mbed.h"
#include "Course.h"
#include <string>
#include <vector>
#include "uLCD_4DGL.h"
#include "SDFileSystem.h"

SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
vector<Course> courseVec;
vector<Course> readingCourseVec;
int addCourseToVector(vector<Course>& cVec, Course newCourse);
void writeClassFile(vector<Course>& cVec), readClassFile(vector<Course>& cVec);

int main() {
    Course course1("COC", 6, 5, "PM");
    Course course2("CLH", 8, 25, "AM");
    Course course3("VAN", 8, 15, "PM");
    Course course4("KLS", 8, 05, "PM");
    Course course5("VAN", 8, 05, "PM");
    

    int test = 0;    
    test = addCourseToVector(courseVec, course1);
    test = addCourseToVector(courseVec, course2);
    test = addCourseToVector(courseVec, course3);
    test = addCourseToVector(courseVec, course4);
    test = addCourseToVector(courseVec, course5);
    if (test == 0)
        uLCD.printf("uh oh!");

    mkdir("/sd/classdir", 0777);

    writeClassFile(courseVec);
    readClassFile(readingCourseVec);
    
    uLCD.cls();
    uLCD.locate(0, 1);
    uLCD.printf("Display readingCourseVec..");
    for (int i = 0; i < readingCourseVec.size(); i++) {
        uLCD.locate(0, i+2);
        uLCD.printf("%s", readingCourseVec[i].getDisplayString());
    }

}

int addCourseToVector(vector<Course>& cVec, Course newCourse) {
    int numIterations = 0;

    if (cVec.size() == 0) {
        cVec.push_back(newCourse);
        return 1;
    }

    for (int i = 0; i < cVec.size(); i++) {
        numIterations++;
        if (cVec[i].getAMPM_toInt() < newCourse.getAMPM_toInt())
            continue;
        else if (newCourse.getAMPM_toInt() < cVec[i].getAMPM_toInt()) {
            cVec.insert(cVec.begin()+i, newCourse);
            return 1;
        }
        else if (cVec[i].getAMPM_toInt() == newCourse.getAMPM_toInt()) {
            if (cVec[i].getHour_forCompare() < newCourse.getHour_forCompare())
                continue;
            else if (newCourse.getHour_forCompare() < cVec[i].getHour_forCompare()) {
                cVec.insert(cVec.begin()+i, newCourse);
                return 1;
            }
            else if (cVec[i].getHour_forCompare() == newCourse.getHour_forCompare()) {
                if (cVec[i].getMinute() < newCourse.getMinute())
                    continue;
                else if (newCourse.getMinute() < cVec[i].getMinute()) {
                    cVec.insert(cVec.begin()+i, newCourse);
                    return 1;
                }
                else if (cVec[i].getMinute() == newCourse.getMinute()) {
                    uLCD.cls();
                    uLCD.locate(0,0);
                    uLCD.printf("Can not add coure!");
                    uLCD.locate(0,1);
                    uLCD.printf("Course already at");
                    uLCD.locate(0,2);
                    uLCD.printf("%i:%s%s", newCourse.getHour(), newCourse.getMinute_toString(), newCourse.getAMPM());
                    wait(5);
                    return 0;
                }
            }
        }
    }

    if (numIterations == cVec.size()) {
        cVec.push_back(newCourse);
        return 1;
    }

    return 0;
}

void writeClassFile(vector<Course>& cVec) {
    FILE *writeClass = fopen("/sd/classdir/classes.txt", "w");
    if (writeClass != NULL) {
        string line = "";
        for (int i = 0; i < cVec.size(); i++) {
            if (i != (cVec.size() - 1))
                line = cVec[i].getFileString() + "\n";
            else
                line = cVec[i].getFileString();
            fprintf(writeClass, line.c_str());
        }
        fclose(writeClass);
    }
}

void readClassFile(vector<Course>& cVec) {
    cVec.clear();

    FILE *readFp = fopen("/sd/classdir/classes.txt", "r");
    char line[15];
    char buildingBuf[4];
    char hourBuf[3];
    int hour;
    char minuteBuf[3];
    int minute;
    char ampmBuf[3];
    uLCD.cls();
    uLCD.locate(0, 1);
    uLCD.printf("Reading class file...");
    
    memset(buildingBuf, 0, sizeof(buildingBuf));
    memset(hourBuf, 0, sizeof(hourBuf));
    memset(minuteBuf, 0, sizeof(minuteBuf));
    memset(ampmBuf, 0, sizeof(ampmBuf));
    memset(line, 0, sizeof(line));

    if (readFp == NULL)
        return;
    else {
        while (!feof(readFp)) {
            fgets(line, 15, readFp);
            if(line[8] == NULL)
                continue;
            memcpy(buildingBuf, line, 3);
            memcpy(hourBuf, &line[4], 2);
            memcpy(minuteBuf, &line[7], 2);
            memcpy(ampmBuf, &line[10], 2);

            string building = buildingBuf;
            hour = atoi(hourBuf);
            minute = atoi(minuteBuf);
            string ampm = ampmBuf;

            Course temp(building, hour, minute, ampm);
            cVec.push_back(temp);
        }
    }
    fclose(readFp);
    return;
}