#include "mbed.h"
#include <string>
#include <map>

class Course {
    public:
        Course(string pAbbreviatedName, int pHour, int pMinute, string ampm);
        string getFullName();
        string getAbbreviatedName();
        int getHour();
        int getHour_forCompare();
        int getHour_inMilitaryTime();
        string getMinute_toString();
        int getMinute();
        string getAMPM();
        int getAMPM_toInt();
        float getLat();
        float getLong();
        string getFileString();
        string getDisplayString();
    private:
        string abbreviatedName;
        string fullName;
        int hour;
        int minute;
        float latitude;
        float longitude;
        static map<string, float> buildingLAT;
        static map<string, float> buildingLONG;
        static map<string, string> buildingNames;
        string ampm;
        void createBuildingMaps();
};
