#include "Course.h"
//#include <string>

map<string, float> create_lat_map() {
    map<string, float> m;
    m["CLH"] = 33.774801;
    m["COC"] = 33.777442;
    m["HWY"] = 33.777480;
    m["ICR"] = 33.775439;
    m["KLS"] = 33.777262;
    m["SCH"] = 33.776508;
    m["SKI"] = 33.773611;
    m["VAN"] = 33.775991;
    return m;
}

map<string, float> create_long_map() {
    map<string, float> m;
    m["CLH"] = -84.396389;
    m["COC"] = -84.397259;
    m["HWY"] = -84.398582;
    m["ICR"] = -84.401250;
    m["KLS"] = -84.396003;
    m["SCH"] = -84.388081;
    m["SKI"] = -84.395897;
    m["VAN"] = -84.397128;
    return m;
}

map<string, string> create_names_map() {
    map<string, string> m;
    m["CLH"] = "Clough";
    m["COC"] = "CoC";
    m["HWY"] = "Howey";
    m["ICR"] = "IC";
    m["KLS"] = "Klaus";
    m["SCH"] = "CoB";
    m["SKI"] = "Skiles";
    m["VAN"] = "VanLeer";
    return m;
}

map<string, float> Course::buildingLAT = create_lat_map();
map<string, float> Course::buildingLONG = create_long_map();
map<string, string> Course::buildingNames = create_names_map();

Course :: Course(string pAbbreviatedName, int pHour, int pMinute, string pAMPM) {
    
    /*if (pAbbreviatedName == "CLH") {
        fullName = "Clough";
        latitude = 33.774801;
        longitude = -84.396389;
    } 
    else if (pAbbreviatedName == "COC") {
        fullName = "CoC";
        latitude = 33.777442;
        longitude = -84.397259;
    }
    else if (pAbbreviatedName == "KLS") {
        fullName = "Klaus";
        latitude = 33.777262;
        longitude = -84.396003;
    }
    else if (pAbbreviatedName == "VAN") {
        fullName = "VanLeer";
        latitude = 33.776000;
        longitude = -84.397132;
    }*/
    
    //createBuildingMaps();
    abbreviatedName = pAbbreviatedName;
    fullName = buildingNames[pAbbreviatedName];
    latitude = buildingLAT[pAbbreviatedName];
    longitude = buildingLONG[pAbbreviatedName];
    ampm = pAMPM;
    hour = pHour;
    minute = pMinute;
}

string Course :: getAbbreviatedName() {
    return abbreviatedName;
}

string Course :: getFullName() {
    return fullName;
}

int Course :: getHour() {
    return hour;
}

int Course :: getHour_forCompare() {
    if (hour == 12)
        return 0;
    else
        return hour;
}

int Course :: getHour_inMilitaryTime() {
    if (this->getAMPM() == "PM")
        return hour + 12;
    else
        return hour;
    
}

string Course :: getMinute_toString() {
    char minuteBuf[3];
    sprintf(minuteBuf, "%i", minute);
    minuteBuf[2] = '\0';

    string minuteStr = minuteBuf;
    
    if (this->getMinute() < 10)
        minuteStr = "0" + minuteStr;
        
    return minuteStr;
}

int Course :: getMinute() {
    return minute;
}

float Course :: getLat() {
    return latitude;
}

float Course :: getLong() {
    return longitude;
}

string Course :: getAMPM() {
    return ampm;
}

int Course :: getAMPM_toInt() {
    if (ampm == "AM")
        return 0;
    else
        return 1;
}

string Course :: getFileString() {
    string output = "";
    char hourBuf[3];
    char minuteBuf[3];
    sprintf(hourBuf, "%i", hour);
    sprintf(minuteBuf, "%i", minute);

    string hourStr = hourBuf;
    string minuteStr = minuteBuf;
    
    if (this->getHour() < 10)
        hourStr = "0" + hourStr;

    if (this->getMinute() < 10)
        minuteStr = "0" + minuteStr;

    output = this->getAbbreviatedName() + "," + hourStr + "," + 
        minuteStr + "," + this->getAMPM();
    return output;
}

string Course :: getDisplayString() {
    string output = "";
    char hourBuf[3];
    char minuteBuf[3];
    sprintf(hourBuf, "%i", hour);
    sprintf(minuteBuf, "%i", minute);

    string hourStr = hourBuf;
    string minuteStr = minuteBuf;

    if (this->getMinute() < 10) {
        minuteStr = "0" + minuteStr;
    }

    output = this->getFullName() + " at " + hourStr + ":" + minuteStr + "" + this->getAMPM();
    return output;
}
/*
void Course :: createBuildingMaps() {
    buildingLAT["ALN"] = 33.776078; buildingLONG["ALN"] = -84.398785;
    buildingNames["ALN"] = "Allen";
    buildingLAT["BUR"] = 33.775660; buildingLONG["BUR"] = -84.398222;
    buildingNames["BUR"] = "Burger-Henry";
    buildingLAT["CAD"] = 33.776631; buildingLONG["CAD"] = -84.396969;
    buildingNames["CAD"] = "Caddell";
    buildingLAT["CHR"] = 33.777959; buildingLONG["CHR"] = -84.397051;
    buildingNames["CHR"] = "Cherry";
    buildingLAT["CLH"] = 33.774801; buildingLONG["CLH"] = -84.396376;
    buildingNames["CLH"] = "Clough";
    buildingLAT["COC"] = 33.777442; buildingLONG["COC"] = -84.397259;
    buildingNames["COC"] = "College of Computing";
    buildingLAT["COD"] = 33.776010; buildingLONG["COD"] = -84.395561;
    buildingNames["COD"] = "College of Design";
    buildingLAT["COO"] = 33.772724; buildingLONG["COO"] = -84.395770;
    buildingNames["COO"] = "Coon Building";
    buildingLAT["CCH"] = 33.778216; buildingLONG["CCH"] = -84.404506;
    buildingNames["CCH"] = "Couch";
    buildingLAT["FOR"] = 33.778843; buildingLONG["FOR"] = -84.395849;
    buildingNames["FOR"] = "Ford";
    buildingLAT["GUG"] = 33.771628; buildingLONG["GUG"] = -84.395775;
    buildingNames["GUG"] = "Guggenheim";
    buildingLAT["HWY"] = 33.777498; buildingLONG["HWY"] = -84.398582;
    buildingNames["HWY"] = "Howey";
    buildingLAT["ICR"] = 33.775448; buildingLONG["ICR"] = -84.401261;
    buildingNames["ICR"] = "Instructional Center";
    buildingLAT["IVN"] = 33.774001; buildingLONG["IVN"] = -84.404259;
    buildingNames["IVN"] = "Ivan Allen";
    buildingLAT["KLS"] = 33.777244; buildingLONG["KLS"] = -84.396256;
    buildingNames["KLS"] = "Klaus";
    buildingLAT["LVE"] = 33.776730; buildingLONG["LVE"] = -84.401807;
    buildingNames["LVE"] = "Love";
    buildingLAT["MCS"] = 33.779068; buildingLONG["MCS"] = -84.398651;
    buildingNames["MCS"] = "Marcus Nanotech";
    buildingLAT["MSN"] = 33.776685; buildingLONG["MSN"] = -84.398896;
    buildingNames["MSN"] = "Mason";
    buildingLAT["PET"] = 33.778946; buildingLONG["PET"] = -84.397158;
    buildingNames["PET"] = "Petit";
    buildingLAT["SCH"] = 33.776562; buildingLONG["SCH"] = -84.388060;
    buildingNames["SCH"] = "Scheller";
    buildingLAT["SKI"] = 33.773603; buildingLONG["SKI"] = -84.395897;
    buildingNames["SKI"] = "Skiles";
    buildingLAT["VAN"] = 33.776000; buildingLONG["VAN"] = -84.397132;
    buildingNames["VAN"] = "Van Leer";
}*/