#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "spdomparser.hpp"
#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"
//#include "NokiaLCD.h"
#include "uLCD_4DGL.h"
#include <string>
// Internet of Things weather display example: LCD displays LA current weather via internet Google API
// Adapted for LCD from http://mbed.org/users/hlipka/programs/spxmltest_weather/lif782

//NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
uLCD_4DGL lcd(p28,p27,p29);
EthernetNetIf eth;
HTTPClient http;
HTTPResult result;
bool completed = false;
void request_callback(HTTPResult r) {
    result = r;
    completed = true;
}

void parseWeather(SP_XmlElementNode *node, string loc) {
    //extracts current weather XML data fields for LCD
    SP_XmlHandle handle(node);
    SP_XmlElementNode * condition = handle.getChild( "item" ).getChild("yweather:condition").toElement();
    lcd.cls();
    // Print the name of the city
    lcd.locate(0,2);
    lcd.printf("%s:", loc);
    //Print the weather conditions
    lcd.locate(0,3);
    lcd.printf("%s",condition->getAttrValue("text"));
    //Print the termperature (in degrees Celcius)
    lcd.locate(0,4);
    lcd.printf("%sF",condition->getAttrValue("temp"));
    /*//Print the date and time
    lcd.locate(0,5);
    lcd.printf("%s",condition->getAttrValue("date"));
    */
}

int main() {
    // the eth and HTTP code has be taken directly from the HTTPStream documentation page
    // see http://mbed.org/cookbook/HTTP-Client-Data-Containers
    lcd.cls();
    
    lcd.locate(0,2);
    lcd.printf("net setup");
    lcd.locate(0,3);
    EthernetErr ethErr = eth.setup(60000);
    if (ethErr) {
        lcd.printf("Error in setup");
        return -1;
    }
    lcd.printf("net ok");

    SP_XmlDomParser parser;
    HTTPStream stream;

    char BigBuf[512 + 1] = {0};
    stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
    //Yahoo! weather API for selected city - get XML document for parsing
    HTTPResult r = http.get("https://query.yahooapis.com/v1/public/yql?q=select%20item.condition%20from%20weather.forecast%20where%20woeid%20in%20%28select%20woeid%20from%20geo.places%281%29%20where%20text%3D%22atlanta%2C%20ga%22%29&amp", &stream, request_callback);
    while (!completed) {
        Net::poll(); //Polls the Networking stack
        if (stream.readable()) {
            BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
            parser.append( BigBuf, strlen(BigBuf)); // stream current buffer data to the XML parser
            stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
        }
    }
    lcd.cls();
    lcd.locate(0,2);
    if (result == HTTP_OK) {
        lcd.printf(" Read complete");
    } else {
        lcd. printf(" Error %d", result);
        return -1;
    }

    SP_XmlHandle rootHandle( parser.getDocument()->getRootElement() );
    SP_XmlElementNode * child2 = rootHandle.getChild( "results" ).getChild( "channel" )
                                 .toElement();
    
    //lcd.printf(BigBuf);
    
    if ( child2 ) {
        parseWeather(child2, "Atlanta"); //parses XML "current-conditions" info
    }
    
    if ( NULL != parser.getError() ) {
        lcd.printf( "\n error: %s\n", parser.getError() );
    }
}