#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "spdomparser.hpp"
#include "spxmlnode.hpp"
#include "spxmlhandle.hpp"
//#include "NokiaLCD.h"
#include "uLCD_4DGL.h"
#include <string>
// Internet of Things weather display example: LCD displays LA current weather via internet Google API
// Adapted for LCD from http://mbed.org/users/hlipka/programs/spxmltest_weather/lif782

//NokiaLCD lcd(p5, p7, p8, p9, NokiaLCD::LCD6610); // mosi, sclk, cs, rst, type
uLCD_4DGL lcd(p28,p27,p29);
EthernetNetIf eth;
HTTPClient http;
HTTPResult result;
Serial other(p9, p10);
bool completed = false;
void request_callback(HTTPResult r)
{
    result = r;
    completed = true;
}

void parseWeather(SP_XmlElementNode *node, string loc)
{
    //extracts current weather XML data fields for LCD
    SP_XmlHandle handle(node);
    SP_XmlElementNode * condition = handle.getChild( "item" ).getChild("yweather:condition").toElement();
    // Print the name of the city
    lcd.locate(0,1);
    lcd.printf("%s:", loc);
    //Print the weather conditions
    lcd.locate(0,2);
    lcd.printf("%s",condition->getAttrValue("text"));
    //Print the termperature (in degrees Celcius)
    lcd.locate(0,3);
    lcd.printf("%sF",condition->getAttrValue("temp"));
}
/*
void parseTraffic(SP_XmlElementNode *node)
{
    //extracts current weather XML data fields for LCD
    SP_XmlHandle handle(node);
    SP_XmlElementNode * condition = handle.getChild( "item" ).getChild("yweather:condition").toElement();
    //Print the weather conditions
    lcd.locate(0,5);
    lcd.printf("%s",condition->getAttrValue("realTime"));
}
*/
int weather()
{
    completed = false;
    SP_XmlDomParser parser;
    HTTPStream stream;

    char BigBuf[512 + 1] = {0};
    stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
    //Yahoo! weather API for selected city - get XML document for parsing
    HTTPResult r = http.get("https://query.yahooapis.com/v1/public/yql?q=select%20item.condition%20from%20weather.forecast%20where%20woeid%20in%20%28select%20woeid%20from%20geo.places%281%29%20where%20text%3D%22atlanta%2C%20ga%22%29&amp", &stream, request_callback);
    while (!completed) {
        Net::poll(); //Polls the Networking stack
        if (stream.readable()) {
            BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
            parser.append( BigBuf, strlen(BigBuf)); // stream current buffer data to the XML parser
            stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
        }
    }
    lcd.locate(0,6);
    if (result == HTTP_OK) {
        lcd.printf("Weather complete");
    } else {
        lcd. printf("Weather Error %d", result);
        return -1;
    }

    SP_XmlHandle rootHandle( parser.getDocument()->getRootElement() );
    SP_XmlElementNode * child2 = rootHandle.getChild( "results" ).getChild( "channel" )
                                 .toElement();

    //lcd.printf(BigBuf);

    if ( child2 ) {
        parseWeather(child2, "Atlanta"); //parses XML "current-conditions" info
    }

    if ( NULL != parser.getError() ) {
        lcd.printf( "\n error: %s\n", parser.getError() );
    }
    return 0;
}

int  traffic(char * traff_domain_name)
{
    completed = false;
    //char traff_domain_name[512] = "http://www.mapquestapi.com/traffic/v1/incidents?key=Vz3y4TYfSQa8b1iUJUv9N6meA9GAAhBH&callback=handleIncidentsResponse&boundingBox=33.977698,-84.662833,33.520957,-84.113516&filters=construction,incidents&inFormat=kvp&outFormat=xml";
    //char traff_domain_name[512] = "https://www.mapquestapi.com/directions/v2/route?key=ZoiBJSzSoqfdNiLD0Z9kZdw4uAN5QUQW&from=710%20Culworth%20Manor%2CAlpharetta%2CGA&to=855%20West%20Peachtree%20St%2CAtlanta%2CCGA&outFormat=xml";
    char *tstartXML = "<realTime>"; //RSS XML start title
    char *tendXML = "</realTime>";  //RSS XML end title
    char *tsptr;                    //Start Pointer
    char *teptr;                    //End Pointer
    char time[4] = "";
    int i=0,j=0;
    //time = "0000";
    HTTPStream stream;
    char BigBuf[2048 + 1] = {0};
    stream.readNext((byte*)BigBuf, 2048); //Point to buffer for the first read
    //Get web page with XML
    HTTPResult r = http.get(traff_domain_name, &stream, request_callback);
    while (!completed) {
        Net::poll();                // Polls the Networking stack
        if (stream.readable()) {    // check for end of file
            BigBuf[stream.readLen()] = 0; // Transform this buffer in a zero-terminated char* string
            tsptr = BigBuf;
            // displays titles on LCD  from XML "<title>....title text...</title>"
            do {
                tsptr = strstr(tsptr,tstartXML); // find <title> in string - NULL if not
                teptr = strstr(tsptr,tendXML);   // find <\title> in string - NULL if not
                if (tsptr!=NULL) tsptr = tsptr + strlen(tstartXML);// move to char after "<title>"
                if ((tsptr!=NULL)&&(teptr!=NULL)) {
                    i=0;
                    // loop to display lines on LCD
                    for (j=0; (j)<(strlen(tsptr)-strlen(teptr)); j=j+16) {
                        //lcd.locate(0,(2+(j/16)));
                        // loop to output a line on the LCD
                        for (i=0; ((i<16)&&(tsptr[i+j] != '<')); i++) {
                            //lcd.putc(tsptr[i+j]);
                            time[i+j] = tsptr[i+j];
                            other.putc(tsptr[i+j]);
                            wait(.25);
                        }
                    }
                    wait(5);
                    lcd.locate(0,5);
                }
            } while (tsptr!=NULL); // No more "<fullDesc>"s in BigBuf to display
            stream.readNext((byte*)BigBuf, 2048); //Buffer read, now we can put more data in it
        }
    }
    other.putc('^');
    //lcd.printf("%s", BigBuf);
    lcd.locate(0,7);
    if (result == HTTP_OK) {
        lcd.printf("Traffic complete");
    } else {
        lcd. printf("Traffic Error %d", result);
        return -1;
    }
    lcd.locate(0,4);
    lcd.printf("time:%s", time);
    return 0;
}

int main()
{
    lcd.printf("Reading\n");
    char in[512];
    char url[512];
    int i = 0;
    bool flag = false;
    while(!flag) {
        in[i] = other.getc();
        //other.putc(url[i]);
        flag = in[i] == '^';
        i++;
    }
    in[i-1] = NULL;
    sprintf(url, "%s&outFormat=xml", in);
    lcd.printf("url:%s\n", url);
    wait(5);
    lcd.cls();
    lcd.locate(0,5);
    lcd.printf("net setup");
    lcd.locate(0,5);
    EthernetErr ethErr = eth.setup(60000);
    if (ethErr) {
        lcd.printf("Error in setup");
        return -1;
    }
    lcd.printf("net ok     ");
    traffic(url);
    weather();
}