#include "mbed.h"
#include "Speaker.h"
#include "SDFileSystem.h"
#include "TextLCD.h"
#include "PinDetect.h"
#include "wave_player.h"
#include "uLCD_4DGL.h"
#include <vector>
#include <string>

//Pin setup
DigitalOut myled(LED1);
PinDetect pb1(p26);
PinDetect pb2(p25);
PinDetect pb3(p24);
PinDetect pb4(p23);
DigitalIn sdd(p12);
DigitalOut myLED1(LED1);
DigitalOut myLED2(LED2);
DigitalOut myLED3(LED3);
DigitalOut myLED4(LED4);
TextLCD panel(p14, p15, p16, p17, p19, p20);
uLCD_4DGL lcd(p28,p27,p29);
AnalogOut DACout(p18);
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd");

//Globals
vector <string> filenames;
int current = 0;
bool play = false, sd_insert = false;
static int veclen = 5;
FILE *wave_file;

void sd_check(){
    int sdPre = sdd.read();
    while (sdPre == 0){
        lcd.locate(0,0);
        lcd.printf("Insert SD card");
        sdPre = sdd.read();
        wait (.5);
    }
    lcd.cls();
}

void write_screen()
{
    lcd.locate(0,0);
    string name;
    int j = 0;
    vector<string>::iterator it;
    //lcd.cls();
    for(it = filenames.begin(); it < filenames.end(); it++) {
        name = (*it).c_str();
        name.erase((name.length()-4),4);
        if(j++ == current){
            lcd.printf("~");
        }
        else{
            lcd.printf(" ");
        }
        if(name.length() > 17){
            name.erase(17,(17-name.length()));
            lcd.printf("%s",name);
        }
        else{
            lcd.printf("%s\n",name);
        }
    }
    /*for(int j = 0; j > veclen; j++){
        lcd.locate(0,j);
        if(j == current){
            lcd.printf("~");
        }
        else{
            lcd.printf("~");   
        }
    }*/
}

void write_panel()
{
    panel.cls();
    if(play == true){
    string name;
    vector<string>::iterator it;
    it = filenames.begin() + current;
    name = (*it).c_str();
    name.erase((name.length()-4),4);
    if(name.length() > 16){
        name.erase(16,(16-name.length()));
        panel.printf("%s",name);
    }
    else{
        panel.printf("%s\n",name);
    }
    }
    else{
        panel.printf("Stopped\n");
    }
    for(int i = 0; i < 16; i++){
        if(i < waver.volume){
            panel.printf("*");
        }
        else
        {    
        panel.printf(" ");
        }
    }
}
void play_file()
{
    bool* play_point = &play;
    string file_name("/sd/");
    file_name += filenames[current];
    wave_file = fopen(file_name.c_str(),"r");
    waver.play(wave_file, play_point);
    fclose(wave_file);
    play = false;
    write_panel();
}

//Push buttons
void pb1_hit_callback (void)
{
    if(play == false){
        current = (current-1) % veclen;
        if(current < 0){
            current += veclen;
        }
        write_screen();
    }
}

void pb2_hit_callback (void)
{
    if(play == false){
        current = (1+current) % veclen;
        write_screen();
    }    
}

void pb3_hit_callback (void)
{
    play = !play;
    write_panel();
}

void pb4_hit_callback (void)
{
    waver.volume--;
    if(waver.volume < 0){
        waver.volume = 16;
    }
    write_panel();

}

//Set up
void push_set()
{
    // Use internal pullups for the three pushbuttons
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    pb3.mode(PullUp);
    pb4.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
}

//File reads
void read_file_names(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}

int main()
{
    lcd.cls();
    panel.cls();
    sd_check();
    push_set();
    read_file_names("/sd/");
    write_screen();
    write_panel();
    while(true)
    {     
        wait(.01);
        if(play == true)
        {
            play_file();
        }
    }
}