#include "mbed.h"
//#include "EthernetNetIf.h"
#include "NTPClient.h"
#include "EthernetInterface.h"
#include "uLCD_4DGL.h"
//#include "Speaker.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "PinDetect.h"


#include <vector>
#include <string>

// Parameters
char* domain_name = "0.uk.pool.ntp.org";
int port_number = 123;

// Networking
EthernetInterface eth;
NTPClient ntp_client;

// Internet of Things clock example: LCD time is set via internet NTP time server
uLCD_4DGL uLCD(p28,p27,p29); // create a global LCD object
//EthernetNetIf eth;
//NTPClient ntp;
SDFileSystem sd(p11, p12, p13, p14, "sd"); //SD card
AnalogOut DACout(p18);  //speaker
wave_player waver(&DACout);
PinDetect snooze(p19);  //snooze button
PinDetect off(p20);     //turn alarm off
DigitalIn sdd(p12);
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);

#define snoozeTime 60

//Global Variables
//variables for SD sound
vector <string> filenames;
int current = 0;
bool playing = false;
bool sd_insert = false;
static int veclen = 5;
//FILE *wave_file;
//variables for alarm
//system time structure
time_t ctTime; //ctTime = current time
// Base alarm time-24 hour clock
int baseAlarmHour = 0; //0-23
int baseAlarmMin = 0;
// Current alarm time
int curAlarmHour = 18; //0-23
int curAlarmMin = 9;
//SongPlayer mySpeaker(p26);
Ticker flippera;

//alarm tone
float note[17]= {1568.0,1396.9,1244.5,1244.5,1396.9,1568.0,1568.0,1568.0,1396.9,
                 1244.5,1396.9,1568.0,1396.9,1244.5,1174.7,1244.5,1244.5,
                };
float duration[17]= {0.48,0.24,0.72,0.48,0.24,0.48,0.24,0.24,0.24,
                     0.24,0.24,0.24,0.24,0.48,0.24,0.48,0.48
                    };

void flip_time()
{
    myled1 = !myled1;
    char time_buffer[80];
    uLCD.locate(0, 1);
    ctTime = time(NULL);
    strftime(time_buffer, 80, "    %a %b %d\n    %T %p %z\n    %Z\n", \
             localtime(&ctTime));
    uLCD.printf("    UTC/GMT:\n%s", time_buffer);
}

void thread_time(void const *args)
{
    while(1) {
        myled1 = !myled1;
        char time_buffer[80];
        uLCD.locate(0, 1);
        ctTime = time(NULL);
        strftime(time_buffer, 80, "    %a %b %d\n    %T %p %z\n    %Z\n", \
                 localtime(&ctTime));
        uLCD.printf("    UTC/GMT:\n%s", time_buffer);
        Thread::wait(1000);
    }
}


//Check for SD Card
void sd_check()
{
    int sdPre = sdd.read();
    while (sdPre == 0) {
        uLCD.locate(0,0);
        uLCD.printf("Insert SD card");
        sdPre = sdd.read();
        wait (.5);
    }
    uLCD.cls();
}

//Read File Names
void read_file_names(char *dir)
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}

//Play file from SD card
void play_file()
{
    FILE *wave_file;
    printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/bob.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
}

//Interrupt-Snooze Function
void snooze_hit_callback (void)
{
    myled1 = !myled1;
    playing = false;
    time_t newtime;
    struct tm * timeinfo;

    newtime = ctTime + snoozeTime;
//    time (&newtime);
    timeinfo = localtime (&newtime);
    curAlarmMin = timeinfo->tm_min;
    curAlarmHour = timeinfo->tm_hour;
}

//Interrupt- Off Function
void off_hit_callback (void)
{
    myled2 = !myled2;
    playing = false;
    curAlarmMin = baseAlarmMin;
    curAlarmHour = baseAlarmHour;
}
//Time Compare Function
void timeCompare()
{
    struct tm * timeinfo;

    //time(&ctTime);
    timeinfo = localtime (&ctTime);
    if (timeinfo->tm_min == curAlarmMin && timeinfo->tm_hour == curAlarmHour) {
        playing = true;
        play_file();

    }
}


int main()
{
    play_file();
    snooze.mode(PullUp);
    off.mode(PullUp);
    wait(0.01);
    snooze.attach_deasserted(&snooze_hit_callback);
    off.attach_deasserted(&off_hit_callback);
    snooze.setSampleFrequency();
    off.setSampleFrequency();

    //time_t ct_time;


    // Initialize LCD
    uLCD.baudrate(115200);
    uLCD.background_color(BLACK);
    uLCD.cls();

    // Connect to network and wait for DHCP
    uLCD.locate(0,0);
    uLCD.printf("Getting IP Address\n");
    eth.init();
    if ( eth.connect(60000) == -1 ) {
        uLCD.printf("ERROR: Could not\nget IP address");
        return -1;
    }
    uLCD.printf("IP address is \n%s\n\n",eth.getIPAddress());
    wait(1);

    // Read time from server
    uLCD.printf("Reading time...\n\r");
    ntp_client.setTime(domain_name, port_number);
    uLCD.printf("Time set\n");
    wait(2);
    eth.disconnect();

    // Reset LCD
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);
    uLCD.color(RED);
    uLCD.cls();
    uLCD.text_height(2);

    // flippera.attach(&flip_time, 1.0);
    Thread time_thread(thread_time);

    // Loop and update clock
    while (1) {
        /*
        myled1 = !myled1;
        char time_buffer[80];
        uLCD.locate(0, 1);
        ctTime = time(NULL);
        strftime(time_buffer, 80, "    %a %b %d\n    %T %p %z\n    %Z\n", \
                 localtime(&ctTime));
        uLCD.printf("    UTC/GMT:\n%s", time_buffer);
        */
        timeCompare();
        wait(0.1);
        
    }


}
