#include "mbed.h"
#include "SDFileSystem.h"

#include "uLCD_4DGL.h"
 
uLCD_4DGL uLCD(p28,p27,p29);

SDFileSystem sd(p11, p12, p13, p14, "sd"); // the pinout on the mbed Cool Components workshop board
 
int main() {
    //printf("Hello World!\n");   

    //mkdir("/sd/mydir", 0777);
    char c;    
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "r");
    if(fp == NULL) {
        error("Could not open file for read\n");
    }
    int count = 0;
    int i;
    char arr_time[8] = "";
    char hour[3], min[3];
    int arrival_hour;
    int arrival_min;
    char r_time[8] = "";
    int ready_time = 0;
    char start_add[32] = ""; // start location address
    char dest_add[32] = ""; // destination address
    
    while (!feof(fp)){                        // while not end of file
        c=fgetc(fp);                         // get a character/byte from the file
        uLCD.printf("%c",c);
        if (c == '@') { 
            count++; // specifies what data (eg. arrival time, ready time, etc)
            i = 0;
        }
        else {
        //uLCD.printf("%d",count);
        switch (count) {
            case 0: // arrival time
                arr_time[i] = c;
                i++;
                break;
            case 1: // ready time (min)
                r_time[i] = c;
                i++;
                break;
            case 2: // start address
                start_add[i] = c;
                i++;
                break;
            case 3: // destination address
                dest_add[i] = c;
                i++;
                break;
            default:
                error("too many & detected\n");
                break;
        }
        
        //uLCD.printf("Read from file %02x\n\r",c); // and show it in hex format
        }
    }
    memcpy( hour, &arr_time[0], 2 );
    memcpy( min, &arr_time[3], 2 );

    arrival_hour = atoi(hour);
    arrival_min = atoi(min);
    uLCD.printf("\narrival hour is %d\n",arrival_hour);
    uLCD.printf("arrival min is %d\n",arrival_min);

    ready_time = atoi(r_time);
    //uLCD.printf("\nString ready time is %s",r_time);
    uLCD.printf("Ready Time is %d\n",ready_time);
    uLCD.printf("start address is %s\n", start_add);
    uLCD.printf("dest address is %s\n", dest_add);
   
   
   
    
    //fprintf(fp, "Hello fun SD Card World!");
    fclose(fp); 
 
    //printf("Goodbye World!\n");
}
