//WavePlayer_HelloWorld4180
//internet_clock

#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "PinDetect.h"
#include "HTTPClient.h"

//pinouts
// Graphic LCD - TX, RX, and RES pins
uLCD_4DGL uLCD(p28,p27,p29);
SDFileSystem sd(p11, p12, p13, p14, "sd"); //SD card
Serial pc(USBTX, USBRX);
Serial time_weth(p9, p10);
AnalogOut DACout(p18);
wave_player waver(&DACout);
PinDetect snooze(p19);  //snooze button
PinDetect off(p20);     //turn alarm off
PinDetect settings(p17);     //turn alarm off
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
//Mutex lcd_mutex;

// Parameters
char* time_domain_name = "0.uk.pool.ntp.org";
//char* weth_domain_name = "http://weather.yahooapis.com/forecastrss?w=2502265";
//char* weth_domain_name = "http://developer.mbed.org/media/uploads/mbed_official/hello.txt";
//char* weth_domain_name = "https://query.yahooapis.com/v1/public/yql?q=select%20item.condition%20from%20weather.forecast%20where%20woeid%20in%20%28select%20woeid%20from%20geo.places%281%29%20where%20text%3D%22atlanta%2C%20ga%22%29&format=json&env=store%3A%2F%2Fdatatables.org%2Falltableswithkeys";
int port_number = 123;

// Networking
EthernetInterface eth;
#define snoozeTime 420
#define locationLength 50

//global variables
time_t ct_time;
// Base alarm time-24 hour clock
int baseAlarmHour = 0; //0-23
int baseAlarmMin = 0;
// Current alarm time
int curAlarmHour = 18; //0-23
int curAlarmMin = 9;
bool play = true;
//traffic
char start_add[locationLength]; // start location address
char dest_add[locationLength]; // destination address
int trip_sec = 47400;
int arrival_hour;
int arrival_min;
int ready_time = 0;


//time thread
void time_thread(void const *args)
{
    char time_buffer[80];
    // Loop and update clock
    while (1) {
        //lcd_mutex.lock();
        uLCD.locate(0, 1);
        ct_time = time(NULL);
        strftime(time_buffer, 80, "    %a %b %d\n    %T %p %z\n    %Z\n", \
                 localtime(&ct_time));
        uLCD.printf("    UTC/GMT:\n%s", time_buffer);
        //lcd_mutex.unlock();
        Thread::wait(100);
    }
}

void reset_alarm()
{
    int trip_hour = trip_sec/(60*60);
    int trip_min = (trip_sec - trip_hour*(60*60))/60;
    uLCD.printf("trip %d:%d\n", trip_hour, trip_min);
    baseAlarmHour = arrival_hour - trip_hour;
    baseAlarmMin = arrival_min - trip_min - ready_time;
    while(baseAlarmMin<0) {
        baseAlarmHour -= 1;
        baseAlarmMin += 60;
    }
    if(baseAlarmHour<0) {
        baseAlarmHour +=24;
    }
    curAlarmHour = baseAlarmHour;
    curAlarmMin = baseAlarmMin;
}

void comm_get()
{
    int sum = 0;
    bool flag = false;
    char url[512];
    char buff[4];
    int i = 0;
    sprintf(url, "https://www.mapquestapi.com/directions/v2/route?key=ZoiBJSzSoqfdNiLD0Z9kZdw4uAN5QUQW&from=%s&to=%s", start_add, dest_add);
    uLCD.printf("%s^\n",url);
    time_weth.printf("%s^",url);
    uLCD.printf("Reading travel time");
    while(!flag) {
        buff[i] = time_weth.getc();
        //pc.putc(buff[i]);
        flag = buff[i] == '^';
        i++;
    }
    for(i = 0; i < 4; i++) {
        sum += int(buff[3-i]-'0') * pow(10.0,i);
    }
    trip_sec = sum;
    uLCD.printf("travel secs %d\n", trip_sec);
    wait(10);
}
/*
//communication thread
void comm_thread(void const *args)
{
    char buff[4];
    int i;
    int sum = 0;
    bool flag;
    while(true) {
        for(i = 0; i < locationLength; i++) {
            time_weth.putc(start_add[i]);
        }
        time_weth.putc('@');
        for(i = 0; i < locationLength; i++) {
            time_weth.putc(dest_add[i]);
        }
        flag = false;
        i = 0;
        uLCD.printf("send fomplete");
        while(!flag) {
            buff[i] = pc.getc();
            //pc.putc(buff[i]);
            flag = buff[i] == '^';
            i++;
        }
        for(i = 0; i < 4; i++) {
            sum += int(buff[i]-'0') * pow(10.0,i);
        }
        trip_sec = sum;
        reset_alarm();
        Thread::wait(1800000);
    }
}
*/
//pushbutton (p19)
void snooze_hit_callback (void)
{
    myled1 = !myled1;
    play = false;
    time_t newtime;
    struct tm * timeinfo;
    newtime = ct_time + snoozeTime;
//time (&newtime);
    timeinfo = localtime (&newtime);
    curAlarmMin = timeinfo->tm_min;
    curAlarmHour = timeinfo->tm_hour;
}

void off_hit_callback (void)
{
    myled2 = !myled2;
    play = false;
    curAlarmMin = baseAlarmMin;
    curAlarmHour = baseAlarmHour;
}

void settings_hit_callback (void)
{
    while(1) {
        char buff[100];
        int i = 0;
        bool flag = false;
        while(!flag) {
            buff[i] = pc.getc();
            pc.putc(buff[i]);
            flag = buff[i] == '^';
            i++;
        }
        uLCD.printf("%s", buff);

        mkdir("/sd/mydir", 0777);
        FILE *fp = fopen("/sd/mydir/sdtest.txt", "w");
        if(fp == NULL) {
            error("Could not open file for write\n");
        }
        fprintf(fp, buff);
        fclose(fp);
    }
}

void play_file()
{
    bool* play_point = &play;
    FILE *wave_file;
    printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/bob.wav","r");
    waver.play(wave_file, play_point);
    fclose(wave_file);
}

void timeCompare()
{
    struct tm * timeinfo;
    timeinfo = localtime (&ct_time);
    if (timeinfo->tm_min == curAlarmMin && timeinfo->tm_hour == curAlarmHour) {
        play = true;
        myled3 = true;
        play_file();
    }
}

void getSDInfo()
{
    char c;
    FILE *fp = fopen("/sd/mydir/sdtest.txt", "r");
    if(fp == NULL) {
        error("Could not open file for read\n");
    }
    int count = 0;
    int i;
    char arr_time[8] = "";
    char hour[3], min[3];
    char r_time[8] = "";


    while (!feof(fp)) {                       // while not end of file
        c=fgetc(fp);                         // get a character/byte from the file
        uLCD.printf("%c",c);
        if (c == '@') {
            count++; // specifies what data (eg. arrival time, ready time, etc)
            i = 0;
        } else {
            //uLCD.printf("%d",count);
            switch (count) {
                case 0: // arrival time
                    arr_time[i] = c;
                    i++;
                    break;
                case 1: // ready time (min)
                    r_time[i] = c;
                    i++;
                    break;
                case 2: // start address
                    start_add[i] = c;
                    i++;
                    break;
                case 3: // destination address
                    dest_add[i] = c;
                    i++;
                    break;
                default:
                    error("too many & detected\n");
                    break;
            }

            //uLCD.printf("Read from file %02x\n\r",c); // and show it in hex format
        }
    }
    memcpy( hour, &arr_time[0], 2 );
    memcpy( min, &arr_time[3], 2 );

    arrival_hour = atoi(hour);
    arrival_min = atoi(min);
    uLCD.printf("\narrival hour is %d\n",arrival_hour);
    uLCD.printf("arrival min is %d\n",arrival_min);

    ready_time = atoi(r_time);
    //uLCD.printf("\nString ready time is %s",r_time);
    uLCD.printf("Ready Time is %d\n",ready_time);
    uLCD.printf("start address is %s\n", start_add);
    uLCD.printf("dest address is %s\n", dest_add);
    fclose(fp);
}

int main()
{
    getSDInfo();
    uLCD.cls();
    comm_get();
    uLCD.cls();
    reset_alarm();
    uLCD.printf("base = %d:%d\ncurr = %d:%d", baseAlarmHour, baseAlarmMin, curAlarmHour, curAlarmMin);
    wait(10);
    //Thread t2(comm_thread);
    snooze.mode(PullUp);
    off.mode(PullUp);
    settings.mode(PullUp);
    wait(0.01);
    snooze.attach_deasserted(&snooze_hit_callback);
    off.attach_deasserted(&off_hit_callback);
    settings.attach_deasserted(&off_hit_callback);
    snooze.setSampleFrequency();
    off.setSampleFrequency();
    settings.setSampleFrequency();

    //play_file();


    // Initialize LCD
    uLCD.baudrate(115200);
    uLCD.background_color(BLACK);
    uLCD.cls();

    // Connect to network and wait for DHCP
    uLCD.locate(0,0);
    uLCD.printf("Getting IP Address\n");
    eth.init();
    if ( eth.connect(60000) == -1 ) {
        uLCD.printf("ERROR: Could not\nget IP address");
        return -1;
    }
    uLCD.printf("IP address is \n%s\n\n",eth.getIPAddress());
    // Read time from server
    {
        uLCD.printf("Reading time...\n\r");
        NTPClient ntp_client;
        ntp_client.setTime(time_domain_name, port_number);
        uLCD.printf("Time set\n");
    }
    Thread::wait(2000);
    eth.disconnect();

    // Reset LCD
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);
    uLCD.color(RED);
    uLCD.cls();
    uLCD.text_height(2);

    Thread t1(time_thread);
    while(true) {
        timeCompare();
        Thread::wait(100);
    }

}