//WavePlayer_HelloWorld4180
//internet_clock

#include "mbed.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#include "EthernetInterface.h"
#include "NTPClient.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "PinDetect.h"

//pinouts
SDFileSystem sd(p11, p12, p13, p14, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
PinDetect snooze(p19);  //snooze button
PinDetect off(p20);     //turn alarm off
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);

// Parameters
char* domain_name = "0.uk.pool.ntp.org";
int port_number = 123;

// Networking
EthernetInterface eth;
NTPClient ntp_client;

// Graphic LCD - TX, RX, and RES pins
uLCD_4DGL uLCD(p28,p27,p29);

#define snoozeTime 10

//global variables
time_t ct_time;
// Base alarm time-24 hour clock
int baseAlarmHour = 0; //0-23
int baseAlarmMin = 0;
// Current alarm time
int curAlarmHour = 18; //0-23
int curAlarmMin = 9;

//time thread
void time_thread(void const *args)
{
    char time_buffer[80];
    // Loop and update clock
    while (1) {
        uLCD.locate(0, 1);
        ct_time = time(NULL);
        strftime(time_buffer, 80, "    %a %b %d\n    %T %p %z\n    %Z\n", \
                 localtime(&ct_time));
        uLCD.printf("    UTC/GMT:\n%s", time_buffer);
        Thread::wait(100);
    }
}

//pushbutton (p19)
void snooze_hit_callback (void)
{
    myled1 = !myled1;
    time_t newtime;
    struct tm * timeinfo;
    newtime = ct_time + snoozeTime;
//time (&newtime);
    timeinfo = localtime (&newtime);
    curAlarmMin = timeinfo->tm_min;
    curAlarmHour = timeinfo->tm_hour;
}

void off_hit_callback (void)
{
    myled2 = !myled2;
}

void play_file()
{
    FILE *wave_file;
    printf("\n\n\nHello, wave world!\n");
    wave_file=fopen("/sd/bob.wav","r");
    waver.play(wave_file);
    fclose(wave_file);
}

void timeCompare()
{
    struct tm * timeinfo;
    timeinfo = localtime (&ct_time);
    if (timeinfo->tm_min == curAlarmMin && timeinfo->tm_hour == curAlarmHour) {
        //playing = true;
        play_file();
        myled3 = true;
    }
}

int main()
{
    snooze.mode(PullUp);
    off.mode(PullUp);
    wait(0.01);
    snooze.attach_deasserted(&snooze_hit_callback);
    off.attach_deasserted(&off_hit_callback);
    snooze.setSampleFrequency();
    off.setSampleFrequency();



    // Initialize LCD
    uLCD.baudrate(115200);
    uLCD.background_color(BLACK);
    uLCD.cls();

    // Connect to network and wait for DHCP
    uLCD.locate(0,0);
    uLCD.printf("Getting IP Address\n");
    eth.init();
    if ( eth.connect(60000) == -1 ) {
        uLCD.printf("ERROR: Could not\nget IP address");
        return -1;
    }
    uLCD.printf("IP address is \n%s\n\n",eth.getIPAddress());
    Thread::wait(1000);

    // Read time from server
    uLCD.printf("Reading time...\n\r");
    ntp_client.setTime(domain_name, port_number);
    uLCD.printf("Time set\n");
    Thread::wait(2000);
    eth.disconnect();

    // Reset LCD
    uLCD.background_color(WHITE);
    uLCD.textbackground_color(WHITE);
    uLCD.color(RED);
    uLCD.cls();
    uLCD.text_height(2);

    Thread thread_time(time_thread);
    while(!myled3) {
        timeCompare();
        Thread::wait(100);
    }

}