#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"
#include "wave_player.h"
//additional for Lab4
//#include "PinDetect.h"
#include "uLCD_4DGL.h"
#include <vector>
#include <string>
#include "ShiftBrite.h"

uLCD_4DGL uLCD(p28,p27,p29); // create a global LCD object
//uLCD_4DGL uLCD(p28, p27, p29);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
DigitalIn detectSD(p12); //connect CD 
AnalogOut DACout(p18); //speaker
wave_player waver(&DACout);  //wave player library
//DigitalOut latch(p15);
//DigitalOut enable(p16);
SPI spi(p11, p12, p13);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
ShiftBrite myBrite(p15,p16,spi); //latch, enable, spi


Mutex stdio_mutex; 

//shiftbrite
/*void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}
*/
void lcd1_thread(void const *args) {
    while(1){
        int drop = rand()% 140;
        for(int i = 0; i < 140; i += 3){
            stdio_mutex.lock();
            uLCD.filled_circle(i-3,drop,5,BLACK);
            uLCD.filled_circle(i,drop,5,BLUE);
            stdio_mutex.unlock();
            //Thread::wait(50);
        }
    }
}

void lcd2_thread(void const *args) {
    Thread::wait(250);
    while(1){
        int drop = rand()% 140;
        for(int i = 0; i < 140; i += 6){
            stdio_mutex.lock();
            uLCD.filled_circle(i-6,drop,5,BLACK);
            uLCD.filled_circle(i,drop,5,BLUE);
            stdio_mutex.unlock();
            //Thread::wait(200);
        }
    }
}

void lcd3_thread(void const *args) {
    Thread::wait(100);
    while(1){
        int drop = rand()% 140;
        for(int i = 0; i < 140; i += 2){
            stdio_mutex.lock();
            uLCD.filled_circle(i-2,drop,5,BLACK);
            uLCD.filled_circle(i,drop,5,BLUE);
            stdio_mutex.unlock();
            //Thread::wait(100);
        }
    }
}

void wav_thread(void const *args) {
    while(1) {
        FILE *wave_file;
        printf("\n\n\nHello, wave world!\n\r");
        wave_file=fopen("/sd/beethoven.wav","r");
        printf("hello\n\r");
        if (wave_file) {
            printf("wave file found\n\r");
            }
        else {
            printf("file not found\n\r");
            }
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(1000);
    }
}

void shift_thread(void const *args){
    
    int r,g,b;
    while(1) {
        r=g=b=50;
        myBrite.Write(250,250,160);
        Thread::wait(150);
        myBrite.Write(0,0,0);
        Thread::wait(3000+(rand()%10000));
        myBrite.Brightness(r,g,b);
        if(r<1023)
            r+=50;
        else
            r=50;
        g=b=r;
        
    }

    
}

void led2_thread(void const *args) {
    while (true) {
        led2 = !led2;
        Thread::wait(1000);
    }
}

void notify(const char* name, int state) {
    stdio_mutex.lock();
    printf("%s: %d\n\r", name, state);
    stdio_mutex.unlock();
}

int main() {
    uLCD.baudrate(BAUD_3000000);
    Thread audio(wav_thread);
    Thread thread(led2_thread);
    Thread lighting(shift_thread);
    Thread image1(lcd1_thread);
    Thread image2(lcd2_thread);
    Thread image3(lcd3_thread);
    
    while (true) {
        led1 = !led1;
        Thread::wait(500);
    }
}