
#include "mbed.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#include "stdio.h"
#include "Speaker.h"
#include "banner.h"
#include "SDFileSystem.h"
#include "wave_player.h"


RawSerial  pc(USBTX, USBRX);
RawSerial  dev(p28,p27);
AnalogOut DACout(p18);
wave_player waver(&DACout);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
uLCD_4DGL uLCD(p13,p14,p11);
PwmOut RGBLED_r(p23);
PwmOut RGBLED_g(p24);
PwmOut RGBLED_b(p25);
BusOut leds(LED1,LED2,LED3,LED4);
Mutex lcd_mutex;

//Thread screen;
//Thread lights;
//Thread audio;
//Thread count;

void dev_recv()
{
    while(dev.readable()) {
        pc.putc(dev.getc());
    }
}

void pc_recv()
{
    while(pc.readable()) {
        dev.putc(pc.getc());
    }
}



void thread1(void const *args)
{
    int i=0;
    int x;
//    while(true) {       // thread loop
        if(i==0){
            x=0xFF0000;
        }
        else if (i==1){
            x=0xFFFFFF;  
        }
        else{
            x=0x0000FF;   
        }
        lcd_mutex.lock();
        uLCD.filled_rectangle(0,0,128, 100, x);
        lcd_mutex.unlock();
        i++;
        i=i%3;
        Thread::wait(100);
//    }
}


void thread5(void const *args)
{
    int i = 0;
//    while(true) { 
            // thread loop
        if(i==0){
            RGBLED_r = 1;
            RGBLED_g = 0;
            RGBLED_b = 0;
        }
        else if(i==1){
            RGBLED_r = 1;
            RGBLED_g = 1;
            RGBLED_b = 1;
        }
        else{
            RGBLED_r = 0;
            RGBLED_g = 0;
            RGBLED_b = 1;
        }
        i++;
        i=i%3;
        Thread::wait(673);    // wait 1.5s
//    }
}
//// Thread 6
//// Speaker
void thread6(void const *args)
{
//    while(true) {         // thread loop
            FILE *wave_file;
    printf("\r\n\nHello, wave world!\n\r");
    Thread::wait(1000);
    wave_file=fopen("/sd/banner2.wav","r");
    if(wave_file==NULL) printf("file open error!\n\n\r");
    waver.play(wave_file);
    fclose(wave_file);
//    }

}

void thread7(void const *args)
{
    int i = 0;
    while(true) {         // thread loop
        i++;
        printf("thread 1: %d\n", i);
        Thread::wait(1000);    // wait 0.25s
    }
}


//void bluetooth(void const *args){
//    while(1){
//        if(dev.getc()=='a'){
//            Thread t6(thread6);
//        }
//        if(dev.getc()=='s'){
//            Thread t1(thread1);
//        }
//        if(dev.getc()=='l'){
//            Thread t5(thread5);
//        }
//        if(dev.getc()=='c'){
//            Thread t7(thread7);
//        }
//        Thread::wait(100);
//    }
//}
int main()
{
//    int j;
    uLCD.cls();

    pc.baud(9600);
    dev.baud(9600);

    pc.attach(&pc_recv, Serial::RxIrq);
    dev.attach(&dev_recv, Serial::RxIrq);
//    Thread blue(bluetooth);
    while(1) {
        if(dev.getc()=='a'){
            Thread audio(thread6);
        }
        if(dev.getc()=='s'){
            Thread screen(thread1);
        }
        if(dev.getc()=='l'){
            Thread light(thread5);
        }
        if(dev.getc()=='c'){
            Thread count(thread7);
        }
//        sleep();
    }
//    Thread t1(thread1); //start thread1
    //Thread t2(thread2); //start thread2
    //Thread t3(thread3); //start thread3
    //Thread t4(thread4); //start thread4
//    Thread t5(thread5); //start thread5
//    Thread t6(thread6); //start thread6
//    Thread t7(thread7); //start thread7

}
