// A simple IO demo using the MCP23S17 library
//
// MCP23S17 Library Copyright (c) 2010 Romilly Cocking
// Released under the MIT License: http://mbed.org/license/mit
//
// See http://mbed.org/users/romilly/notebook/mcp23s17-addressable-16-bit-io-expander-with-spi/
//
//
// MCP23S17 datasheet http://ww1.microchip.com/downloads/en/DeviceDoc/21952b.pdf
// uses MCP23S17 library version 0.4

#include "mbed.h"
#include "MCP23S17.h"
// Create SPI bus
SPI spi(p5, p6, p7);
// 
// Wiring Connections:
// mbed p5,p6,p7 are tied to MCP23S17 SI, SO, SCK pins
// mbed p20 to MCP23S17 CS
// MCP23S17 reset pin pulled high
// MCP23S17 GPA0 connected to GPB0 for loopback test
// A0, A1, A2 of the MCP23S17  are tied to ground on the breadboard, so the 8-bit address for writes is 0x40
// This is referred to as the opcode in the device datasheet
char Opcode1 = 0x40;
char Opcode2 = 0x4E;

// Next create a MCP23S17
// mbed p20 is connected to ~chipSelect on the MCP23S17
MCP23S17 chip1 = MCP23S17(spi, p20, Opcode1);
MCP23S17 chip2 = MCP23S17(spi, p19, Opcode2);

// Optional software reset - mbed p14 to MCP23S17 reset pin
 DigitalOut reset(p14);

DigitalOut led1(LED1); // mbed LED1 is used for test status display

int main() {
//  The MCP23S17 reset pin can just be pulled high, since it has a power on reset circuit.
//  The reset pin can be used for a software forced reset by pulling it low with an mbed GPIO pin.
//  But just leave it pulled high for this simple demo code.
//  After a power on reset, both IO ports default to input mode
//
//  Here is the optional code for a software reset
  reset = 0;
  wait_us(1);
  reset = 1;
//
//  Set all 8 Port A bits to output direction
    chip1.direction(PORT_A, 0x00);
//  Set all 8 Port B bits to input direction
    chip1.direction(PORT_B, 0xFF);
    //  Set all 8 Port A bits to output direction
    chip2.direction(PORT_A, 0x00);
//  Set all 8 Port B bits to input direction
    chip2.direction(PORT_B, 0xFF);
    led1=0;
//  Start Loopback test sending out and reading back values
//  loopback test uses A0 and B0 pins - so use a wire to jumper those two pins on MCP23S17 together
    while (1) {
        // write 0xAA to MCP23S17 Port A
        //chip.write(PORT_A, 0x80);
        //wait(.5);
        // read back value from MCP23S17 Port B and display B0 on mbed led1
        //led1 = chip1.read(PORT_B)& 0x01;
        // write 0x55 to MCP23S17 Port A
        //chip2.write(PORT_A, led1);
        //wait(.5);
        // read back value from MCP23S17 Port B and display B0 on mbed led1
        //led1 = chip.read(PORT_B)& 0x01;
        //led1 should blink slowly when it is all working
        
        if ((chip1.read(PORT_B)& 0x01)){
            chip2.write(PORT_A, 0xFF);
           }
        else{
            chip2.write(PORT_A, 0x00);
            }
    }
}
