#include "mbed.h"
#include "SparkfunAnalogJoystick.h"
#include "uLCD_4DGL.h"
#include "FEmain.h"
#define MapSecA 123
#define MapSecB 123

#include "Motor.h"
int units_received = 0;

Motor m(p21, p24, p25); // pwm, fwd, rev

#define FORTRESS 0
#define HOUSE 1
#define KEEP 2
#define GRASS 3
#define TREES 4
#define COMP 2
#define USER 1


DigitalOut myled(LED1);
uLCD_4DGL uLCD(p9,p10,p11);
DigitalIn pb5(p5);
DigitalIn pb6(p6);
DigitalIn pb7(p7);
DigitalIn pb8(p8);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
#define M_PI 3.14159265358979323846
Serial pc(USBTX, USBRX);
Serial Julio_Mbed(p28,p27);
SparkfunAnalogJoystick joysttick(p18, p19, p20);
#define x_sector 0x003B
int analog2Keypad(SparkfunAnalogJoystick *joystick);
int player_turn;
char stagenumber = 0;

struct tiles {
        char v;
        int x;
        int y;
        char passable;
        tiles(char v1 =0, int x1=0, int y1=0, char p1=0) : v(v1), x(x1), y(y1), passable(p1){}}; //fortress_t,house_t,keep_t,grass_t,trees_t;
const tiles fortress_t(0,x_sector,0x5009,0);
const tiles house_t(1,x_sector,0x5021,1);
const tiles keep_t(2,x_sector,0x501B,1);
const tiles grass_t(3,x_sector,0x501D,1);
const tiles trees_t(4,x_sector,0x5019,1);
const tiles hill_t(5,x_sector,0x501F,1);

tiles tile_array[6] = {fortress_t,house_t,keep_t,grass_t,trees_t,hill_t};


typedef struct units {
        job_t job;
        char v;
        int FoF;//1 = USER // 2= COMP
        int xloc;
        int yloc;
        int xlast;
        int ylast;
        char remain_moves;
        char health;
        char status;
    } person_t;

    
static person_t Mc;
static person_t Ak;
static person_t Ap;
static person_t Healer;
static person_t Brigand;    
static person_t Thief;
static person_t Soldier;
static person_t Wolf;
static person_t Wolfa;
static person_t Wolfb;
static person_t Wolfc;

static person_t p_Princess;
static person_t p_Thief;
static person_t p_WhiteMage;
static person_t p_Pirate;
static person_t p_Lancer;
static person_t p_Archer;
static person_t p_Dragon;
static person_t p_Sage;
static person_t p_Caster;
static person_t p_Assassin;
static person_t p_Medic;
static person_t p_Brigand;
static person_t p_Wolf_a;
static person_t p_Wolf_b;
static person_t p_Wolf_c;
static person_t p_Assassin_e;
static person_t p_Fighter_a;
static person_t p_Fighter_b;
static person_t p_Fighter_c;
static person_t p_RedSpider;
static person_t p_Spider_a;
static person_t p_Spider_b;
static person_t p_Spider_c;
static person_t p_FallenHero;
static person_t p_Mage_4a;
static person_t p_Mage_4b;
static person_t p_Mage_4c;
static person_t p_TrueAssassin;
static person_t p_Zombie_5a;
static person_t p_Zombie_5b;
static person_t p_Zombie_5c;
static person_t p_General;
static person_t p_Zombie_6a;
static person_t p_Zombie_6b;
static person_t p_Mage_6a;
static person_t p_Mage_6b;
static person_t p_Summoner;
static person_t p_Zombie_7a;
static person_t p_Zombie_7b;
static person_t p_Zombie_7c;
static person_t p_Zombie_7d;

person_t* person_array[42] = {NULL, &p_Princess, &p_Thief, &p_WhiteMage, &p_Pirate, &p_Lancer, &p_Archer, &p_Dragon, &p_Sage, &p_Caster, &p_Assassin, &p_Medic, 
                                    &p_Brigand, &p_Wolf_a, &p_Wolf_b, &p_Wolf_c, 
                                    &p_Assassin_e, &p_Fighter_a, &p_Fighter_b, &p_Fighter_c, 
                                    &p_RedSpider, &p_Spider_a, &p_Spider_b, &p_Spider_c, 
                                    &p_FallenHero, &p_Mage_4a, &p_Mage_4b, &p_Mage_4c, 
                                    &p_TrueAssassin, &p_Zombie_5a, &p_Zombie_5b, &p_Zombie_5c, 
                                    &p_General, &p_Zombie_6a, &p_Zombie_6b, &p_Mage_6a, &p_Mage_6b, 
                                    &p_Summoner, &p_Zombie_7a, &p_Zombie_7b, &p_Zombie_7c, &p_Zombie_7d};
    
char Map1_1[8][8] = {
    {FORTRESS, FORTRESS, FORTRESS,  GRASS,  GRASS,  GRASS,  HOUSE,  GRASS},
    {FORTRESS, FORTRESS, FORTRESS,  GRASS,  GRASS,  GRASS,  GRASS,  GRASS},
    {FORTRESS, FORTRESS, FORTRESS,  GRASS,  TREES,  GRASS,  GRASS,  GRASS},
    {GRASS,    GRASS,    GRASS,     GRASS,  GRASS,  GRASS,  GRASS,  GRASS},
    {GRASS,    GRASS,    GRASS,     GRASS,  GRASS,  GRASS,  GRASS,  GRASS},
    {GRASS,    GRASS,    GRASS,     GRASS,  TREES,  TREES,  TREES,  GRASS},
    {GRASS,    GRASS,    HOUSE,     TREES,  GRASS,  KEEP,   GRASS,  GRASS},
    {GRASS,    GRASS,    GRASS,     GRASS,  GRASS,  GRASS,  GRASS,  GRASS} };

char unitsMap1_1[8][8] = {
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0},
    {0, 0, 0, 0, 0, 0, 0, 0} };
    
    
    
        
void initialize(void);
//void load_game_state
int user_selecting(void);//return selection
int user_action(int selection);
int display_status(int selection); 
int user_movement(int selection);
int combat(person_t* attacker, person_t* defender);
int heal(person_t* attacker, person_t* defender);
void find_player(person_t* ai_pred);
void hunt_player(person_t* predator, person_t* prey, int prey_x, int prey_y, int predator_x, int predator_y);
void ai_movement(void);    
void ask_nextstage(void);
void load_units_map(void);
void combatPhase(char a, char d);
void sendMap(void);
void sendUnits (void);
void receiveMap (void);
void receiveUnits (void);
void waitForAck (void);
int state;
int cursor_x;
int cursor_y;
void kill_unit(person_t* dead_unit);
    
int main() {
    uLCD.media_init();
    pb5.mode(PullUp);
    pb6.mode(PullUp);
    pb7.mode(PullUp);
    pb8.mode(PullUp);
    initialize();
    int selection;
    int action;
    player_turn =1;
    cursor_x = 0;
    cursor_y = 0;
    state = 0;
    person_t* temp_persona;
    while(1) {
        if (state == 0){
            selection = user_selecting();}
        //else if (state ==1)
            //ret_val = display_status(selection); 
        else if (state == 2){
            action = user_movement(selection);}
        else if (state == 3){
            if (player_turn ==1){
                player_turn = 2;
                ai_movement();
                }
            else {
                player_turn =1;
                }
            for(int i=1; i<42;i++){
                temp_persona = person_array[i]; 
                temp_persona->remain_moves = temp_persona->job.movement; 
                }
            state = 0;
            }
        //else if (state == 4)
    }
}
//cleric - lord - ax
//noth - spear



void initialize(void){
    init_jobs();
//    keep_t.x = x_sector;
//    house_t.x = x_sector;
//    grass_t.x = x_sector;
//    trees_t.x = x_sector;
//    fortress_t.x = x_sector;
//    fortress_t.y = 0x5042;
//    trees_t.y = 0x5052;
//    keep_t.y = 0x5054;
//    grass_t.y = 0x5056;
//    house_t.y = 0x5058;
    //wait for ack function
    /*while(!pc.readable()){
        wait(.001);
    }
    for (int y_num = 0; y_num < 8; y_num ++){
        for(int x_num = 0; x_num<8; x_num ++){
            Map1_1[y_num][x_num] = pc.getc();
        }
    }
    tiles tile_draw;
    int castledrawn = 0;
    int drawn;
    for (int y_num = 0; y_num < 8; y_num ++){
        for(int x_num = 0; x_num<8; x_num ++){
            drawn = Map1_1[y_num][x_num];
            if (! ((drawn == CASTLE) && (castledrawn == 1))){
                tile_draw = tile_array[Map1_1[y_num][x_num]];
                uLCD.set_sector_address(tile_draw.x,tile_draw.y);
                uLCD.display_image((16*x_num),(16*y_num));
            }
            if (drawn == CASTLE)
                castledrawn = 1;
        }
    }*/
    //uLCD.set_sector_address(Mapx, Mapy);
    //uLCD.display_image(0,0);
    p_Princess.job = j_Erika;
    p_Thief.job = j_Thief;
    p_WhiteMage.job = j_Cleric;
    p_Pirate.job = j_Pirate;
    p_Lancer.job = j_Knight;
    p_Archer.job = j_Archer;
    p_Dragon.job = j_Myrrh;
    p_Sage.job = j_Sage_M;
    p_Caster.job = j_Sage_F;
    p_Assassin.job = j_Assassin_F;
    p_Medic.job = j_Bard;
    p_Brigand.job = j_Brigand;
    p_Wolf_a.job = j_Wolf;
    p_Wolf_b.job = j_Wolf;
    p_Wolf_c.job = j_Wolf;
    p_Assassin_e.job = j_Boss_Assassin_F;
    p_Fighter_a.job = j_Fighter;
    p_Fighter_b.job = j_Fighter;
    p_Fighter_c.job = j_Fighter;
    p_RedSpider.job = j_RedSpider;
    p_Spider_a.job = j_Spider;
    p_Spider_b.job = j_Spider;
    p_Spider_c.job = j_Spider;
    p_FallenHero.job = j_Hero;
    p_Mage_4a.job = j_Mage;
    p_Mage_4b.job = j_Mage;
    p_Mage_4c.job = j_Mage;
    p_TrueAssassin.job = j_Assassin_M;
    p_Zombie_5a.job = j_Zombie;
    p_Zombie_5b.job = j_Zombie;
    p_Zombie_5c.job = j_Zombie;
    p_General.job = j_General;
    p_Zombie_6a.job = j_Zombie;
    p_Zombie_6b.job = j_Zombie;
    p_Mage_6a.job = j_Mage;
    p_Mage_6b.job = j_Mage;
    p_Summoner.job = j_Summoner;
    p_Zombie_7a.job = j_Zombie;
    p_Zombie_7b.job = j_Zombie;
    p_Zombie_7c.job = j_Zombie;
    p_Zombie_7d.job = j_Zombie;
    
    
    
    
    person_t* temp_person_init;
    for( char i = 1; i<42; i++){
        temp_person_init = person_array[i];
        temp_person_init->v = i;
        temp_person_init->status = 1;
        Mc.remain_moves = Mc.job.movement;
        temp_person_init->remain_moves = temp_person_init->job.movement;
        temp_person_init->health = temp_person_init->job.maxHealth;
        if (i<=11)
            temp_person_init->FoF = USER;
        else
            temp_person_init->FoF = COMP;
    }
    Mc.job = Lord;
    Mc.v = 1;
    Mc.FoF = USER;
    Mc.xlast = 1;
    Mc.xloc = 1;
    Mc.ylast = 3;
    Mc.yloc = 3;
    Mc.remain_moves = Mc.job.movement;
    Mc.health = Mc.job.maxHealth;
    //uLCD.set_sector_address(Mc.job.x, Mc.job.y);
    //uLCD.display_image((Mc.xloc*16),(Mc.yloc*16));
    
    Ak.job = Armor;
    Ak.v = 2;
    Ak.FoF = USER;
    Ak.xlast = 1;
    Ak.xloc = 1;
    Ak.ylast = 4;
    Ak.yloc = 4;
    Ak.remain_moves = Ak.job.movement;
    Ak.health = Ak.job.maxHealth;
    
    //uLCD.set_sector_address(Ak.job.x, Ak.job.y);
    //uLCD.display_image((Ak.xloc*16),(Ak.yloc*16));
    
    Ap.job = j_Pirate;
    Ap.v = 3;
    Ap.FoF = USER;
    Ap.xlast = 2;
    Ap.xloc = 2;
    Ap.ylast = 3;
    Ap.yloc = 3;
    Ap.remain_moves = Ap.job.movement;
    Ap.health = Ap.job.maxHealth;
    
    //uLCD.set_sector_address(Ap.job.x, Ap.job.y);
    //uLCD.display_image((Ap.xloc*16),(Ap.yloc*16));
    
//    Healer.job = j_Cleric;
//    Healer.v = 4;
//    Healer.FoF = USER;
//    Healer.xlast = 0;
//    Healer.xloc = 0;
//    Healer.ylast = 3;
//    Healer.yloc = 3;
//    Healer.remain_moves = Healer.job.movement;
//    Healer.health = Healer.job.maxHealth;
//    
    //uLCD.set_sector_address(Healer.job.x, Healer.job.y);
    //uLCD.display_image((Healer.xloc*16),(Healer.yloc*16));
    
    Wolf.job = Beast;
    Wolf.v = 8;
    Wolf.FoF = COMP;
    Wolf.xlast = 7;
    Wolf.xloc = 7;
    Wolf.ylast = 4;
    Wolf.yloc = 4;
    Wolf.remain_moves = Wolf.job.movement;
    Wolf.health = Wolf.job.maxHealth;
    
    //uLCD.set_sector_address(Wolf.job.x, Wolf.job.y);
    //uLCD.display_image((Wolf.xloc*16),(Wolf.yloc*16));    
    //unitsMap1_1[Wolf.yloc][Wolf.xloc] = Wolf.v;
    
    Wolfa.job = Beast;
    Wolfa.v = 9;
    Wolfa.FoF = COMP;
    Wolfa.xlast = 7;
    Wolfa.xloc = 7;
    Wolfa.ylast = 5;
    Wolfa.yloc = 5;
    Wolfa.remain_moves = Wolfa.job.movement;
    Wolfa.health = Wolfa.job.maxHealth;
    
    //uLCD.set_sector_address(Wolfa.job.x, Wolfa.job.y);
    //uLCD.display_image((Wolfa.xloc*16),(Wolfa.yloc*16));    
    //unitsMap1_1[Wolfa.yloc][Wolfa.xloc] = Wolfa.v;
    
    Wolfb.job = Beast;
    Wolfb.v = 10;
    Wolfb.FoF = COMP;
    Wolfb.xlast = 6;
    Wolfb.xloc = 6;
    Wolfb.ylast = 4;
    Wolfb.yloc = 4;
    Wolfb.remain_moves = Wolfb.job.movement;
    Wolfb.health = Wolfb.job.maxHealth;
    
    //uLCD.set_sector_address(Wolfb.job.x, Wolfb.job.y);
    //uLCD.display_image((Wolfb.xloc*16),(Wolfb.yloc*16));    
    //unitsMap1_1[Wolfb.yloc][Wolfb.xloc] = Wolfb.v;
    
    
    Wolfc.job = Beast;
    Wolfc.v = 11;
    Wolfc.FoF = COMP;
    Wolfc.xlast = 7;
    Wolfc.xloc = 7;
    Wolfc.ylast = 3;
    Wolfc.yloc = 3;
    Wolfc.remain_moves = Wolfc.job.movement;
    Wolfc.health = Wolfc.job.maxHealth;
    
    //uLCD.set_sector_address(Wolfc.job.x, Wolfc.job.y);
    //uLCD.display_image((Wolfc.xloc*16),(Wolfc.yloc*16));    
    //unitsMap1_1[Wolfc.yloc][Wolfc.xloc] = Wolfc.v;
    
    //unitsMap1_1[Mc.yloc][Mc.xloc] = Mc.v;
    //unitsMap1_1[Ak.yloc][Ak.xloc] = Ak.v;
    //unitsMap1_1[Ap.yloc][Ap.xloc] = Ap.v;
    //unitsMap1_1[Healer.yloc][Healer.xloc] = Healer.v;
    
    //get map
    //get units
    //send julio the char[2] {255, map/track number}
    uLCD.printf("Load Map\r\n");
    //put read from gui map code here
    uLCD.printf("Load Units\r\n");
    //put read units from gui code here
    uLCD.printf("New Game\r\n");
    uLCD.printf("Or Continue\r\n");
    while(units_received == 0){
        waitForAck();}
    load_floor(stagenumber);
    load_units_map();
    return;
}
int user_selecting(void){    
    int xlast;
    int ylast;
    int action = 0;
    int person_index = 0;
    int tile_index = 0;
    int keypad = 5;
    person_t* temp_person;
    tiles tile_erased;
    int j = pb5;
    int y = pb8;
    while(action == 0){
        keypad = 5;
        xlast = cursor_x;
        ylast = cursor_y;
        while((keypad == 5)&&(j ==1)){
        wait(1);
        j = pb5;
        y = pb8;
        keypad = analog2Keypad(&joysttick);
                if (y==0){
                    state = 3;
                    return 0;
                    }
        }
        switch (keypad)
    {
        case 1:
        {
            cursor_x = cursor_x -1;
            cursor_y = cursor_y +1;
        }
            break;
        case 2:
        {
            cursor_y = cursor_y +1;
        }
            break;
        case 3:
        {
            cursor_x = cursor_x +1;
            cursor_y = cursor_y +1;
        }
            break;
        case 4:
        {
            cursor_x = cursor_x -1;
        }
            break;
        case 5:
            break;
        case 6:
        {
            cursor_x = cursor_x +1;
        }
            break;
        case 7:
        {
            cursor_x = cursor_x -1;
            cursor_y = cursor_y -1;
        }
            break;
        case 8:
        {
            cursor_y = cursor_y -1;
        }
            break;
        case 9:
        {
            cursor_x = cursor_x + 1;
            cursor_y = cursor_y - 1;
        }
            break;
    }
        if (cursor_y <0)
            cursor_y = 0;
        if (cursor_x <0)
            cursor_x = 0;
        if (cursor_y >7)
            cursor_y = 7;
        if (cursor_x >7)
            cursor_x = 7;
        
        
        if((xlast != cursor_x) || (ylast != cursor_y)){
            person_index = unitsMap1_1[ylast][xlast];
            tile_index = Map1_1[ylast][xlast];
            if (person_index != 0){
                temp_person = person_array[person_index];
                uLCD.set_sector_address(temp_person->job.x, temp_person->job.y);
                uLCD.display_image((xlast*16), (ylast*16));
                }
            else{
                tile_erased = tile_array[tile_index];
                if (tile_index == 0){
                    uLCD.set_sector_address(tile_erased.x, tile_erased.y);
                    uLCD.display_image(0, 0);
                    }
                else{
                    uLCD.set_sector_address(tile_erased.x, tile_erased.y);
                    uLCD.display_image(xlast*16, ylast*16);
                    }
            }    
            uLCD.rectangle((cursor_x*16), (cursor_y*16), ((cursor_x*16)+15), ((cursor_y*16)+15), 0x000000);
        }
        int a = pb5;
        //int b = pb6;
        int c = pb7;
        int d = pb8;
        if (pb5 == 0){
        state = 2;
        action = 1;
        }
        //else if (pb6 == 0){
        //state = 3;
        //action = 2;
        //}
        else if (pb7 == 0){
        action = 3;
        }
        else if (pb8 == 0){
        action = 4;
        }
    }
    if (pb5 == 0){
        state = 2;
        action = 1;
    }
    return action;
}


int user_movement(int selection){
    int Index_j;
    Index_j = unitsMap1_1[cursor_y][cursor_x];
    person_t* User_person;
    if (Index_j == 0){
    state = 4;
    return 69;   
    }
    User_person = person_array[Index_j];
    if ((User_person->remain_moves) == 0)
    {
        state = 0;
        return 0;
    }
        if ((User_person->FoF) != player_turn)
    {
        state = 0;
        return 0;
    }
    Julio_Mbed.putc(1);
    Julio_Mbed.putc(User_person->v);
    Julio_Mbed.putc(User_person->health);
    Julio_Mbed.putc(User_person->job.maxHealth);
    int j = pb7;
    int xloc_u = 1;
    int yloc_u = 1;
    int xlast = 1;
    int ylast = 1;
while(j==1){
    j = pb7;
    xloc_u = (User_person->xloc);
    yloc_u = User_person->yloc;
    xlast = User_person->xlast;
    ylast = User_person->ylast;
    int keypad = 5;
        while((keypad == 5)&&(j==1)){
        wait(1);
        j = pb7;
        keypad = analog2Keypad(&joysttick);
        }
        switch (keypad)
        {
        case 1:
            xloc_u = xloc_u -1;
            yloc_u = yloc_u +1;
            break;
        case 2:
            yloc_u = yloc_u +1;
            break;
        case 3:
            xloc_u = xloc_u +1;
            yloc_u = yloc_u +1;
            break;
        case 4:
            xloc_u = xloc_u -1;
            break;
        case 5:
            break;
        case 6:
            xloc_u = xloc_u +1;
            break;
        case 7:
            xloc_u = xloc_u -1;
            yloc_u = yloc_u -1;
            break;
        case 8:
            yloc_u = yloc_u -1;
            break;
        case 9:
            xloc_u = xloc_u + 1;
            yloc_u = yloc_u - 1;
            break;
        }
        if (yloc_u <0)
            yloc_u = 0;
        if (xloc_u <0)
            xloc_u = 0;
        if (yloc_u >7)
            yloc_u = 7;
        if (xloc_u >7)
            xloc_u = 7;
        int x_change = 0;
        if (xloc_u != xlast)
            x_change = 1;
        int y_change = 0;
        if (yloc_u != ylast)
            y_change = 1;
        if (((User_person->remain_moves)-(y_change+x_change))<0){
            xloc_u = xlast;
            yloc_u = ylast;
            x_change = 0;
            y_change = 0;
            }
        
        
        int unit_index = unitsMap1_1[yloc_u][xloc_u];
        int unit_index_R = 0;  
        int alliance = 3;
        if ((User_person->job.rng == 2)&&((xloc_u!=xlast)||(yloc_u!=ylast))){
            int yloc_R = yloc_u + (yloc_u - ylast);
            int xloc_R = xloc_u + (xloc_u - xlast);
            if ((xloc_R <=7)&&(xloc_R>=0)&&(yloc_R>=0)&&(yloc_R <=7)){
                unit_index_R = unitsMap1_1[yloc_u][xloc_u]; 
                if (unit_index_R != 0){
                    person_t* target_R;
                    target_R = person_array[unit_index_R];
                    alliance = target_R->FoF;
                    if(((xloc_u!=xlast)||(yloc_u!=ylast))&& (alliance != (User_person-> FoF)))
                    {
                        combat(User_person, target_R);
                        User_person->remain_moves = 0;
                        state = 0;
                        return 0;
                    }
                }
            }
        }
        if (unit_index != 0){
            person_t* target;
            target = person_array[unit_index];
            alliance = target->FoF;
            if (User_person->job.rng == 2){
                m.speed(1.0);
                xloc_u = xlast;
                yloc_u = ylast;
                x_change = 0;
                y_change = 0;
                wait(1.0);
                m.speed(0.0);
                }
            else if ((alliance ==player_turn)&&(User_person->job.attack != staff)){
                m.speed(1.0);
                xloc_u = xlast;
                yloc_u = ylast;
                x_change = 0;
                y_change = 0;
                wait(1.0);
                m.speed(0.0);
                }
            else if(((xloc_u!=xlast)||(yloc_u!=ylast))&& (alliance != (User_person-> FoF)))
            {
                combat(User_person, target);
                User_person->remain_moves = 0;
                state = 0;
                return 0;
            }
            else if(((xloc_u!=xlast)||(yloc_u!=ylast))&& ((User_person->job.attack == staff)&&(alliance == (User_person->FoF))))
            {
                heal(User_person, target);
                User_person->remain_moves = 0;
                state = 0;
                return 0;
            }
        }  
        int tile_index = Map1_1[yloc_u][xloc_u];
        tiles check_passable = tile_array[tile_index];
        if ((check_passable.passable) == 1){
            m.speed(1.0); 
            xloc_u = xlast;
            yloc_u = ylast;
            x_change = 0;
            y_change = 0;
            wait(1.0);
            m.speed(0.0);
        }      
        
        if((xlast != xloc_u) || (ylast != yloc_u)){
                tile_index = Map1_1[ylast][xlast];
                unitsMap1_1[ylast][xlast] = 0;
                unitsMap1_1[yloc_u][xloc_u] = User_person->v;
                tiles tile_erased = tile_array[tile_index];
                if (tile_index == 0){
                    uLCD.set_sector_address(tile_erased.x, tile_erased.y);
                    uLCD.display_image(0, 0);
                    }
                else{
                    uLCD.set_sector_address(tile_erased.x, tile_erased.y);
                    uLCD.display_image(xlast*16, ylast*16);
                    }
                uLCD.set_sector_address(User_person->job.x,User_person->job.y);
                User_person->xloc = xloc_u;
                User_person->yloc = yloc_u;
                User_person->xlast = xloc_u;
                User_person->ylast = yloc_u;
                User_person->remain_moves = (User_person->remain_moves) - x_change - y_change;
                uLCD.display_image(((User_person->xloc)*16), ((User_person->yloc)*16));    
        }    
}    
    state = 0;
    return 0;
}

int analog2Keypad(SparkfunAnalogJoystick *joystick) {
    if (joystick->distance() > .1) { //not in deadzone, accept input
        if ((joystick->angle() > 0.0 && joystick->angle() < 22.5) ||(joystick->angle() > 337.5 && joystick->angle() < 360.0)) {
            return 6;
        } else if (joystick->angle() >= 22.5 && joystick->angle() < 67.5) {
            return 9;
        } else if (joystick->angle() >= 67.5 && joystick->angle() < 112.5) {
            return 8;    
        } else if (joystick->angle() >= 112.5 && joystick->angle() < 157.5) {
            return 7;
        } else if (joystick->angle() >= 157.5 && joystick->angle() < 202.5) {
            return 4;
        } else if (joystick->angle() >= 202.5 && joystick->angle() < 247.5) {
            return 1;
        } else if (joystick->angle() >= 247.5 && joystick->angle() < 292.5) {
            return 2;
        } else if (joystick->angle() >= 292.5 && joystick->angle() < 337.5) {
            return 3;
        }
    } else {
        return 5;
    }
}

int combat(person_t* attacker, person_t* defender){
    int d_health;
    if (attacker->job.attack == magic){
        d_health = (defender->health)-((attacker->job.damage)-(defender->job.defence));
        }
    else if (attacker->job.attack == dagger){
        d_health = (defender->health)-((attacker->job.damage)-((defender->job.defence)/2));
        }
    else{
        d_health = (defender->health)-((attacker->job.damage)-(defender->job.res));
        }
    int a_health;
    if (d_health < (defender->health))
        defender->health = d_health;
    if (((defender->health)>0)&&(attacker->job.rng==1)){
        a_health = (defender->health)-(((attacker->job.damage)-(defender->job.defence))/2);
        attacker->health = a_health;
        }
    //pc.printf("attacker health %d \n",attacker->health);
    //pc.printf("defender health %d \n",defender->health);
    combatPhase(attacker->v, defender->v);
    if ((defender->health)<=0)
        kill_unit(defender);
    if ((attacker->health)<=0)
        kill_unit(attacker);
    
    
    return 0;
}
    
    
int heal(person_t* attacker, person_t* defender){
    int d_health = (defender->health)+(attacker->job.damage);
    if (d_health > defender->job.maxHealth)
        d_health = defender->job.maxHealth;
    if (d_health != (defender->health))
        defender->health = d_health;
    pc.printf("attacker health %d \n",attacker->health);
    pc.printf("defender health %d \n",defender->health);
    
    
    return 0;
}    

void kill_unit(person_t* dead_unit){
    int xloc = dead_unit->xloc;
    int yloc = dead_unit->yloc;
    unitsMap1_1[yloc][xloc] = 0;
    int tile_index = Map1_1[yloc][xloc];
    tiles tile_dead_spot;
    tile_dead_spot = tile_array[tile_index];
    uLCD.set_sector_address(tile_dead_spot.x,tile_dead_spot.y);
    uLCD.display_image(((dead_unit->xloc)*16), ((dead_unit->yloc)*16));    
    dead_unit->status = 0;
    return;
    }
    
    
void ai_movement(){
    int ai_r;
    int ai_col;
    int notdead;
    notdead = 0;
    person_t* ai_unit;
    for( ai_r = 0; ai_r<8; ai_r++){
        for( ai_col = 0; ai_col<8; ai_col++){
            if (unitsMap1_1[ai_r][ai_col] > 10){
                notdead = 1;
                ai_unit = person_array[unitsMap1_1[ai_r][ai_col]];
                //find enemy
                //move to enemy
                find_player(ai_unit);
                
                
            }
        }
    }
    if(notdead == 0)
        ask_nextstage();
}

void find_player(person_t* ai_pred){
    int xloc = ai_pred->xloc;
    int yloc = ai_pred->yloc;
    person_t* ai_target;
    int movement = ai_pred->remain_moves;
    int movement_vert;
    int movement_horiz;
    int y;
    int x;
    int negy;
    int negx;
    //parse unit array near me for enemy
    for(movement_vert = 0; movement_vert < movement; movement_vert++){
        for(movement_horiz = 0; movement_horiz < (movement -movement_vert); movement_horiz++){
            y = movement_vert + yloc;
            if(y<0)
                y = 0;
            if(y>7)
                y=7;
            x = movement_horiz + xloc;
            if(x<0)
                x = 0;
            if(x>7)
                x=7;
            negx = xloc - movement_horiz;
            if(negx<0)
                negx = 0;
            if(negx>7)
                negx=7;
            negy = yloc - movement_vert;
            if(negy<0)
                negy = 0;
            if(negy>7)
                negy=7;
            if((unitsMap1_1[y][x]<10) && (unitsMap1_1[y][x] !=0)){
                ai_target = person_array[unitsMap1_1[y][x]];
                hunt_player(ai_pred, ai_target, x, y, xloc, yloc);
            }
            else if((unitsMap1_1[y][negx]<10) && (unitsMap1_1[y][negx] !=0)){
                ai_target = person_array[unitsMap1_1[y][negx]];
                hunt_player(ai_pred, ai_target, negx, y, xloc, yloc);
            }
            else if((unitsMap1_1[negy][x]<10) && (unitsMap1_1[negy][x] !=0)){
                ai_target = person_array[unitsMap1_1[negy][x]];
                hunt_player(ai_pred, ai_target, x, negy, xloc, yloc);
            }
            else if((unitsMap1_1[negy][negx]<10) && (unitsMap1_1[negy][negx] !=0)){
                ai_target = person_array[unitsMap1_1[negy][negx]];
                hunt_player(ai_pred, ai_target, negx, negy, xloc, yloc);
            }
        }
    }
}


//move to prey
void hunt_player(person_t* predator, person_t* prey, int prey_x, int prey_y, int predator_x, int predator_y){
    int keypad;
    int count = 0;
    while (count <12){
        count++;
        if ((predator_y - prey_y) >0)
            keypad = 2;
        else if ((predator_y - prey_y) <0)
            keypad = 8;
        if ((predator_x - prey_x) >0)
            keypad = 4;
        else if ((predator_x - prey_x) <0)
            keypad = 6;
        if ( count%2 !=0){
            if ((predator_y - prey_y) >0)
                keypad = 2;
            else if ((predator_y - prey_y) <0)
                keypad = 8;
        }
    person_t* User_person;
    User_person = predator;
    if ((User_person->remain_moves) == 0)
    {
        return;
    }
        if ((User_person->FoF) != player_turn)
    {
        return;
    }
    int xloc_u = 1;
    int yloc_u = 1;
    int xlast = 1;
    int ylast = 1;
    xloc_u = (User_person->xloc);
    yloc_u = User_person->yloc;
    xlast = User_person->xlast;
    ylast = User_person->ylast;
        switch (keypad)
        {
        case 1:
            xloc_u = xloc_u -1;
            yloc_u = yloc_u +1;
            break;
        case 2:
            yloc_u = yloc_u +1;
            break;
        case 3:
            xloc_u = xloc_u +1;
            yloc_u = yloc_u +1;
            break;
        case 4:
            xloc_u = xloc_u -1;
            break;
        case 5:
            break;
        case 6:
            xloc_u = xloc_u +1;
            break;
        case 7:
            xloc_u = xloc_u -1;
            yloc_u = yloc_u -1;
            break;
        case 8:
            yloc_u = yloc_u -1;
            break;
        case 9:
            xloc_u = xloc_u + 1;
            yloc_u = yloc_u - 1;
            break;
        }
        if (yloc_u <0)
            yloc_u = 0;
        if (xloc_u <0)
            xloc_u = 0;
        if (yloc_u >7)
            yloc_u = 7;
        if (xloc_u >7)
            xloc_u = 7;
        int x_change = 0;
        if (xloc_u != xlast)
            x_change = 1;
        int y_change = 0;
        if (yloc_u != ylast)
            y_change = 1;
        if (((User_person->remain_moves)-(y_change+x_change))<0){
            xloc_u = xlast;
            yloc_u = ylast;
            x_change = 0;
            y_change = 0;
            }
        
        
        int unit_index = unitsMap1_1[yloc_u][xloc_u];
        int unit_index_R = 0;  
        int alliance = 3;
        if ((User_person->job.rng == 2)&&((xloc_u!=xlast)||(yloc_u!=ylast))){
            int yloc_R = yloc_u + (yloc_u - ylast);
            int xloc_R = xloc_u + (xloc_u - xlast);
            if ((xloc_R <=7)&&(xloc_R>=0)&&(yloc_R>=0)&&(yloc_R <=7)){
                unit_index_R = unitsMap1_1[yloc_u][xloc_u]; 
                if (unit_index_R != 0){
                    person_t* target_R;
                    target_R = person_array[unit_index_R];
                    alliance = target_R->FoF;
                    if(((xloc_u!=xlast)||(yloc_u!=ylast))&& (alliance != (User_person-> FoF)))
                    {
                        combat(User_person, target_R);
                        User_person->remain_moves = 0;
                        return;
                    }
                }
            }
        }
        if (unit_index != 0){
            person_t* target;
            target = person_array[unit_index];
            alliance = target->FoF;
            if (User_person->job.rng == 2){
                m.speed(1.0);
                xloc_u = xlast;
                yloc_u = ylast;
                x_change = 0;
                y_change = 0;
                wait(1.0);
                m.speed(0.0);
                }
            else if ((alliance ==player_turn)&&(User_person->job.attack != staff)){
                m.speed(1.0);
                xloc_u = xlast;
                yloc_u = ylast;
                x_change = 0;
                y_change = 0;
                wait(1.0);
                m.speed(0.0);
                }
            else if(((xloc_u!=xlast)||(yloc_u!=ylast))&& (alliance != (User_person-> FoF)))
            {
                combat(User_person, target);
                User_person->remain_moves = 0;
                return;
            }
            else if(((xloc_u!=xlast)||(yloc_u!=ylast))&& ((User_person->job.attack == staff)&&(alliance == (User_person->FoF))))
            {
                heal(User_person, target);
                User_person->remain_moves = 0;
                return;
            }
        }  
        int tile_index = Map1_1[yloc_u][xloc_u];
        if (tile_index == 0){
            xloc_u = xlast;
            yloc_u = ylast;
            x_change = 0;
            y_change = 0;
        }      
        
        if((xlast != xloc_u) || (ylast != yloc_u)){
                tile_index = Map1_1[ylast][xlast];
                unitsMap1_1[ylast][xlast] = 0;
                unitsMap1_1[yloc_u][xloc_u] = User_person->v;
                tiles tile_erased = tile_array[tile_index];
                if (tile_index == 0){
                    uLCD.set_sector_address(tile_erased.x, tile_erased.y);
                    uLCD.display_image(0, 0);
                    }
                else{
                    uLCD.set_sector_address(tile_erased.x, tile_erased.y);
                    uLCD.display_image(xlast*16, ylast*16);
                    }
                uLCD.set_sector_address(User_person->job.x,User_person->job.y);
                User_person->xloc = xloc_u;
                User_person->yloc = yloc_u;
                User_person->xlast = xloc_u;
                User_person->ylast = yloc_u;
                User_person->remain_moves = (User_person->remain_moves) - x_change - y_change;
                uLCD.display_image(((User_person->xloc)*16), ((User_person->yloc)*16));    
        }    
    }    
    return;
}




void ask_nextstage(){
    pc.putc(0);
    pc.putc(12);
    pc.putc(1);
    wait(.2);
    pc.putc(stagenumber);
    person_t* save_send_person;
    for(int i = 1; i<12; i++)
    {
        save_send_person = person_array[i];
        pc.putc(save_send_person->status);
    }
    player_turn = 1;
    state = 0;
    //load next map
    //init new map
    while (units_received == 0){
        waitForAck();
    }
    load_floor(stagenumber);
    load_units_map();
    
    
    return;    
}

void load_units_map(){
    int y_num;
    int x_num;
    int castle_drawn;
    castle_drawn = 0;
    Julio_Mbed.putc(2);
    Julio_Mbed.putc(stagenumber);
    tiles tile_draw; 
    person_t* draw_unit;
    //draw map
    for( y_num = 0; y_num<8; y_num++){
        for( x_num = 0; x_num<8; x_num++){
            tile_draw = tile_array[Map1_1[y_num][x_num]];
            if(Map1_1[y_num][x_num]!=0){
            uLCD.set_sector_address(tile_draw.x,tile_draw.y);
            uLCD.display_image((16*x_num),(16*y_num));
            }
            else if((Map1_1[y_num][x_num]==0)&&(castle_drawn==0)){
            uLCD.set_sector_address(tile_draw.x,tile_draw.y);
            uLCD.display_image((16*x_num),(16*y_num));
            castle_drawn = 1;  
            }
        }
    }
    //load and draw units on the map
    for( y_num = 0; y_num<8; y_num++){
        for( x_num = 0; x_num<8; x_num++){
            if(unitsMap1_1[y_num][x_num] != 0){
               draw_unit = person_array[unitsMap1_1[y_num][x_num]];
               draw_unit->xloc = x_num;
               draw_unit->yloc = y_num;
               draw_unit->xlast = x_num;
               draw_unit->ylast = y_num;
               draw_unit->health = draw_unit->job.maxHealth;
               draw_unit->remain_moves = draw_unit->job.movement;
               draw_unit->status = 1;
               uLCD.set_sector_address(draw_unit->job.x,draw_unit->job.y);
               uLCD.display_image((16*x_num),(16*y_num));
            }
        }
    }
    
    
    
    units_received=0;
    return;    
}


 
void sendMap()
{
    for(int i = 0; i < 8; i++) 
    {
        for(int j = 0; j < 8; j++)
        {
            pc.putc(Map1_1[i][j]);
        }
    }
}
 
void sendUnits()
{
    for(int a = 0; a < 8; a++) 
    {
        for(int b = 0; b < 8; b++)
        {
            pc.putc(unitsMap1_1[a][b]);
        }
    }
}
 
void receiveMap()
{
    for(int c = 0; c < 8; c++)
    {
        for(int d = 0; d < 8; d++)
        {
            while(!pc.readable()){}
            Map1_1[c][d] = pc.getc();
        }   
    }
}
 
void receiveUnits()
{
    for(int c = 0; c < 8; c++)
    {
        for(int d = 0; d < 8; d++)
        {
            while(!pc.readable()){}
            unitsMap1_1[c][d] = pc.getc();
        }   
    }
    units_received = 1;
    for(int q = 0; q < 8; q++)
    {
        for(int w = 0; w < 8; w++)
        { 
            uLCD.printf("%d", Map1_1[q][w]);
        }   
    }
}
 
void waitForAck()
{
    char command[2];
    command[0] = '0';
    led3=!led3;
    while(pc.readable())
    {
        led4=!led4;
        command[0] = pc.getc();
        if(command[0] == 'm')
        {
            led1 = !led1;
            sendMap();
        }
        if(command[0] == 'u')
        {
            sendUnits();
            led1 = !led1;
            
            //uLCD.printf("enter combat phase");
            //combatPhase();
        }
        if(command[0] == 's')
        {            
            receiveMap();
            led2 = !led2;
        }
        if(command[0] == 'z')
        {
            receiveUnits();
            led2 = !led2;
        }
        if(command[0] == 'f'){
            //loadFile();
            led3 = !led3;
        }
    }
}
 
 
void combatPhase(char a, char d)
{
    pc.putc('1');
    pc.putc(a);
    pc.putc(d);
    led4 = 1;
    return;
}