#include "mbed.h"
#include "Header_file.h"
#include <iostream>
#include <string>

//To-do list:
//Bluetooth input for strings
//Modify dot/dash for speaker/LED output
//Give user output/UI for game
//Traverse the tree using telegraph key
//Make menus/UI look pretty

//
RawSerial  pc(USBTX, USBRX);//pc serial out
Serial  dev(p13,p14);//serial text input from bluetooth module
DigitalOut led1(LED1);  //For spacing between character. Denotes the end of a character


//Variables
char string_input[20];

void dev_recv() //Funtion that reads in text from bluetooth, and calls the text to morse conversion function
{
    if(dev.readable()){             //scan in inout string
            dev.scanf("%s",string_input);
    }
    
    int string_length = strlen(string_input);
    
    for(int i = 0; i<string_length; i++) { //call Text_to_morse() function on each character of input string
        wait(1.0);
        Text_to_morse(string_input[i]);
        led1 = !led1;   //blink to denote end of current character output
        wait(0.1);
        led1 = !led1;
    }
}


//Part 1
//Main takes in string text input from bluetooth module. Store in string variable
//call text_to_morse function on each character from input string variable

int main() {
    
    //Function call for bluetooth text input
    dev.attach(&dev_recv, Serial::RxIrq); //calls text_to_morse function on bluetooth text inputs
    
    //Variable word list for the game portion
    //Feel free to add words, just update the array size
    string wordlist[20] = {"Dog","Cat","Car","Tree","Star","Radio","Tea","Book","Hello","Bank","Bird","Bus","Red","Green","Blue","Coat","Dress","Shirt","Egg","Pear"};
    
    
    //Creation of the binary search tree//
    //I need to insert 2,8,9,0,+//
    node * newRoot = new node;
    insertdot('e', newRoot);
    node * eNode = newRoot->dot;
    insertdash('a', eNode);
    insertdot('i', eNode);
    cout << returnvalue(eNode->dash) <<endl;
    node * iNode = eNode->dot;
    insertdash('u',iNode);
    insertdot('s',iNode);
    node *  sNode = iNode->dot;
    insertdash('v',sNode);
    insertdot('h',sNode);
    node * hNode = sNode->dot;
    insertdash('4',hNode);
    insertdot('5',hNode);
    node * vNode = sNode->dash;
    insertdash('3',vNode);
    node * uNode = iNode->dash;
    insertdot('f',uNode);
    node * aNode = eNode->dash;
    insertdot('r',aNode);
    insertdash('w',aNode);
    node * rNode = aNode->dot;
    insertdot('l',rNode);
    node * wNode = aNode->dash;
    insertdot('p',wNode);
    insertdash('j',wNode);
    node * jNode = wNode->dash;
    insertdash('1',jNode);
    insertdash('t',newRoot);
    node * tNode = newRoot->dash;
    insertdot('n',tNode);
    insertdash('m',tNode);
    node * nNode = tNode->dash;
    insertdot('d',nNode);
    insertdash('k',nNode);
    node * dNode = nNode->dot;
    insertdot('b',dNode);
    insertdash('x',dNode);
    node * bNode = dNode->dot;
    insertdot('6',bNode);
    insertdash('=',bNode);
    node * xNode = dNode->dash;
    insertdot('/',xNode);
    node * kNode = nNode->dash;
    insertdot('c',kNode);
    insertdash('y',kNode);
    node * mNode = tNode->dash;
    insertdot('g',mNode);
    insertdash('o',mNode);
    node * gNode = mNode->dot;
    insertdot('z',gNode);
    insertdash('q',gNode);
    node * zNode = gNode->dot;
    insertdot('7',zNode);
    
    //Syntax for traversing the tree
    /*node * newNode = new node;
    newNode = newRoot;
    
    *newNode = traverseDot(newNode);
    cout << returnvalue(newNode) << " return new node" << endl;*/
    
    string newString = "YYZ";
    
    for (int i = 0; i < newString.length(); i++){
        //Text_to_morse(newString[i]);
    }
    
    char schar = 's';
    char ochar = 'o';
    while(1) {
        uLCD.printf("do this\n");
        //Text_to_morse(schar);
//        Text_to_morse(ochar);
//        Text_to_morse(schar);
        wait(0.5);
    }
}
