/*******************************************************************/
/*                                                                 */
/*                Synchronisation                                  */
/*                                                                 */
/*  Procédures de synchronisation des piles du pont Bacalan        */
/*                                                                 */
/*                                                                 */
/*******************************************************************/
#ifndef _SYNCHRO_
#define _SYNCHRO_

#include "mbed.h"
#include "Constantes.h"
#include "Variable.h"



/**     void    vSynchronise ( U8 Mode_Synchronisation, U8 Sens )
*       Procédure appelée à chaque cycle (100ms) pour corriger la vitesse des piles en fonction de leur hauteur
*       @param <Mode_Synchronisation>   Mode choisi par l'utilisateur
*                                       CUSTOM : votre procedure de synchronisation est utilisée
*                                       DEUX_VITESSES : La pile en avance passe en vitesse lente pour se laisser rattraper
*                                       AUCUN : La consigne de vitesse est constante pour les 2 piles
*
*       @param <Sens>                   Sens du déplacement
*                                       MONTE
*                                       DESCEND
*
*       Utilise les variables:
*       Consigne_Vitesse_Auto           Consigne de vitesse demandé par l'utilisateur (tr/min)
*       Consigne_Vitesse_RD             Consigne de vitesse calculée pour la rive droite (tr/min)
*       Consigne_Vitesse_RG             Consigne de vitesse calculée pour la rive gauche (tr/min)
*       Hauteur_RG                      Hauteur de la pile gauche (mm)
*       Hauteur_RD                      Hauteur de la pile droite (mm)
*/
extern  void    vSynchronise ( U8 Mode_Synchronisation, U8 Sens ) ;
extern  void    vSynchro_Initialise ( void ) ;


#endif