/*******************************************************************/
/*                                                                 */
/*                 Port Série                                      */
/*                                                                 */
/*  Gestion du port série par interruption                         */
/*                                                                 */
/*                                                                 */
/*******************************************************************/

#include "mbed.h"
#include "Port_Serie.h"
#include "Modbus.h"

Serial  RS(p28 , p27) ;
Serial PC8(USBTX, USBRX) ;
Timer   Chrono_Serie ;

volatile    U8  Buffer_Emission_U8[TAILLE_BUFFER_EMISSION] ;
volatile    U8  Pointeur_Emission_U8 ;
volatile    U8  Nb_Caracteres_A_Emettre_U8 ;
volatile    U8  Buffer_Reception_U8[TAILLE_BUFFER_RECEPTION] ;
volatile    U8  Pointeur_Reception_U8 ;
volatile    U8  Nb_Caracteres_Attendus ;
volatile    U8  Numero_Ordre_En_Reception_U8 ;
volatile    U8  Numero_Ordre_En_Emission_U8 ;
volatile    U8  Index ;
volatile    S32 Date_Dernier_Caractere_S32 ;
volatile    S32 Temps_alloue_Reception_S32 ;
static      S32 Temps_alloue_Caractere_S32 ;

/******* Réception sous interruption ***************************/
void    iReception_Serie ()
    { 
    U8 Car ; 
    // Si premier caractere recu, enclenche le chrono
    if ( Pointeur_Reception_U8 == 0 )
        {
        //Chrono_Serie.start() ;
        }
    // Si il y a des caractères dans le buffer
    while ( RS.readable() )
        {// Réception d'un caractère
        Car=RS.getc();
        Buffer_Reception_U8 [ Pointeur_Reception_U8 ] = Car ;
        //RS.putc(Car) ;
        Pointeur_Reception_U8++ ;
        }
    if ( ( Pointeur_Reception_U8 > 0 )
        &&( Ordres[Numero_Ordre_En_Reception_U8].Etat_U8 == ATTENTE ) )
        {// Si au moins un caractère recu, la réception est en cours
        Ordres[Numero_Ordre_En_Reception_U8].Etat_U8 = RECEPTION ;
        }
    //PC8.printf("\r\n    Serie : Reception %s ", &Buffer_Reception_U8 [0]) ;
    
    //Date_Dernier_Caractere_S32 = Chrono_Serie.read_us() ;
    // Analyse de la trame
    if ( ( Buffer_Reception_U8 [ 0 ] == SLAVE_ID )
        || ( Buffer_Reception_U8 [ 0 ] == MB_ADDRESSE_BROADCAST ) )
        {// Adresse de l'esclave, ou Adresse de broadcast
        //PC8.printf("\r\n    Serie : Adresse %i ", Buffer_Reception_U8 [0]) ;
        if ( Pointeur_Reception_U8 >= 6 ) 
            {
            //PC8.printf("\r\n    Serie : Func %i ", Buffer_Reception_U8 [1]) ;           
            if (( Buffer_Reception_U8 [ 1 ] == MB_FUNC_READ_HOLDING_REGISTER )
                ||( Buffer_Reception_U8 [ 1 ] == MB_FUNC_READ_INPUT_REGISTER ))
                {// Fonction 3 ou 4, Lecture de registres
                Nb_Caracteres_Attendus = 8 ;
                //PC8.printf("\r\n    Serie : Func %i ", Buffer_Reception_U8 [1]) ;
                }
            else if ( Buffer_Reception_U8 [ 1 ] == MB_FUNC_WRITE_MULTIPLE_REGISTERS )
                {// Fonction 16 (0x10), écriture de registres
                Nb_Caracteres_Attendus = 9 + Buffer_Reception_U8 [ 5 ] * 2 ;
                }
            }  
            
        if ( Pointeur_Reception_U8 >= Nb_Caracteres_Attendus )
            {
            // On a recu une trame complète
            //PC8.printf("\r\n    Serie : trame %d complete %d / %d",Numero_Ordre_En_Reception_U8,Pointeur_Reception_U8,Nb_Caracteres_Attendus) ;

                Index = 0 ;
                //Chrono_Serie.stop() ;
                while( Index <  Pointeur_Reception_U8 )
                    {// Copie la trame dans l'ordre en cours de réception
                    Ordres[Numero_Ordre_En_Reception_U8].Trame_Recue_aU8[Index] = Buffer_Reception_U8 [ Index ] ;
                    Index++ ;
                    }
            // Nombre de caractères de l'ordre
            Ordres[Numero_Ordre_En_Reception_U8].Nb_Caracteres_Recus_U8 = Pointeur_Reception_U8 ;   
            // Fin de réception
            Ordres[Numero_Ordre_En_Reception_U8].Etat_U8 = RECU ;
            
            }
        
        }
    else 
        {
        // Le message n'est pas pour nous, on purge le buffer
        Pointeur_Reception_U8 = 0 ;
        Ordres[Numero_Ordre_En_Reception_U8].Etat_U8 = ATTENTE ;
        Nb_Caracteres_Attendus = TAILLE_BUFFER_RECEPTION ;
        //Chrono_Serie.stop() ;
        PC8.printf("\r\n    Serie : pas pour nous %i ",Buffer_Reception_U8 [ 1 ]) ;
        }
    
    }
/************ Enclenchement de la réception *****************/  
void    vPort_Serie_Reception ( U8 Numero_Ordre_U8 ) 
    {
    if ( (Ordres[Numero_Ordre_En_Reception_U8].Etat_U8 != RECEPTION )
        && (Ordres[Numero_Ordre_En_Reception_U8].Etat_U8 != ATTENTE ))
        {// La réception en cours est terminée
        if ( ( Ordres[Numero_Ordre_U8].Etat_U8 == RECU )
            ||( Ordres[Numero_Ordre_U8].Etat_U8 == TRAITE )
            ||( Ordres[Numero_Ordre_U8].Etat_U8 == ARRET ) )
            {// L'ordre est pret à être recu
            Numero_Ordre_En_Reception_U8 =  Numero_Ordre_U8 ;
            Ordres[Numero_Ordre_En_Reception_U8].Etat_U8 = ATTENTE ;
            Pointeur_Reception_U8 = 0 ;
            Nb_Caracteres_Attendus = TAILLE_BUFFER_RECEPTION ;
            //PC8.printf("\r\n Debut reception %i Etat %i ",Numero_Ordre_En_Reception_U8,Ordres[Numero_Ordre_En_Reception_U8].Etat_U8) ;
            }
        //PC8.printf("\r\n Reception1 %i Etat %i ",Numero_Ordre_U8,Ordres[Numero_Ordre_U8].Etat_U8) ;
        }
    //PC8.printf("\r\n Reception2 %i Etat %i ",Numero_Ordre_En_Reception_U8,Ordres[Numero_Ordre_En_Reception_U8].Etat_U8) ;
    }
/************ Emission de la trame ************************/
void    iEmission ( void )
    {
    // Si le buffer n'est pas saturé et qu'il reste des caractères à émettre
    while ( ( Pointeur_Emission_U8 < Nb_Caracteres_A_Emettre_U8 ) )  
        {// Emission d'un caractère
        RS.putc( (U8) Buffer_Emission_U8[ Pointeur_Emission_U8 ] ) ;
        Pointeur_Emission_U8++ ;
        //PC8.printf("\r\n    Serie : Emission %i ", Buffer_Emission_U8[ Pointeur_Emission_U8-1 ]) ;
        }
    if (  Pointeur_Emission_U8 >= Nb_Caracteres_A_Emettre_U8 )
        {// Tous les caractères sont émis, cloture l'émission
        Ordres[Numero_Ordre_En_Emission_U8].Etat_U8 = FIN ;
        Pointeur_Emission_U8 = 0 ;
        Nb_Caracteres_A_Emettre_U8 = 0 ;
        }
    else
        {// Le buffer est saturé, on reviendra plus tard
        
        }
    }  
/************ Emission de la réponse ************************/
void    vPort_Serie_Emission ( U8   Numero_Ordre_U8 )
    {
    U8  Index_U8 ;
    
    
    if (Ordres[Numero_Ordre_En_Emission_U8].Etat_U8 != EMISSION )
        {// L'émission en cours est terminée
        if (Ordres[Numero_Ordre_U8].Etat_U8 == TRAITE )
            {// L'ordre est pret à être émis
            Ordres[Numero_Ordre_U8].Etat_U8 = EMISSION ;
            Numero_Ordre_En_Emission_U8 = Numero_Ordre_U8 ;
            Nb_Caracteres_A_Emettre_U8 = Ordres[Numero_Ordre_U8].Nb_Caracteres_A_Emettre_U8 ;
            Index_U8 = 0 ;
            // Copie la trame dans le buffer
            while( Index_U8 < Nb_Caracteres_A_Emettre_U8 )
                {
                Buffer_Emission_U8 [ Index_U8 ] = Ordres[Numero_Ordre_U8].Trame_Reponse_aU8 [Index_U8] ;
                Index_U8++ ;
                }
            Pointeur_Emission_U8 = 0 ;
            }
        
        //PC8.printf("\r\n    Serie : Emission %i : %i/%i",Numero_Ordre_En_Emission_U8, Pointeur_Emission_U8,Nb_Caracteres_A_Emettre_U8) ; 
        }
    // Emission de la trame
    iEmission() ;
    }
/************ Initialisation du Port ************************/
void    vPort_Serie_Init(int Baudrate) 
    {
    // Initialisation du port RS
    RS.baud(Baudrate) ;
    // Purge des buffers
    for ( Pointeur_Emission_U8 = 0 ; Pointeur_Emission_U8 < TAILLE_BUFFER_EMISSION ; Pointeur_Emission_U8++ )
        {
        Buffer_Emission_U8[Pointeur_Emission_U8] = 0 ;
        }
    for ( Pointeur_Reception_U8 = 0 ; Pointeur_Reception_U8 < TAILLE_BUFFER_RECEPTION ; Pointeur_Reception_U8++ )
        {
        Buffer_Reception_U8[Pointeur_Reception_U8] = 0 ;
        }
    
    Pointeur_Emission_U8 = 0 ;
    Pointeur_Reception_U8 = 0 ;
    Numero_Ordre_En_Reception_U8 = 0 ;
    Numero_Ordre_En_Emission_U8 = 0 ;
    //PC8.printf("\r\n    Serie : Init %i ", Baudrate) ;
    // Temps alloué pour 1 caractere = 10bits / Baudrate x 1E6 us
    Temps_alloue_Caractere_S32 = 10000000 / Baudrate * 3 ;
    }
    
/************ Ouverture du port Série **********************/
void    vPort_Serie_Ouvre(void) 
    {
    // Purge du buffer de réception
    while( RS.readable() )
        {
        Buffer_Reception_U8[0] = RS.getc() ;
        }
    Buffer_Reception_U8[0] = 0 ;
    
    vPort_Serie_Reception ( 0 ) ;
    RS.attach (&iReception_Serie , RS.RxIrq) ;
    
    //RS.printf ("Debut") ;
    //PC8.printf("\r\n    Serie : Attach ") ;
    
    }
 
/************ Controle de réception **********************/    
U8    cControle_Reception( U8 Numero_Ordre_U8 )
    {/*
    if ( Numero_Ordre_U8 != Numero_Ordre_En_Reception_U8 )
        {// La réception est arrétée
        //Chrono_Serie.stop() ;
        return ( ARRET ) ;
        }
    if ( Chrono_Serie.read_us() > ( Temps_alloue_Caractere_S32 * Nb_Caracteres_Attendus ) )
        {// Dépassement du temps alloué
        //Chrono_Serie.stop() ;
        Numero_Ordre_En_Reception_U8++ ;
        Pointeur_Reception_U8 = 0 ;
        Nb_Caracteres_Attendus = TAILLE_BUFFER_RECEPTION ;
        
        return ( TIMEOUT ) ;
        }*/
    return ( RECEPTION ) ;
    }
   
/************ Fermeture du port Série **********************/   
void    vPort_Serie_Ferme( void ) 
    {
    //RS.detach() ;
    }
 
/************ Cloture du port Série **********************/    
void    vPort_Serie_Cloture( void ) 
    {
    }