#ifndef pulsegenerator__H
#define pulsegenerator__H

#include "Param.h"
#include "pinmap.h"
#include "rtos.h"
#include "serial.h"
#include <time.h>


/******************************************
* Setup the pulse generator on device startup
* Drives pulse output pins to safe values
*/
void pulsegenerator_initialize ();

/******************************************
* Set the current pace period
* Inputs: new_pace_period_ms - the pace period to switch to
* Returns: The previous pace period
*/
uint32_t set_pace_period_ms(uint32_t new_pace_period_ms);

/******************************************
* Initiates pacing. Returns immediately
*/
void begin_pace ();

void serialCheck(string check);
void egramSend(void);

#endif