#include "pulsegenerator.h"


Param *INPUTS;

string        none = "N";
string        transmit = "TR";
string        rec = "RE";
string        egramTog = "ET";

bool          egram = true;

string        AOO = "AOO";
string        VOO = "VOO";
string        VVI = "VVI";

uint8_t initialized = 0;

int pace_period_ms;

/******************************************
 *
 *       Pacing Mode Functions
 *
 *******************************************

//
//Deactivates both pacing circuits
//Cancels any existing pace event
*/

void pace_charge_shutdown () {
    /* Stage 1: Switch-OFF/Ground-ON */
    atr_pace_ctrl =  LOW;
    vent_pace_ctrl = LOW;
    atr_grnd_ctrl  = HIGH;
    vent_grnd_ctrl = HIGH;
    wait_ms(50);
    

    /* Stage 2: Ref PWM LOW */
    pacing_ref_pwm = LOW;
    wait_ms(100);

    /* Stage 3: Charge CTRL off */
    pace_charge_ctrl = LOW;
    wait_ms(10);
    
    /* Stage 4: Ground OFF */
    atr_grnd_ctrl  = LOW;
    vent_grnd_ctrl = LOW;
}

void pulsegenerator_initialize () {
    if (initialized) return;
    pace_charge_shutdown ();
    initialized = 1;
    wait(1);
}

/*
  Prep the circuit for Ventricle Pace Event
*/
void vent_pace_prime () {
    /* Redundant code to close ground switches, 
     * prevents accidentally shorting the pacemaker
     */ 
    atr_grnd_ctrl  = LOW;
    vent_grnd_ctrl = LOW;
    
    /* Stage 1: Ref PWM On */
    pacing_ref_pwm = HIGH;
    wait_ms(10);

    /* Stage 2: Charge CTRL on */
    pace_charge_ctrl = HIGH;
    wait_ms(10);
}

/*
  Prep the circuit for Atrium Pace Event
*/
void atr_pace_prime () {
    /* Redundant code to close ground switches, 
     * prevents accidentally shorting the pacemaker
     */ 
    atr_grnd_ctrl  = LOW;
    vent_grnd_ctrl = LOW;
    
    /* Stage 4: Ref PWM On */
    pacing_ref_pwm = HIGH;
    wait_ms(10);

    /* Stage 5: Charge CTRL on */
    pace_charge_ctrl = HIGH;
    wait_ms(10);
}

void pace_vent (int pulse_width_us) {
    green = 0;
    vent_pace_prime();

    // Begin Pace Event Output
    vent_pace_ctrl = HIGH;
    
    // Pace Duration
    wait_us(pulse_width_us);
    
    // Shut off Pace
    vent_pace_ctrl = LOW;
    
    pace_charge_shutdown (); 
    green = 1;
}

void pace_atr (int pulse_width_us) {
    
    atr_pace_prime();

    // Begin Pace Event Output
    atr_pace_ctrl = HIGH;
    
    // Pace Duration
    wait_us(pulse_width_us);
    
    // Shut off Pace
    atr_pace_ctrl = LOW;
        
    pace_charge_shutdown (); 
}

void pace_VOO () {
    pace_vent ((*INPUTS).getVPulseWidth_us());
}

void pace_AOO () {
    pace_atr ((*INPUTS).getAPulseWidth_us());
}

void pace_VVI() {
    int i = 0;
    while (i >=60){
        if (vent_rect_signal == 0){//if there is no signal on the heart then adda counter and wait a millisecond before checking again
            i++;
            wait_ms(1); // wait one millisecond
            //blue != blue;
            egramSend();
        }
    else{//if there is a signal then there is a heart beat, and the VII will return 0 and wait to be caled on again.
        return;
        }
   }
   
   pace_vent ((*INPUTS).getVPulseWidth_us());//if there is no heartbeat recordered for 60 millaseconds, then it will call on the pacemaker to pulse.
   return;

}

void begin_pace () {
    if (!initialized) pulsegenerator_initialize ();
    
    Param pacemaker("$VOO,60,120,120,150,OFF,50,OFF,3.50,3.50,3.75,3.75,0.40,0.40,0.75,2.50,320,250,250,OFF,OFF,OFF,OFF,20,1,40,Med,30,8,5,*");
    string temp = pacemaker.getParameters();
    (*INPUTS).setParameters(temp);
    //(*INPUTS).setParameters(pacemaker.getParameters());
    //(*INPUTS).setMode("VOO");
    //green = 1;
    //red = 1;
    //blue = 0;
    //wait(1);
    
    //serialCheck(recieve());
    //(*INPUTS).setParameters("$VOO,60,120,120,150,OFF,50,OFF,3.50,3.50,3.75,3.75,0.40,0.40,0.75,2.50,320,250,250,OFF,OFF,OFF,OFF,20,1,40,Med,30,8,5,*");
    blue = 0;
    red = 0;
    green = 1;
    wait(5);
    
    
    while(1){
        pace_period_ms = (*INPUTS).getLowerRateLimit_ms();
        
        if (strcmp((*INPUTS).getMode().c_str(),VOO.c_str()) == 0){
            green = 1;
            blue = 1;
            red = !red;
            wait(1);
            time_t start = time(NULL);
            
            pace_VOO();
            
            time_t now = time(NULL);
            while((now - start) <= pace_period_ms){
                egramSend();
                //wait(2);
                //red = !red;
            }
            //red = !red;
        } else if (strcmp((*INPUTS).getMode().c_str(),AOO.c_str()) == 0) {
            green = 1;
            blue = !blue;
            red = 1;
            wait(1);           
            time_t start = time(NULL);
            
            pace_AOO();
            
            time_t now = time(NULL);
            while((now - start) <= pace_period_ms){
                egramSend();
                //wait(2);
                //green = !green;
            }
            //green = !green;
        } else if (strcmp((*INPUTS).getMode().c_str(),VVI.c_str()) == 0) {
            green = !green;
            blue = 1;
            red = 1;
            wait(1);            
            pace_VVI();
            //blue != blue;
        } else {
            green = 1;
            blue = !blue;
            red = !red;
            wait(1); 
            time_t start = time(NULL);
            
            pace_VOO();
            
            time_t now = time(NULL);
            while((now - start) <= pace_period_ms){
                egramSend();
                //blue = !blue;
                //wait(1);
                //reen = !green;
                //wait(1);
            }
            //blue = 0;
            //green = 0;
        }
        
        //serialCheck(recieve());
        
    }
    
}

/* 
void timer_thread () {
    while (true) {
        paceThread.signal_set(0x4);
        
        wait_ms(pace_period_ms - 180); //delay for every pace call
    }
}

void pace_controller () {
    while(true) {
        Thread::signal_wait(0x0, osWaitForever); //Sleep until next cycle
        
        switch (currentMode) {
            case VOO  : pace_VOO();  break;
            case VOOR : pace_VOOR(); break;
            case AOO  : pace_AOO();  break;
            default   : pace_VOO();  break;
        }
    }
} 
*/

void egramSend(void){
    red = 0;
    green = 0;
    blue = 0;
    if (egram) {
        send("HelloWorld!\r\n");//send data
        send((*INPUTS).getMode());
    } else {
        return;
    }
    wait(1);
    red = 1;
    green = 1;
    blue = 1;
}

void serialCheck(string check){
    if (strcmp(check.c_str(),none.c_str()) == 0){
        return;//continue
    } else if (strcmp(check.c_str(),rec.c_str()) == 0){
        wait_ms(5);
        send("R");//send "RE\n" for recieved
        red = 0;
        blue = 1;
        green = 1;
        send((*INPUTS).getParameters());//send data to DCM
    } else if (strcmp(check.c_str(),egramTog.c_str()) == 0){
        wait_ms(5);
        send("R");//send "RE\n" for recieved
        red = 1;
        blue = 0;
        green = 1;
        //toggle egram variable to start or stop sending
    } else if (strcmp(check.c_str(),transmit.c_str()) == 0){
        wait_ms(5);
        send("R");//send "RE\n" for recieved
        red = 1;
        blue = 1;
        green = 0;
        (*INPUTS).setParameters(recieve());//recieve data from DCM
    } else {
        wait_ms(5);
        send("N");//send "NR\n" for not recieved
        red = 0;
        blue = 0;
        green = 0;
    }
}