#ifndef PARAM_H
#define PARAM_H

#include "pinmap.h"
#include <iostream>
#include <sstream>
#include <cstdlib>
#include <cstring>
#include <string>

using namespace std;

class Param 
{

private:
    string parameters;
     //
    int LowerRateLimit; //
    int UpperRateLimit; //
    int MaximumSensorRate; //
    int FixedAVDelay; //
    string DynamicAVDelay; //
    int MinimumDynamicAVDelay; //
    int SensedAVDelayOffset; //
    double APulsedAmplitudeRegulated; //
    double VPulseAmplitudeRegulated; //
    double APulseAmplitudeUnregulated; //
    double VPulseAmplitudeUnregulated; //
    double APulseWidth; //
    double VPulseWidth; //
    double ASensitivity; //
    double VSensitivity; //
    int AtrRP; //
    int VentRP; //
    int PVARP; //
    int PVARPExt; //
    int HysteresisRateLimit; //
    int RateSmoothing; //
    string ATRMode; //
    int ATRDuration; //
    int ATRFallbackTime; //
    int VentricularBlanking; //
    string ActivityThreshold; //
    int ReactionTime; //
    int ResponseFactor; //
    int RecoveryTime; //
    
    
   
    /**********************************************
     *
     *   Programmable Parameters Access Functions
     *
     **********************************************/
    
public:
    string paceMode;
    Param();
    Param(string params);
    void concatination();
    int str_to_int(string input);
    double str_to_double(string input);
    string to_string(int input);
    string to_string(double input);
    void paramSet(int index, string input);
    void outputParam();
    void strDissect(string masterString);
    
    string getParameters(){ return parameters; }
    string getMode(){ return paceMode; }
    int getLowerRateLimit(){ return LowerRateLimit; }
    int getLowerRateLimit_ms(){ return (60000/LowerRateLimit); }
    int getUpperRateLimit(){ return UpperRateLimit; }
    int getUpperRateLimit_ms(){ return (60000/UpperRateLimit); }
    int getMaximumSensorRate(){ return MaximumSensorRate; }
    int getMaximumSensorRate_ms(){ return (60000/MaximumSensorRate); }
    int getFixedAVDelay(){ return FixedAVDelay; }
    string getDynamicAVDelay(){ return DynamicAVDelay; }
    int getMinimumDynamicAVDelay(){ return MinimumDynamicAVDelay; }
    int getSensedAVDelayOffset(){ return SensedAVDelayOffset; }
    double getAPulsedAmplitudeRegulated(){ return APulsedAmplitudeRegulated; }
    double getVPulseAmplitudeRegulated(){ return VPulseAmplitudeRegulated; }
    double getAPulseAmplitudeUnregulated(){ return APulseAmplitudeUnregulated; }
    double getVPulseAmplitudeUnregulated(){ return VPulseAmplitudeUnregulated; }
    double getAPulseWidth(){ return APulseWidth; }
    double getAPulseWidth_us(){ return (1000*APulseWidth); }
    double getVPulseWidth(){ return VPulseWidth; }
    double getVPulseWidth_us(){ return (1000*VPulseWidth); }
    double getASensitivity(){ return ASensitivity; }
    double getVSensitivity(){ return VSensitivity; }
    int getAtrRP(){ return AtrRP; }
    int getVentRP(){ return VentRP; }
    int getPVARP(){ return PVARP; }
    int getPVARPExt(){ return PVARPExt; }
    int getHysteresisRateLimit(){ return HysteresisRateLimit; }
    int getHysteresisRateLimit_ms(){ return (60000/HysteresisRateLimit); }
    int getRateSmoothing(){ return RateSmoothing; }
    string getATRMode(){ return ATRMode; }
    int getATRDuration(){ return ATRDuration; }
    int getATRFallbackTime(){ return ATRFallbackTime; }
    int getVentricularBlanking(){ return VentricularBlanking; }
    string getActivityThreshold(){ return ActivityThreshold; }
    int getReactionTime(){ return ReactionTime; }
    int getResponseFactor(){ return ResponseFactor; }
    int getRecoveryTime(){ return RecoveryTime; }
    
    void setParameters(string inParam){ strDissect(inParam); }
    void setMode(string inParam){ paceMode = inParam; }
    void setLowerRateLimit(int inParam){ LowerRateLimit = inParam; }
    void setUpperRateLimit(int inParam){ UpperRateLimit = inParam; }
    void setMaximumSensorRate(int input){ MaximumSensorRate = input; }
    void setFixedAVDelay(int input){ FixedAVDelay = input; }
    void setDynamicAVDelay(string input){ DynamicAVDelay = input; }
    void setMinimumDynamicAVDelay(int input){ MinimumDynamicAVDelay = input; }
    void setSensedAVDelayOffset(int input){ SensedAVDelayOffset = input; }
    void setAPulsedAmplitudeRegulated(double input){ APulsedAmplitudeRegulated = input; }
    void setVPulseAmplitudeRegulated(double input){ VPulseAmplitudeRegulated = input; }
    void setAPulseAmplitudeUnregulated(double input){ APulseAmplitudeUnregulated = input; }
    void setVPulseAmplitudeUnregulated(double input){ VPulseAmplitudeUnregulated = input; }
    void setAPulseWidth(double input){ APulseWidth = input; }
    void setVPulseWidth(double input){ VPulseWidth = input; }
    void setASensitivity(double input){ ASensitivity = input; }
    void setVSensitivity(double input){ VSensitivity = input; }
    void setAtrRP(int input){ AtrRP = input; }
    void setVentRP(int input){ VentRP = input; }
    void setPVARP(int input){ PVARP = input; }
    void setPVARPExt(int input){ PVARPExt = input; }
    void setHysteresisRateLimit(int input){ HysteresisRateLimit = input; }
    void setRateSmoothing(int input){ RateSmoothing = input; }
    void setATRMode(string input){ ATRMode = input; }
    void setATRDuration(int input){ ATRDuration = input; }
    void setATRFallbackTime(int input){ ATRFallbackTime = input; }
    void setVentricularBlanking(int input){ VentricularBlanking = input; }
    void setActivityThreshold(string input){ ActivityThreshold = input; }
    void setReactionTime(int input){ ReactionTime = input; }
    void setResponseFactor(int input){ ResponseFactor = input; }
    void setRecoveryTime(int input){ RecoveryTime = input; }
    
//    uint16_t get_lower_rate_limit(); // # of pace pulses per minute
//    uint16_t get_lower_rate_limit_period_ms(); // LRL as a period in milliseconds
//    void set_lower_rate_limit(uint16_t lrl);
//    
//    uint16_t get_upper_rate_limit(); // min t b/w vent event and next vent pace
//    uint16_t get_upper_rate_limit_period_ms(); // URL as a period in milliseconds
//    void set_upper_rate_limit(uint16_t url);
//    
//    uint16_t get_max_sensor_rate(); // max rate allowed from adaptive pacing  
//    uint16_t get_max_sensor_rate_period_ms(); // MSR as a period in milliseconds
//    void set_max_sensor_rate(uint16_t msr);
//    
//    uint16_t get_fixed_av_delay_ms();  // time between atrial and vent events in milliseconds
//    void set_fixed_av_delay_ms(uint16_t av_delay_ms);
//    
//    uint16_t get_atr_pulse_width_us();  // duration of atrial pulse in microseconds
//    void set_atr_pulse_width_us(uint16_t atr_pulse_width);
//    
//    uint16_t get_vent_pulse_width_us(); // duration of ventricular pulse in microseconds
//    void set_vent_pulse_width_us(uint16_t v_pulse_width_us);
//    
//    uint16_t get_atr_pulse_amp(); // amplitude of atrial pulses
//    void set_atr_pulse_amp(uint16_t atr_pulse_amp);
//    
//    uint16_t get_vent_pulse_amp(); // amplitude of ventricular pulses
//    void set_vent_pulse_amp(uint16_t vent_pulse_amp);

};

#endif